/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.email.client;

import bitel.billing.module.services.ServicePanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Arrays;
import java.util.Date;
import java.util.Optional;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriod;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.modules.email.common.bean.Domain;
import ru.bitel.bgbilling.modules.email.common.service.EmailService;
import ru.bitel.bgbilling.modules.email.server.bean.Account;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.model.IdTitle;

public class SPP_General
extends ServicePanel {
    private JPasswordField password1_TF = new JPasswordField();
    private JPasswordField password2_TF = new JPasswordField();
    private JCheckBox generate = new JCheckBox("\u0430\u0432\u0442\u043e");
    private BGUComboBox<Domain> domain_CB = new BGUComboBox();
    private BGUComboBox<IdTitle> status_CB = new BGUComboBox();
    private BGUComboBox<KeyValue> quota_CB = new BGUComboBox();
    private JTextField account_TF = new JTextField();
    private JTextArea comment_TA = new JTextArea();
    private BGControlPanelPeriod period = new BGControlPanelPeriod();

    public SPP_General() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        this.status_CB.setData(Arrays.asList(new IdTitle(0, "\u043e\u0442\u043a\u0440\u044b\u0442"), new IdTitle(1, "\u0437\u0430\u043a\u0440\u044b\u0442"), new IdTitle(2, "\u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d")));
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        JPanel accountPanel = new JPanel(new GridBagLayout());
        accountPanel.add((Component)this.account_TF, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 3, 3, 4), 0, 0));
        accountPanel.add((Component)new JLabel("@"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 3, 5), 0, 0));
        accountPanel.add((Component)this.domain_CB, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 3, 3), 0, 0));
        accountPanel.setBorder((Border)new BGTitleBorder(" E-Mail "));
        this.add(accountPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(BGSwingUtilites.wrapBorder(this.status_CB, (String)" \u0421\u0442\u0430\u0442\u0443\u0441 "), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(BGSwingUtilites.wrapBorder(this.quota_CB, (String)" \u041a\u0432\u043e\u0442\u0430 "), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel passwordPanel = new JPanel(new GridBagLayout());
        passwordPanel.add((Component)this.password1_TF, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 1, new Insets(0, 3, 3, 10), 0, 0));
        passwordPanel.add((Component)this.password2_TF, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 1, new Insets(0, 0, 3, 10), 0, 0));
        passwordPanel.add((Component)this.generate, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 3), 0, 0));
        passwordPanel.setBorder((Border)new BGTitleBorder(" \u041f\u0430\u0440\u043e\u043b\u044c "));
        this.add(passwordPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.period, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(BGSwingUtilites.wrapBorder((JComponent)new JScrollPane(this.comment_TA), (String)" \u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 "), new GridBagConstraints(0, 2, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.comment_TA.setMargin(new Insets(3, 3, 3, 3));
        this.comment_TA.setLineWrap(true);
        this.comment_TA.setWrapStyleWord(true);
        this.account_TF.setMinimumSize(new Dimension(110, 25));
        this.account_TF.setPreferredSize(new Dimension(110, 25));
        this.account_TF.setColumns(10);
        this.account_TF.setHorizontalAlignment(0);
        this.password2_TF.setMinimumSize(new Dimension(4, 25));
        this.password2_TF.setPreferredSize(new Dimension(4, 25));
        this.password1_TF.setMinimumSize(new Dimension(4, 25));
        this.password1_TF.setPreferredSize(new Dimension(4, 25));
        this.password1_TF.setText("");
    }

    public boolean updateData() {
        char[] pswd1 = this.password1_TF.getPassword();
        char[] pswd2 = this.password2_TF.getPassword();
        if (Utils.isEmptyString((String)this.period.getDateString1())) {
            ClientUtils.showErrorMessageDialog((String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043d\u0430\u0447\u0430\u043b\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430!");
            return false;
        }
        if (pswd1.length != pswd2.length) {
            ClientUtils.showErrorMessageDialog((String)"\u041f\u0430\u0440\u043e\u043b\u0438 \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u044e\u0442");
            return false;
        }
        for (int i = 0; i < pswd1.length; ++i) {
            if (pswd1[i] == pswd2[i]) continue;
            ClientUtils.showErrorMessageDialog((String)"\u041f\u0430\u0440\u043e\u043b\u0438 \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u044e\u0442");
            return false;
        }
        int accountId = this.id;
        Account account = new Account(accountId).setContractId(this.getContractId()).setAccount(this.account_TF.getText()).setDomainId(((Domain)this.domain_CB.getSelectedItem()).getId()).setPassword(new String(this.password1_TF.getPassword())).setStatus(((IdTitle)this.status_CB.getSelectedItem()).getId()).setQuota(Utils.parseLong((String)((KeyValue)this.quota_CB.getSelectedItem()).getKey())).setComment(this.comment_TA.getText().trim()).setDate1(this.period.getDateFrom()).setDate2(this.period.getDateTo());
        try {
            ((EmailService)this.getContext().getWebService(EmailService.class, this.getContext().getModuleId())).accountUpdate(this.getContractId(), account, this.generate.isSelected());
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
            return false;
        }
        return true;
    }

    public void setData() {
        if (!this.init) {
            this.init();
        }
        int accountId = this.id;
        Account account = new Account();
        if (accountId > 0) {
            try {
                account = Optional.ofNullable(((EmailService)this.getContext().getWebService(EmailService.class, this.getContext().getModuleId())).accountGet(accountId)).orElse(account);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
        int statusId = account.getStatus();
        int domainId = account.getDomainId();
        String quota = String.valueOf(account.getQuota());
        this.account_TF.setText(account.getAccount());
        this.comment_TA.setText(account.getComment());
        this.domain_CB.setSelectedItem(this.domain_CB.getData().stream().filter(a -> a.getId() == domainId).findFirst().orElse(null));
        this.status_CB.setSelectedItem(this.status_CB.getData().stream().filter(a -> a.getId() == statusId).findFirst().orElse(null));
        this.quota_CB.setSelectedItem(this.quota_CB.getData().stream().filter(a -> a.getKey().equals(quota)).findFirst().orElse(null));
        this.password1_TF.setText(account.getPassword());
        this.password2_TF.setText(account.getPassword());
        this.period.setDateFrom(Optional.ofNullable(account.getDate1()).orElse(new Date()));
        this.period.setDateTo(account.getDate2());
        this.account_TF.setEnabled(accountId <= 0);
        this.domain_CB.setEnabled(accountId <= 0);
    }

    private void init() {
        this.init = true;
        try {
            this.quota_CB.setData(((EmailService)this.getContext().getWebService(EmailService.class, this.getContext().getModuleId())).quotaList());
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        try {
            this.domain_CB.setData(((EmailService)this.getContext().getWebService(EmailService.class, this.getContext().getModuleId())).domainList("pos"));
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }
}

