/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.task;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.event.response.RecalculateResponseEvent;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.common.concurrent.FutureResult;

class InetRecalculateResponseEventProcessor
implements EventListener<QueueEvent>,
Serializable {
    Set<Integer> proccedApplicationIds = new HashSet<Integer>();
    private static final Logger logger = LogManager.getLogger();
    private final Map<Integer, Map<Integer, FutureResult<Boolean>>> answers;

    public InetRecalculateResponseEventProcessor(Map<Integer, Map<Integer, FutureResult<Boolean>>> answers) {
        this.answers = answers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(QueueEvent e, EventListenerContext ctx) throws BGException {
        InetRecalculateResponseEventProcessor inetRecalculateResponseEventProcessor = this;
        synchronized (inetRecalculateResponseEventProcessor) {
            RecalculateResponseEvent event = (RecalculateResponseEvent)e;
            int applicationId = event.getApplicationId();
            int index = event.getIndex();
            logger.info("get respone from applicationId=" + applicationId + ", requestIndex = " + index);
            Map<Integer, FutureResult<Boolean>> map = this.answers.get(applicationId);
            if (map == null) {
                logger.error("unknown applicationId :" + applicationId);
                return;
            }
            FutureResult<Boolean> result = map.get(index);
            if (result == null) {
                logger.error("unknown index " + index + " from application " + applicationId);
                return;
            }
            result.set((Object)event.isOk());
            map.remove(index);
        }
    }
}

