/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.radius;

import java.nio.ByteBuffer;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.network.radius.datalog.RadiusDataLogWriter;
import ru.bitel.bgbilling.kernel.network.radius.datalog.hourly.RadiusHourlyDataLogEntry;
import ru.bitel.bgbilling.kernel.network.radius.datalog.hourly.RadiusHourlyDataLogger;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.model.Idable;
import ru.bitel.common.sql.ConnectionSet;

public class RadiusListenerWorkerContext
extends ServerContext {
    private static final Logger logger = LogManager.getLogger();
    private final RadiusHourlyDataLogger dataLogger;
    private long currentHourPart = Long.MIN_VALUE;
    private ConcurrentHashMap<Integer, RadiusHourlyDataLogEntry> hourEntryMap;
    private final WeakHashMap<RadiusHourlyDataLogEntry, RadiusDataLogWriter> writerMap = new WeakHashMap();

    @Deprecated
    public RadiusListenerWorkerContext(Setup setup, int moduleId, RadiusHourlyDataLogger dataLogger) {
        super(setup, ConnectionSet.newInstance((DefaultServerSetup)setup, false), moduleId, -1);
        this.dataLogger = dataLogger;
    }

    public RadiusListenerWorkerContext(Setup setup, int moduleId, boolean autoCommit, RadiusHourlyDataLogger dataLogger) {
        super(setup, ConnectionSet.newInstance((DefaultServerSetup)setup, autoCommit), moduleId, -1);
        this.dataLogger = dataLogger;
    }

    public final void writeRecord(Idable nas, int[] positions, ByteBuffer data, long now) {
        if (this.dataLogger == null) {
            return;
        }
        Long hourPart = now / this.dataLogger.hourPart * this.dataLogger.hourPart;
        if (hourPart != this.currentHourPart) {
            this.hourEntryMap = this.dataLogger.getForHourPart(hourPart);
            this.currentHourPart = hourPart;
        }
        long hour = now / 3600000L * 3600000L;
        RadiusDataLogWriter writer = this.dataLogger.getWriter(this.hourEntryMap, this.writerMap, hour, nas);
        try {
            writer.writeRecord(data, now, positions);
        }
        catch (Exception e) {
            logger.error("IOException", (Throwable)e);
        }
    }
}

