/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.BGTabbedPane;
import bitel.billing.module.common.ComboBoxItem;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.math.BigDecimal;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriod;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGToolTip;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.field.BGFloatTextField;
import ru.bitel.bgbilling.client.common.field.BGIntTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractRemoveRule;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractRemoveRuleService;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractStatusService;
import ru.bitel.bgbilling.kernel.contract.label.client.ContractLabelTree;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.Status;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.list.BGUCheckList;

public class RuleEditor
extends BGUPanel {
    private final BGControlPanelPeriod periodPanel = new BGControlPanelPeriod();
    private final CardLayout cardLayout1 = new CardLayout();
    private final JPanel mainPanel = new JPanel(this.cardLayout1);
    private final JTextField name = new JTextField();
    private final BGIntTextField time = new BGIntTextField();
    private final BGIntTextField timem = new BGIntTextField();
    private final BGFloatTextField money = new BGFloatTextField();
    private final ContractLabelTree labelTree = new ContractLabelTree(true, false, false);
    private final BGUCheckList<Status> statusList = new BGUCheckList();
    private final JTextArea comment = new JTextArea();
    private final BGComboBox<ComboBoxItem> typePeriod = new BGComboBox();
    private ClientContext context;
    private ContractStatusService contractStatusService;
    private ContractRemoveRuleService removeRuleService;
    private ContractRemoveRule currentRemoveRule;
    private boolean init = false;

    public RuleEditor() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    @Override
    public void jbInit() throws Exception {
        if (this.init) {
            return;
        }
        this.init = true;
        this.context = new ClientContext("kernel", 0, -1, -1, "");
        this.labelTree.loadLabels(this.context);
        this.statusList.setData(this.getContractStatusService().statusList());
        JPanel panelForBalance = new JPanel(new GridBagLayout());
        JPanel commentPanel = new JPanel(new GridBagLayout());
        commentPanel.setBorder(new BGTitleBorder(" \u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 "));
        JPanel titlePanel = new JPanel(new GridBagLayout());
        titlePanel.setBorder(new BGTitleBorder(" \u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 "));
        JPanel summaPanel = new JPanel(new GridBagLayout());
        summaPanel.setBorder(new BGTitleBorder(" \u0421\u0443\u043c\u043c\u0430"));
        JPanel timeCountPanel = new JPanel(new GridBagLayout());
        timeCountPanel.setBorder(new BGTitleBorder(" \u0421\u0440\u043e\u043a"));
        JPanel typePeriodPanel = new JPanel(new GridBagLayout());
        typePeriodPanel.setBorder(new BGTitleBorder(" \u0422\u0438\u043f \u0441\u0440\u043e\u043a\u0430"));
        JPanel panelForTime = new JPanel(new GridBagLayout());
        panelForTime.setBorder(new BGTitleBorder(" \u0421\u0440\u043e\u043a"));
        BGTabbedPane tabbedPane = new BGTabbedPane();
        tabbedPane.add("\u041c\u0435\u0442\u043a\u0438", new JScrollPane(this.labelTree));
        tabbedPane.add("\u0421\u0442\u0430\u0442\u0443\u0441", this.statusList);
        this.typePeriod.addItem(new ComboBoxItem(ContractRemoveRule.TypeRuleRemoveByTime.MONTH.ordinal(), ContractRemoveRule.TypeRuleRemoveByTime.MONTH.getDescription()));
        this.typePeriod.addItem(new ComboBoxItem(ContractRemoveRule.TypeRuleRemoveByTime.DAY.ordinal(), ContractRemoveRule.TypeRuleRemoveByTime.DAY.getDescription()));
        this.name.setMinimumSize(new Dimension(160, 21));
        this.name.setColumns(20);
        this.comment.setMinimumSize(new Dimension(0, 51));
        this.comment.setRows(3);
        this.setLayout(new GridBagLayout());
        titlePanel.add((Component)this.name, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        panelForTime.add((Component)this.time, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        summaPanel.add((Component)this.money, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        timeCountPanel.add((Component)this.timem, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        typePeriodPanel.add(this.typePeriod, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        panelForBalance.add((Component)summaPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panelForBalance.add((Component)typePeriodPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panelForBalance.add((Component)timeCountPanel, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.mainPanel.add((Component)panelForTime, "1");
        this.mainPanel.add((Component)panelForBalance, "2");
        commentPanel.add((Component)new JScrollPane(this.comment), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)titlePanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.periodPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.mainPanel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)commentPanel, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)tabbedPane, new GridBagConstraints(3, 0, 1, 2, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void edit(ContractRemoveRule removeRule) {
        this.currentRemoveRule = removeRule;
        if (removeRule == null) {
            return;
        }
        this.name.setText(removeRule.getTitle());
        this.comment.setText(removeRule.getComment());
        this.periodPanel.setDateFrom(removeRule.getDateFrom() != null ? TimeUtils.convertLocalDateToDate(removeRule.getDateFrom()) : null);
        this.periodPanel.setDateTo(removeRule.getDateTo() != null ? TimeUtils.convertLocalDateToDate(removeRule.getDateTo()) : null);
        this.labelTree.setSelectedIds(removeRule.getLabels());
        this.statusList.setSelected(removeRule.getStatuses());
        if (ContractRemoveRule.RemoveRuleType.TIME.equals((Object)removeRule.getRemoveRuleType())) {
            this.time.setText(String.valueOf(removeRule.getTimeCount()));
        } else if (ContractRemoveRule.RemoveRuleType.BALANCE.equals((Object)removeRule.getRemoveRuleType())) {
            this.money.setText(removeRule.getBalance() != null ? removeRule.getBalance().toString() : "0");
            this.timem.setValue(removeRule.getTimeCount());
            this.typePeriod.setSelectedIndex(removeRule.getTypeRuleRemoveByTime().ordinal());
        }
    }

    public void refresh() {
        this.currentRemoveRule = null;
        this.name.setText("");
        this.comment.setText("");
        this.money.setText("0");
        this.time.setText("0");
        this.timem.setText("0");
        this.typePeriod.setSelectedIndex(0);
        this.periodPanel.setDateString1("");
        this.periodPanel.setDateString2("");
        this.labelTree.clearSelection();
        this.statusList.clearSelection();
        this.firePropertyChange("itemChange", "1", "2");
    }

    public void init(int view) {
        this.cardLayout1.show(this.mainPanel, String.valueOf(view));
    }

    public void okButtonClick(String view) {
        if (this.currentRemoveRule == null) {
            this.currentRemoveRule = new ContractRemoveRule();
        }
        if (Utils.isBlankString(this.name.getText())) {
            BGToolTip.showErrorMessage(this.name, "\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435!");
            return;
        }
        this.currentRemoveRule.setId(this.currentRemoveRule.getId());
        this.currentRemoveRule.setRemoveRuleType("1".equals(view) ? ContractRemoveRule.RemoveRuleType.TIME : ContractRemoveRule.RemoveRuleType.BALANCE);
        this.currentRemoveRule.setTitle(this.name.getText());
        this.currentRemoveRule.setComment(this.comment.getText());
        this.currentRemoveRule.setStatuses(this.statusList.getSelectedIds().stream().toList());
        this.currentRemoveRule.setLabels(this.labelTree.getSelectedIds());
        this.currentRemoveRule.setDateFrom(this.periodPanel.getLocalDateFrom());
        this.currentRemoveRule.setDateTo(this.periodPanel.getLocalDateTo());
        if (this.currentRemoveRule.getRemoveRuleType().equals((Object)ContractRemoveRule.RemoveRuleType.TIME)) {
            this.currentRemoveRule.setTimeCount(Integer.parseInt(this.time.getText()));
        } else {
            this.currentRemoveRule.setBalance(Utils.parseBigDecimal(this.money.getText(), BigDecimal.ZERO));
            this.currentRemoveRule.setTypeRuleRemoveByTime(ContractRemoveRule.TypeRuleRemoveByTime.getTypeRule(Integer.parseInt(this.typePeriod.getSelectedId())));
            this.currentRemoveRule.setTimeCount(Integer.parseInt(this.timem.getText()));
        }
        try {
            this.getRemoveRuleService().updateContractRemoveRule(this.currentRemoveRule);
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog(e);
        }
    }

    private ContractStatusService getContractStatusService() {
        if (this.contractStatusService == null) {
            this.contractStatusService = this.context.getPort(ContractStatusService.class, 0);
        }
        return this.contractStatusService;
    }

    private ContractRemoveRuleService getRemoveRuleService() {
        if (this.removeRuleService == null) {
            this.removeRuleService = ((ClientContext)this.getContext()).getPort(ContractRemoveRuleService.class, 0);
        }
        return this.removeRuleService;
    }
}

