/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.server.action;

import bitel.billing.server.ActionBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffPlan;
import ru.bitel.bgbilling.kernel.tariff.server.bean.TariffPlanDao;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class ActionListTariffPlans
extends ActionBase {
    public void doAction() throws Exception {
        int showActual = this.getIntParameter("showUsed", 2);
        List<Integer> moduleIds = Utils.toIntegerList(this.getParameter("moduleId"));
        List<Integer> labelIds = Utils.toIntegerList(this.getParameter("labelIds"));
        boolean contractCount = this.getBooleanParameter("contractCount", false);
        Page page = this.getPage();
        page.setPageSize(this.getIntParameter("pageSize", -1));
        Element tariffPalnList = this.createElement(this.rootNode, "tariffPlans");
        TariffPlanDao tariffPlanManager = new TariffPlanDao(this.con);
        SearchResult<TariffPlan> searchResult = new SearchResult<TariffPlan>(page);
        tariffPlanManager.searchTariffPlans(searchResult, showActual, moduleIds, labelIds, this.getParameter("titleMask"));
        Map<Integer, TariffPlanDao.TariffPlanCounts> countMap = null;
        if (contractCount) {
            ArrayList<Integer> tariffIds = new ArrayList<Integer>();
            for (TariffPlan tariff : searchResult.getList()) {
                tariffIds.add(tariff.getId());
            }
            countMap = tariffPlanManager.getTariffContractCount(tariffIds);
        }
        tariffPlanManager.close();
        for (TariffPlan tariff : searchResult.getList()) {
            TariffPlanDao.TariffPlanCounts counts;
            Element item = this.createElement(tariffPalnList, "item");
            item.setAttribute("id", String.valueOf(tariff.getId()));
            item.setAttribute("title", tariff.getTitle());
            if (contractCount && (counts = countMap.get(tariff.getId())) != null) {
                item.setAttribute("countChild", counts.countChild.toString());
                item.setAttribute("countActive", counts.countActive.toString());
                item.setAttribute("countAll", counts.countAll.toString());
            }
            item.setAttribute("comment", tariff.getComment());
        }
        this.setPageAttribute(tariffPalnList, page);
    }
}

