/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.server.api.forpost;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostCamera;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostDevice;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostGroup;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostUser;
import ru.bitel.bgbilling.modules.smarthouse.server.api.forpost.ForpostManager;

public class ForpostIntercomRuntime
extends BGLogger {
    private static ConcurrentHashMap<Integer, ForpostIntercomRuntime> instanceMap = new ConcurrentHashMap();
    private final int moduleId;
    private ForpostManager forpostManager;
    private ConcurrentHashMap<Integer, ForpostUser[]> accountUserMap = new ConcurrentHashMap();
    private ConcurrentHashMap<Integer, ForpostCamera[]> accountCameraMap = new ConcurrentHashMap();
    private ConcurrentHashMap<Integer, ForpostDevice[]> accountDeviceMap = new ConcurrentHashMap();
    private ConcurrentHashMap<Integer, ForpostGroup[]> accountHouseMap = new ConcurrentHashMap();
    private ConcurrentHashMap<Integer, ForpostGroup[]> accountEntranceMap = new ConcurrentHashMap();

    public static ForpostIntercomRuntime getInstance(int moduleId) {
        ForpostIntercomRuntime instance = instanceMap.get(moduleId);
        if (instance == null) {
            instance = new ForpostIntercomRuntime(moduleId);
            instanceMap.put(moduleId, instance);
        }
        return instance;
    }

    private ForpostIntercomRuntime(int moduleId) {
        this.moduleId = moduleId;
    }

    private ForpostManager getForpostManager() {
        return Optional.ofNullable(this.forpostManager).orElseGet(() -> {
            this.forpostManager = new ForpostManager(this.moduleId);
            return this.forpostManager;
        });
    }

    private ForpostUser[] loadUsers(int accountId) throws Exception {
        ForpostUser[] forpostUsers = this.getForpostManager().getAccountUsers(accountId, null);
        this.accountUserMap.put(accountId, forpostUsers);
        return forpostUsers;
    }

    public int getAccountUserCount(int accountId, boolean load) {
        int count = -1;
        ForpostUser[] forpostUsers = this.accountUserMap.get(accountId);
        if (forpostUsers == null && load) {
            try {
                count = this.loadUsers(accountId).length;
            }
            catch (Exception ex) {
                this.logError(ex);
                count = -2;
            }
        } else if (forpostUsers != null) {
            count = forpostUsers.length;
        }
        return count;
    }

    public List<ForpostUser> getAccountUsers(int accountId) {
        ForpostUser[] forpostUsers = this.accountUserMap.get(accountId);
        if (forpostUsers == null) {
            try {
                forpostUsers = this.loadUsers(accountId);
            }
            catch (Exception ex) {
                this.logError(ex);
            }
        }
        return forpostUsers == null ? Collections.emptyList() : Arrays.asList(forpostUsers);
    }

    public void resetAccountUsers(int accountId) {
        this.accountUserMap.remove(accountId);
    }

    private ForpostCamera[] loadCameras(int accountId) throws Exception {
        ForpostCamera[] forpostCameras = this.getForpostManager().getCameras(accountId, null, null);
        this.accountCameraMap.put(accountId, forpostCameras);
        return forpostCameras;
    }

    public int getAccountCameraCount(int accountId, boolean load) {
        int count = -1;
        ForpostCamera[] forpostCameras = this.accountCameraMap.get(accountId);
        if (forpostCameras == null && load) {
            try {
                count = this.loadCameras(accountId).length;
            }
            catch (Exception ex) {
                this.logError(ex);
                count = -2;
            }
        } else if (forpostCameras != null) {
            count = forpostCameras.length;
        }
        return count;
    }

    public List<ForpostCamera> getAccountCameras(int accountId) {
        ForpostCamera[] forpostCameras = this.accountCameraMap.get(accountId);
        if (forpostCameras == null) {
            try {
                forpostCameras = this.loadCameras(accountId);
            }
            catch (Exception ex) {
                this.logError(ex);
            }
        }
        return forpostCameras == null ? Collections.emptyList() : Arrays.asList(forpostCameras);
    }

    public void resetAccountCameras(int accountId) {
        this.accountCameraMap.remove(accountId);
    }

    private ForpostDevice[] loadDevices(int accountId) throws Exception {
        ForpostDevice[] forpostDevices = this.getForpostManager().getAccountDevices(accountId);
        this.accountDeviceMap.put(accountId, forpostDevices);
        return forpostDevices;
    }

    public int getAccountDeviceCount(int accountId, boolean load) {
        int count = -1;
        ForpostDevice[] forpostDevices = this.accountDeviceMap.get(accountId);
        if (forpostDevices == null && load) {
            try {
                count = this.loadDevices(accountId).length;
            }
            catch (Exception ex) {
                this.logError(ex);
                count = -2;
            }
        } else if (forpostDevices != null) {
            count = forpostDevices.length;
        }
        return count;
    }

    public List<ForpostDevice> getAccountDevices(int accountId) {
        ForpostDevice[] forpostDevices = this.accountDeviceMap.get(accountId);
        if (forpostDevices == null) {
            try {
                forpostDevices = this.loadDevices(accountId);
            }
            catch (Exception ex) {
                this.logError(ex);
            }
        }
        return forpostDevices == null ? Collections.emptyList() : Arrays.asList(forpostDevices);
    }

    public void resetAccountDevices(int accountId) {
        this.accountDeviceMap.remove(accountId);
    }

    public int getAccountHouseCount(int accountId, boolean load) {
        int count = -1;
        ForpostGroup[] forpostHouses = this.accountHouseMap.get(accountId);
        if (forpostHouses == null && load) {
            try {
                this.loadGroups(accountId);
                count = this.accountHouseMap.get(accountId).length;
            }
            catch (Exception ex) {
                this.logError(ex);
                count = -2;
            }
        } else if (forpostHouses != null) {
            count = forpostHouses.length;
        }
        return count;
    }

    public List<ForpostGroup> getAccountHouses(int accountId) {
        ForpostGroup[] forpostHouses = this.accountHouseMap.get(accountId);
        if (forpostHouses == null) {
            try {
                this.loadGroups(accountId);
                forpostHouses = this.accountHouseMap.get(accountId);
            }
            catch (Exception ex) {
                this.logError(ex);
            }
        }
        return forpostHouses == null ? Collections.emptyList() : Arrays.asList(forpostHouses);
    }

    public void resetAccountHouses(int accountId) {
        this.accountHouseMap.remove(accountId);
    }

    private ForpostGroup[] loadGroups(int accountId) throws Exception {
        ForpostGroup[] forpostGroups = this.getForpostManager().getAccountGroups(null, null, accountId, null, null, null);
        ArrayList houses = new ArrayList();
        ArrayList<ForpostGroup> entrances = new ArrayList<ForpostGroup>();
        for (ForpostGroup forpostGroup : forpostGroups) {
            (forpostGroup.getParentId() > 0 ? entrances : houses).add(forpostGroup);
        }
        this.accountHouseMap.put(accountId, houses.toArray(new ForpostGroup[0]));
        this.accountEntranceMap.put(accountId, entrances.toArray(new ForpostGroup[0]));
        return forpostGroups;
    }

    public int getAccountEntranceCount(int accountId, boolean load) {
        int count = -1;
        ForpostGroup[] forpostEntrances = this.accountEntranceMap.get(accountId);
        if (forpostEntrances == null && load) {
            try {
                this.loadGroups(accountId);
                count = this.accountEntranceMap.get(accountId).length;
            }
            catch (Exception ex) {
                this.logError(ex);
                count = -2;
            }
        } else if (forpostEntrances != null) {
            count = forpostEntrances.length;
        }
        return count;
    }

    public List<ForpostGroup> getAccountEntrances(int accountId) {
        ForpostGroup[] forpostEntrances = this.accountEntranceMap.get(accountId);
        if (forpostEntrances == null) {
            try {
                this.loadGroups(accountId);
                forpostEntrances = this.accountEntranceMap.get(accountId);
            }
            catch (Exception ex) {
                this.logError(ex);
            }
        }
        return forpostEntrances == null ? Collections.emptyList() : Arrays.asList(forpostEntrances);
    }

    public void resetAccountEntrances(int accountId) {
        this.accountEntranceMap.remove(accountId);
    }
}

