/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.client.directory.costmap;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGToolTip;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.modules.voice.client.directory.costmap.VoiceCostMapEditorForm;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceCostMap;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceOperator;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceCostMapService;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceOperatorService;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;

public class VoiceCostMapPanel
extends BGUPanel {
    private static final String EDITOR_MODE = "editor";
    private static final String TABLE_MODE = "table";
    private CardLayout layout = new CardLayout();
    private BGUTable costMapTable;
    private CostMapTableMogel costMapTableModel;
    private VoiceCostMapEditorForm costMapEditor;
    private BGUComboBox<VoiceOperator> operators = new BGUComboBox();

    protected void jbInit() throws Exception {
        this.costMapEditor = new VoiceCostMapEditorForm((ClientContext)this.getContext(), this);
        this.setLayout(this.layout);
        this.add(this.getCodeCostMapPanel(), TABLE_MODE);
        this.add((Component)((Object)this.costMapEditor), EDITOR_MODE);
        this.layout.show((Container)((Object)this), TABLE_MODE);
    }

    private JPanel getOperatorPanel() {
        this.operators.addActionListener(e -> this.performAction("refresh"));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041e\u043f\u0435\u0440\u0430\u0442\u043e\u0440:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        panel.add((Component)this.operators, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        return panel;
    }

    private JPanel getCodeCostMapPanel() {
        this.costMapTableModel = new CostMapTableMogel();
        this.costMapTable = new BGUTable((TableModel)((Object)this.costMapTableModel));
        BGSwingUtilites.handleEdit((JTable)this.costMapTable, (BGUPanel)this, (String)"edit");
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getOperatorPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        panel.add((Component)new JScrollPane((Component)this.costMapTable), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 11, 1, new Insets(3, 3, 3, 3), 0, 0));
        return panel;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            if (this.isCurrentEditorCard()) {
                this.costMapEditor.performAction("refresh");
            } else {
                int selectedIndex = this.operators.getSelectedIndex();
                if (selectedIndex <= 0) {
                    selectedIndex = 0;
                }
                List operList = ((VoiceOperatorService)((ClientContext)this.getContext()).getWebService(VoiceOperatorService.class)).voiceOperatorList();
                operList.add(0, new VoiceOperator(0, "\u041f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e"));
                this.operators.setData(operList);
                if (selectedIndex < this.operators.getItemCount()) {
                    this.operators.setSelectedIndex(selectedIndex);
                }
                this.costMapTableModel.setData(((VoiceCostMapService)((ClientContext)this.getContext()).getWebService(VoiceCostMapService.class)).voiceCostMapList(this.getOperatorId()));
            }
        });
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
            if (this.isCurrentEditorCard()) {
                this.costMapEditor.performAction(BGDialogToolBar.ButtonData.NEW_ITEM.getName());
            } else {
                VoiceCostMap voiceCostMap = new VoiceCostMap();
                voiceCostMap.setOperatorId(((VoiceOperator)this.operators.getSelectedItem()).getId());
                new NewCostMapDialog("\u041d\u043e\u0432\u0430\u044f \u043a\u0430\u0440\u0442\u0430 \u0446\u0435\u043d", voiceCostMap).open();
                if (voiceCostMap.getId() > 0) {
                    this.costMapEditor.setCostMap(voiceCostMap);
                    this.costMapEditor.performAction("edit");
                    this.layout.show((Container)((Object)this), EDITOR_MODE);
                }
            }
        });
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
            if (this.isCurrentEditorCard()) {
                this.costMapEditor.performAction(BGDialogToolBar.ButtonData.EDIT_ITEM.getName());
            } else {
                VoiceCostMap currentCostMap = (VoiceCostMap)this.costMapTableModel.getSelectedRow();
                if (currentCostMap == null) {
                    BGToolTip.showErrorMessage((JComponent)this.costMapTable, (String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043a\u0430\u0440\u0442\u0443 \u0446\u0435\u043d \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435!");
                    return;
                }
                this.costMapEditor.setCostMap(currentCostMap);
                this.costMapEditor.performAction("edit");
                this.layout.show((Container)((Object)this), EDITOR_MODE);
            }
        });
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            if (this.isCurrentEditorCard()) {
                this.costMapEditor.performAction(BGDialogToolBar.ButtonData.DELETE_ITEM.getName());
            } else {
                VoiceCostMap selectedCostMap = (VoiceCostMap)this.costMapTableModel.getSelectedRow();
                if (selectedCostMap == null) {
                    BGToolTip.showErrorMessage((JComponent)this.costMapTable, (String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043a\u0430\u0440\u0442\u0443 \u0446\u0435\u043d \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435!");
                    return;
                }
                if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u043a\u0430\u0440\u0442\u0443 \u0446\u0435\u043d " + selectedCostMap.getTitle() + "?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f", 0) == 0) {
                    ((VoiceCostMapService)((ClientContext)this.getContext()).getWebService(VoiceCostMapService.class)).voiceCostMapDelete(selectedCostMap.getId());
                    this.performAction("refresh");
                }
            }
        });
    }

    public void switchToTableMode() {
        this.layout.show((Container)((Object)this), TABLE_MODE);
    }

    private boolean isCurrentEditorCard() {
        boolean result = false;
        for (Component comp : this.getComponents()) {
            if (!(comp instanceof VoiceCostMapEditorForm) || !comp.isVisible()) continue;
            result = true;
        }
        return result;
    }

    public int getOperatorId() {
        return ((VoiceOperator)this.operators.getSelectedItem()).getId();
    }

    class CostMapTableMogel
    extends BGTableModel<VoiceCostMap> {
        public CostMapTableMogel() {
            super(CostMapTableMogel.class.getName());
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, -1, -1, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, -1, -1, "comment", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    class NewCostMapDialog
    extends BGEditorDialog<VoiceCostMap> {
        private BGTextField title;
        private BGTextField comment;

        public NewCostMapDialog(String title, VoiceCostMap data) {
            super(title, (Object)data);
            this.title = new BGTextField(50);
            this.comment = new BGTextField(50);
        }

        public void doDialogPanel() {
            this.panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.title, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.comment, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 0, 0), 0, 0));
        }

        public boolean doApply() throws Exception {
            if (this.title.getText().isBlank()) {
                BGToolTip.showErrorMessage((JComponent)this.title, (String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435");
                return false;
            }
            ((VoiceCostMap)this.data).setTitle(this.title.getText());
            ((VoiceCostMap)this.data).setComment(this.comment.getText());
            ((VoiceCostMap)this.data).setId(((VoiceCostMapService)((ClientContext)VoiceCostMapPanel.this.getContext()).getWebService(VoiceCostMapService.class)).voiceCostMapUpdate((VoiceCostMap)this.data));
            VoiceCostMapPanel.this.performAction("refresh");
            return true;
        }
    }
}

