/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.directory.api.server;

import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.directory.api.common.DirectoryItemModifiedEvent;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.directory.api.server.ServerDirectoryInfo;
import ru.bitel.common.model.Id;

class ServerDirectoryView<K extends Id>
implements Directory<K> {
    private final ServerDirectoryInfo<K> info;
    private final int moduleId;
    private final ServerContext context;
    private final Directory<K> service;
    private final AtomicLong version;

    public ServerDirectoryView(ServerContext context, ServerDirectoryInfo<K> info, int moduleId, Directory<K> service) throws BGException {
        this.info = info;
        this.moduleId = moduleId;
        this.context = context;
        this.service = service;
        this.version = info.getVersion(moduleId);
    }

    @Override
    public K get(int id) throws BGException {
        return this.service.get(id);
    }

    @Override
    public K get(String title) throws BGException {
        return this.service.get(title);
    }

    @Override
    public List<K> list() throws Exception {
        return this.service.list();
    }

    @Override
    public void update(K k) throws Exception {
        K oldValue = this.service.get(((Id)k).getId());
        this.service.update(k);
        this.fireModified(oldValue, k);
    }

    @Override
    public int delete(int id) throws Exception {
        K oldValue = this.service.get(id);
        int result = this.service.delete(id);
        this.fireModified(oldValue, null);
        return result;
    }

    private void fireModified(K oldValue, K newValue) throws BGException {
        this.version.incrementAndGet();
        DirectoryItemModifiedEvent<?> modifiedEvent = this.info.newModifiedEvent(this.moduleId, this.context.getUserId(), oldValue, newValue);
        if (modifiedEvent != null) {
            this.context.publishAfterCommit(modifiedEvent);
        }
    }
}

