/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.npay.server.bean.object;

import bitel.billing.server.contract.bean.ContractUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractNote;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractNoteDao;
import ru.bitel.bgbilling.modules.npay.common.bean.ServiceObject;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Period;

public class ServiceObjectManager {
    private Connection con;
    private int moduleId;
    private String tableName;

    public ServiceObjectManager(Connection con, int moduleId) {
        this.con = con;
        this.moduleId = moduleId;
        this.tableName = "npay_service_object_" + moduleId;
    }

    public ServiceObject getServiceObject(int id) {
        ServiceObject result = null;
        String query = "SELECT * FROM " + this.tableName + " AS service_object WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = this.getServiceObjectFromRs(rs, false, false);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void updateServiceObject(ServiceObject value) throws BGException {
        block22: {
            boolean update = value.getId() > 0;
            String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET cost=?, col=?, oid=?, date1=?, date2=?, comment=?, cid=?, emid=?, eid=?, user_id=?" + (update ? " WHERE id=?" : ", sid=?");
            try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
                LocalDateTime localDateTime;
                String yyyymm;
                String logTableName;
                int index = 1;
                ps.setBigDecimal(index++, value.getCost());
                ps.setBigDecimal(index++, value.getCol());
                ps.setInt(index++, value.getObjectId());
                ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)value.getDate1()));
                ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)value.getDate2()));
                ps.setString(index++, value.getComment());
                ps.setInt(index++, value.getContractId());
                ps.setInt(index++, value.getEntityMid());
                ps.setInt(index++, value.getEntityId());
                ps.setInt(index++, value.getUserId());
                ps.setInt(index++, update ? value.getId() : value.getServiceId());
                ps.executeUpdate();
                if (!update) {
                    value.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
                }
                if (!ServerUtils.tableExists((Connection)this.con, (String)(logTableName = this.tableName + "_" + (yyyymm = TimeUtils.format((LocalDateTime)(localDateTime = LocalDateTime.now()), (String)"yyyyMM"))))) {
                    query = "CREATE TABLE " + logTableName + " SELECT * FROM " + this.tableName + " WHERE id=? AND last_update<>?";
                    try (PreparedStatement psCreate = this.con.prepareStatement(query);){
                        psCreate.setInt(1, value.getId());
                        psCreate.setTimestamp(2, TimeUtils.convertLocalDateTimeToTimestamp((LocalDateTime)value.getLastUpdate()));
                        psCreate.executeUpdate();
                        break block22;
                    }
                }
                query = "INSERT INTO " + logTableName + " SELECT * FROM " + this.tableName + " WHERE id=? AND last_update<>?";
                try (PreparedStatement psCreate = this.con.prepareStatement(query);){
                    psCreate.setInt(1, value.getId());
                    psCreate.setTimestamp(2, TimeUtils.convertLocalDateTimeToTimestamp((LocalDateTime)value.getLastUpdate()));
                    psCreate.executeUpdate();
                }
            }
            catch (Exception ex) {
                throw new BGException((Throwable)ex);
            }
        }
    }

    public void deleteServiceObject(int id, int userId) throws BGException {
        String query = "DELETE FROM " + this.tableName + " WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            LocalDateTime localDateTime = LocalDateTime.now();
            String yyyymm = TimeUtils.format((LocalDateTime)localDateTime, (String)"yyyyMM");
            String logTableName = this.tableName + "_" + yyyymm;
            if (!ServerUtils.tableExists((Connection)this.con, (String)logTableName)) {
                query = "CREATE TABLE " + logTableName + " SELECT * FROM " + this.tableName + " WHERE id=?";
                try (PreparedStatement psCreate = this.con.prepareStatement(query);){
                    psCreate.setInt(1, 0);
                    psCreate.executeUpdate();
                }
            }
            query = "INSERT INTO " + logTableName + " SET id=?, user_id=?, last_update=?";
            try (PreparedStatement psInsert = this.con.prepareStatement(query);){
                psInsert.setInt(1, id);
                psInsert.setInt(2, userId);
                psInsert.setTimestamp(3, TimeUtils.convertLocalDateTimeToTimestamp((LocalDateTime)localDateTime));
                psInsert.executeUpdate();
            }
            ps.setInt(1, id);
            ps.executeUpdate();
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public List<ServiceObject> getServiceObjectListForObject(int oid) throws BGException {
        ArrayList<ServiceObject> result = new ArrayList<ServiceObject>();
        String query = "SELECT service_object.*, service.title FROM " + this.tableName + " AS service_object LEFT JOIN service ON service_object.sid=service.id WHERE service_object.oid=? AND service_object.emid=0 AND service_object.eid=0 ORDER BY service_object.date1";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, oid);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getServiceObjectFromRs(rs, true, false));
                }
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public List<ServiceObject> getServiceObjectList(int contractId, Date date) throws BGException {
        return this.getServiceObjectList(contractId, 0, 0, 0, date);
    }

    public List<ServiceObject> getServiceObjectList(int contractId, int serviceId, Period period) throws BGException {
        ArrayList<ServiceObject> result = new ArrayList<ServiceObject>();
        String query = "SELECT service_object.*, service.title FROM " + this.tableName + " AS service_object LEFT JOIN service ON service_object.sid=service.id WHERE service_object.cid=?" + (serviceId > 0 ? " AND service_object.sid=?" : "") + (period != null ? " AND (date1 IS NULL OR date1<=?) AND (date2 IS NULL OR date2>=?)" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, contractId);
            if (serviceId > 0) {
                ps.setInt(index++, serviceId);
            }
            if (period != null) {
                ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)period.getDateTo()));
                ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)period.getDateFrom()));
            }
            try (ResultSet resultSet = ps.executeQuery();){
                while (resultSet.next()) {
                    result.add(this.getServiceObjectFromRs(resultSet, true, false));
                }
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public List<ServiceObject> getServiceObjectList(int contractId, int objectId, int entityMid, int entityId) throws BGException {
        return this.getServiceObjectList(contractId, objectId, entityMid, entityId, null);
    }

    public List<ServiceObject> getServiceObjectList(int contractId, int objectId, int entityModuleId, int entityId, Date date) throws BGException {
        ArrayList<ServiceObject> result = new ArrayList<ServiceObject>();
        String query = "SELECT service_object.*, service.title, object.title FROM " + this.tableName + " AS service_object LEFT JOIN service ON service_object.sid=service.id LEFT JOIN object ON service_object.oid=object.id WHERE service_object.cid=? " + (String)(entityModuleId >= 0 ? " AND service_object.emid=" + entityModuleId : "") + (String)(entityId >= 0 ? " AND service_object.eid=" + entityId : "") + (String)(objectId > 0 ? " AND service_object.oid=" + objectId : "");
        if (date != null) {
            query = query + " AND (service_object.date1 IS NULL OR service_object.date1 <= ?)  AND (service_object.date2 IS NULL OR service_object.date2 >= ?) ";
        }
        query = query + " ORDER BY service_object.date1";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, contractId);
            if (date != null) {
                ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)date));
                ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)date));
            }
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getServiceObjectFromRs(rs, true, true));
                }
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    private ServiceObject getServiceObjectFromRs(ResultSet rs, boolean serviceTitle, boolean objectTitle) throws SQLException {
        return ServiceObject.builder().setId(rs.getInt("service_object.id")).setContractId(rs.getInt("service_object.cid")).setServiceId(rs.getInt("service_object.sid")).setCost(rs.getBigDecimal("service_object.cost")).setCol(rs.getBigDecimal("service_object.col")).setDate1((Date)rs.getDate("service_object.date1")).setDate2((Date)rs.getDate("service_object.date2")).setEntityModuleId(rs.getInt("service_object.emid")).setEntityId(rs.getInt("service_object.eid")).setObjectId(rs.getInt("service_object.oid")).setComment(rs.getString("service_object.comment")).setServiceTitle(serviceTitle ? rs.getString("service.title") : null).setObjectTitle(objectTitle && rs.getInt("service_object.oid") > 0 ? rs.getString("object.title") + " [ID#" + rs.getString("service_object.oid") + "]" : null).setUserId(rs.getInt("service_object.user_id")).setLastUpdate(TimeUtils.convertTimestampToLocalDateTime((Timestamp)rs.getTimestamp("service_object.last_update"))).build();
    }

    public void moveContractSevice(ServiceObject contractService, int cidFrom, int cidTo, int objectTo, int userId) throws Exception {
        if (contractService.getDate1() == null) {
            throw new BGException("\u041d\u0435\u0442 \u0434\u0430\u0442\u044b \u043d\u0430\u0447\u0430\u043b\u0430 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0443\u0441\u043b\u0443\u0433\u0438 \u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435.");
        }
        ServiceObjectManager csm = new ServiceObjectManager(this.con, this.moduleId);
        contractService.setContractId(cidTo);
        contractService.setObjectId(objectTo);
        csm.updateServiceObject(contractService);
        ContractUtils cu = new ContractUtils(this.con);
        ContractNoteDao contractNoteDao = new ContractNoteDao(this.con);
        ContractNote contractNote = ContractNote.builder().setUserId(userId).setContractId(cidFrom).setDateTime(LocalDateTime.now()).setTitle("\u041f\u0435\u0440\u0435\u043d\u0435\u0441\u0435\u043d\u0430 \u0430\u0431\u043e\u043d\u043f\u043b\u0430\u0442\u0430").setComment("\u0410\u0431\u043e\u043d\u043f\u043b\u0430\u0442\u0430 " + contractService.getServiceTitle() + " \u043f\u0435\u0440\u0435\u043d\u0435\u0441\u0435\u043d\u0430 \u0438\u0437 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 " + cu.getContractTitle(cidFrom, true) + " \u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440 " + cu.getContractTitle(cidTo, true)).build();
        contractNoteDao.update((Object)contractNote);
        contractNote.setId(0);
        contractNote.setContractId(cidTo);
        contractNoteDao.update((Object)contractNote);
    }

    public void wrapContractSevice(ServiceObject contractService, int cidTo, int objectTo, int entityToId, int userId, Date dateClose, Date dateOpen) throws Exception {
        if (contractService.getDate2() != null && TimeUtils.dateBeforeOrEq((Date)contractService.getDate2(), (Date)dateClose)) {
            return;
        }
        if (TimeUtils.dateBefore((Date)dateOpen, (Date)contractService.getDate1())) {
            this.moveContractSevice(contractService, contractService.getContractId(), cidTo, objectTo, userId);
            return;
        }
        if (contractService.getDate1() == null) {
            throw new BGException("\u041d\u0435\u0442 \u0434\u0430\u0442\u044b \u043d\u0430\u0447\u0430\u043b\u0430 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0443\u0441\u043b\u0443\u0433\u0438 " + contractService.getServiceTitle() + " \u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435.");
        }
        ServiceObjectManager csm = new ServiceObjectManager(this.con, this.moduleId);
        Date oldDate2 = contractService.getDate2();
        contractService.setDate2(dateClose);
        csm.updateServiceObject(contractService);
        if (oldDate2 == null || !TimeUtils.dateBeforeOrEq((Date)oldDate2, (Date)dateOpen)) {
            csm.updateServiceObject(ServiceObject.copy((ServiceObject)contractService).setContractId(cidTo).setObjectId(objectTo).setId(0).setDate1(dateOpen).setDate2(oldDate2).setEntityId(entityToId).build());
        }
        ContractUtils cu = new ContractUtils(this.con);
        ContractNoteDao contractNoteDao = new ContractNoteDao(this.con);
        String contractFrom = cu.getContractTitle(contractService.getContractId(), true);
        String contractTo = cu.getContractTitle(cidTo, true);
        ContractNote contractNote = ContractNote.builder().setUserId(userId).setContractId(contractService.getContractId()).setDateTime(LocalDateTime.now()).setTitle("\u041f\u0435\u0440\u0435\u043d\u0435\u0441\u0435\u043d\u0430 \u0430\u0431\u043e\u043d\u043f\u043b\u0430\u0442\u0430 \u0441 \u0434\u0430\u0442\u044b").setComment("\u0410\u0431\u043e\u043d\u043f\u043b\u0430\u0442\u0430 " + contractService.getServiceTitle() + " \u043f\u0435\u0440\u0435\u043d\u0435\u0441\u0435\u043d\u0430 \u0438\u0437 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 " + contractFrom + " \u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440 " + contractTo + " \u0441 \u0434\u0430\u0442\u044b " + TimeUtils.formatDate((Date)dateOpen)).build();
        contractNoteDao.update((Object)contractNote);
        contractNote.setId(0);
        contractNote.setContractId(cidTo);
        contractNoteDao.update((Object)contractNote);
    }

    public List<ServiceObject> getServiceObjectLogList(int contractId, int serviceObjectId) throws BGException {
        ArrayList<ServiceObject> serviceObjects = new ArrayList<ServiceObject>();
        String queryTables = "SHOW TABLES LIKE '" + this.tableName + "_%'";
        String querySelect = "SELECT * FROM ? AS service_object WHERE cid=? AND id=?";
        try (PreparedStatement psTables = this.con.prepareStatement(queryTables);
             PreparedStatement psSelect = this.con.prepareStatement(querySelect);){
            ArrayList<String> tables = new ArrayList<String>();
            try (ResultSet rs = psTables.executeQuery();){
                while (rs.next()) {
                    tables.add(rs.getString(1));
                }
            }
            psTables.setInt(2, contractId);
            psTables.setInt(3, serviceObjectId);
            for (String table : tables) {
                psTables.setString(1, table);
                ResultSet rs = psSelect.executeQuery();
                try {
                    while (rs.next()) {
                        serviceObjects.add(this.getServiceObjectFromRs(rs, false, false));
                    }
                }
                finally {
                    if (rs == null) continue;
                    rs.close();
                }
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return serviceObjects;
    }
}

