/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.email.client;

import bitel.billing.module.services.ServicePanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.email.common.bean.AttributeRow;
import ru.bitel.bgbilling.modules.email.common.bean.AttributeValue;
import ru.bitel.bgbilling.modules.email.common.service.EmailService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;

public class SPP_Attributes
extends ServicePanel
implements ActionListener {
    private boolean update = true;
    private BGDialogToolBar dialogToolBar = new BGDialogToolBar();
    private AttributeTableModel attributeTableModel = new AttributeTableModel();

    public SPP_Attributes() {
        this.jbInit();
    }

    private void jbInit() {
        this.dialogToolBar.setDefaultButtons((ActionListener)this);
        this.dialogToolBar.setFloatable(false);
        this.dialogToolBar.setOrientation(1);
        this.dialogToolBar.setToolBar(new String[]{"newItem", "editItem", "deleteItem"});
        BGUTable table = new BGUTable((TableModel)((Object)this.attributeTableModel));
        table.setSelectionMode(0);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.dialogToolBar, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.add(new JScrollPane((Component)table), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 5, 5), 0, 0));
        BGSwingUtilites.handleMouseClicked((Component)table, e -> this.editItem());
    }

    public void setData() {
        this.init();
        int aid = this.id;
        if (aid > 0) {
            try {
                this.attributeTableModel.setData(((EmailService)this.getContext().getWebService(EmailService.class, this.getContext().getModuleId())).attributeRows(aid));
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
    }

    private void init() {
    }

    public boolean updateData() {
        try {
            List<AttributeValue> attributeValues = this.attributeTableModel.getRows().stream().map(AttributeRow::toAttributeValue).toList();
            ((EmailService)this.getContext().getWebService(EmailService.class, this.getContext().getModuleId())).attributeValueUpdate(this.id, attributeValues);
            return true;
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
            return false;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if ("newItem".equals(actionCommand)) {
            this.update = false;
            new AttributeEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0430\u0442\u0442\u0440\u0438\u0431\u0443\u0442\u0430", new AttributeRow()).open();
        } else if ("editItem".equals(actionCommand)) {
            this.update = true;
            this.editRow();
        } else if ("deleteItem".equals(actionCommand)) {
            AttributeRow rowData = (AttributeRow)this.attributeTableModel.getSelectedRow();
            if (rowData == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0437\u0430\u043f\u0438\u0441\u044c \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f");
                return;
            }
            this.attributeTableModel.deleteRow(rowData);
        }
    }

    private void editRow() {
        this.attributeTableModel.optSelectedRow().ifPresentOrElse(data -> new AttributeEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0430\u0442\u0442\u0440\u0438\u0431\u0443\u0442\u0430", (AttributeRow)data).open(), () -> ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0437\u0430\u043f\u0438\u0441\u044c \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f"));
    }

    class AttributeTableModel
    extends BGTableModel<AttributeRow> {
        public AttributeTableModel() {
            super(AttributeTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0410\u0442\u0442\u0440\u0438\u0431\u0443\u0442", 200, 300, 500, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", -1, -1, -1, "value", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    class AttributeEditor
    extends BGEditorDialog<AttributeRow> {
        private BGTextField attributeValue;
        private BGUComboBox<IdTitle> attributeCombo;

        public AttributeEditor(String title, AttributeRow data) {
            super(title, (Object)data);
            this.attributeValue = new BGTextField(50);
            this.attributeCombo = new BGUComboBox();
        }

        public void doDialogPanel() {
            try {
                this.attributeCombo.setData(((EmailService)SPP_Attributes.this.getContext().getWebService(EmailService.class, SPP_Attributes.this.getContext().getModuleId())).attributeList().stream().map(IdTitle::toIdTitle).toList());
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
            this.panel.add((Component)new JLabel("\u0410\u0442\u0442\u0440\u0438\u0431\u0443\u0442:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.attributeCombo, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.attributeValue, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 10, 0), 0, 0));
            this.attributeCombo.setSelectedItem(this.attributeCombo.getData().stream().filter(a -> a.getId() == ((AttributeRow)this.data).getId()).findFirst().orElse(null));
            this.attributeValue.setText(((AttributeRow)this.data).getValue());
        }

        public boolean doApply() throws Exception {
            IdTitle attrItem = (IdTitle)this.attributeCombo.getSelectedItem();
            String value = this.attributeValue.getText();
            if (attrItem == null || Utils.isBlankString((String)value)) {
                return false;
            }
            AttributeRow row = null;
            if (SPP_Attributes.this.update) {
                row = (AttributeRow)SPP_Attributes.this.attributeTableModel.getSelectedRow();
            } else {
                row = new AttributeRow();
                SPP_Attributes.this.attributeTableModel.getRows().add(row);
            }
            if (row != null) {
                row.setId(attrItem.getId()).setTitle(attrItem.toString()).setValue(value);
            }
            SPP_Attributes.this.attributeTableModel.fireTableDataChanged();
            return true;
        }
    }
}

