/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.modules.inet.common.bean.DataProcessRecord;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class DataProcessRecordDao
extends AbstractIdDao<DataProcessRecord> {
    public DataProcessRecordDao(Connection con, int moduleId) {
        super(con, moduleId, "inet_task_process");
    }

    protected DataProcessRecord getFromRS(ResultSet rs) throws SQLException {
        DataProcessRecord record = new DataProcessRecord();
        record.setId(rs.getInt("id"));
        record.setDeviceId(rs.getInt("deviceId"));
        record.setDay((Date)rs.getTimestamp("day"));
        record.setCurentHour(rs.getInt("curentHour"));
        record.setStartTime((Date)rs.getTimestamp("startTime"));
        record.setType(rs.getByte("type"));
        return record;
    }

    protected void updateImpl(DataProcessRecord dataProcessRecord) throws SQLException {
        boolean update = dataProcessRecord.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET day=?, deviceId=?, startTime=?, curentHour=?, type=?" + (update ? " WHERE id=?" : "");
        try (PreparedStatement psUpdate = this.con.prepareStatement(query);){
            int index = 1;
            psUpdate.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)dataProcessRecord.getDay()));
            psUpdate.setInt(index++, dataProcessRecord.getDeviceId());
            psUpdate.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)dataProcessRecord.getStartTime()));
            psUpdate.setInt(index++, dataProcessRecord.getCurentHour());
            psUpdate.setByte(index++, dataProcessRecord.getType());
            if (update) {
                psUpdate.setInt(index++, dataProcessRecord.getId());
            }
            psUpdate.executeUpdate();
        }
    }

    public List<DataProcessRecord> list(int type, Set<Integer> deviceIds) throws SQLException {
        return this.list(" type = ? AND deviceId IN ( " + Utils.toString(deviceIds) + " )", "day", new Object[]{type});
    }

    public List<DataProcessRecord> list(Set<Integer> deviceIds) throws SQLException {
        return this.list("deviceId IN ( " + Utils.toString(deviceIds) + " )", "day", new Object[0]);
    }

    public List<DataProcessRecord> list(int deviceId, Date dateFrom, Date dateTo, int type) throws SQLException {
        return this.list("deviceId = ? AND( day >= ? AND  day <= ?) AND type = ? ", "day", new Object[]{deviceId, dateFrom, dateTo, type});
    }

    public List<DataProcessRecord> list(int deviceId, List<Date> days, int type) throws SQLException {
        Object[] params = new Object[days.size()];
        String filter = this.getDeviceHoursFilterAndParams(deviceId, days, params, type);
        return this.list(filter, "day", params);
    }

    public void delete(int deviceId, List<Date> hours, int type) throws Exception {
        Object[] params = new Object[hours.size()];
        String filter = this.getDeviceHoursFilterAndParams(deviceId, hours, params, type);
        this.delete(filter, params);
    }

    protected String getDeviceHoursFilterAndParams(int deviceId, List<Date> days, Object[] params, int type) {
        String filter = " deviceId = " + deviceId + " AND type = " + type;
        if (days.size() > 0) {
            filter = filter + " AND ";
            filter = filter + "( 1!= 1 ";
            for (Date day : days) {
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTime(day);
                filter = filter + " OR day = ?";
            }
            for (int i = 0; i < days.size(); ++i) {
                params[i] = days.get(i);
            }
            filter = filter + ")";
        }
        return filter;
    }
}

