/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.assist.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DecimalFormat;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import ru.bitel.bgbilling.client.common.AbstractTransactionPanel;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.AbstractTransactionStatus;
import ru.bitel.bgbilling.common.bean.SearchParam;
import ru.bitel.bgbilling.modules.assist.client.AssistPaymentEditor;
import ru.bitel.bgbilling.modules.assist.client.TransactionTableModel;
import ru.bitel.bgbilling.modules.assist.common.bean.Transaction;
import ru.bitel.bgbilling.modules.assist.common.bean.TransactionCheckResultDTO;
import ru.bitel.bgbilling.modules.assist.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.assist.common.service.AssistService;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.model.SearchResult;

public class TransactionPanel
extends AbstractTransactionPanel {
    public TransactionPanel() {
        this.statusComboBox.setModel(new DefaultComboBoxModel<TransactionStatus>(TransactionStatus.values()));
    }

    protected JPanel getExtraFilterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getCheckButton(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 15, 0, 5), 0, 0));
        return panel;
    }

    protected BGButton getCheckButton() {
        BGButton button = new BGButton("\u041f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c...");
        button.setToolTipText("\u0417\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0443 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0445 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0439");
        button.addActionListener(event -> this.doGetTransactionStatus());
        return button;
    }

    protected void initListeners() {
        super.initListeners();
        super.initPopupListener();
    }

    protected void initPopupMenu() {
        this.getTable().getPopupMenu().add(this.getDataMenuItem());
    }

    protected JMenuItem getDataMenuItem() {
        return new JMenuItem("\u0414\u0430\u043d\u043d\u044b\u0435 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438"){
            {
                this.addActionListener(e -> TransactionPanel.this.performAction("edit"));
            }
        };
    }

    private void doGetTransactionStatus() {
        try {
            List results = ((AssistService)((ClientContext)this.getContext()).getWebService(AssistService.class)).transactionCheck(this.getContractId());
            for (TransactionCheckResultDTO resultDTO : results) {
                StringBuilder sb = new StringBuilder();
                sb.append("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442: ").append(resultDTO.getResult().name());
                sb.append(" (").append(resultDTO.getResult().getTitle()).append(")");
                sb.append("\n\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435: ").append(resultDTO.getMessage());
                if (resultDTO.getAssistProtocolTransferExceptionMessage() != null) {
                    sb.append("\nException: ").append(resultDTO.getAssistProtocolTransferExceptionMessage());
                }
                JTextArea textArea = new JTextArea(sb.toString(), 10, 40);
                textArea.setEditable(false);
                textArea.setMargin(new Insets(3, 3, 3, 3));
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), BGSwingUtilites.wrapScrollPane((JComponent)textArea, (int)500, (int)300));
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        this.performAction("refresh");
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            SearchParam searchParam = SearchParam.builder().setContractId(this.getContractId()).setContractTitle(this.contractTitleField.getText()).setStatus(((AbstractTransactionStatus)this.statusComboBox.getSelectedItem()).getCode()).setPeriod(this.periodPanel.getPeriod()).setSort(this.getTable().getSort()).setPage(this.pagePanel.getPage()).build();
            SearchResult searchResult = ((AssistService)((ClientContext)this.getContext()).getPort(AssistService.class)).searchTransactionList(searchParam);
            ((TransactionTableModel)this.transactionModel).setData(searchResult.getList());
            this.pagePanel.setPage(searchResult.getPage());
            this.recordCountLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + searchResult.getPage().getRecordCount());
            this.summaField.setText(new DecimalFormat("###,###,##0.00").format(searchResult.getSum()));
        });
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> this.transactionModel.optSelectedRow().ifPresentOrElse(transaction -> new TransactionEditorDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438", (Transaction)transaction).open(), () -> ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044e \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f")));
    }

    class TransactionEditorDialog
    extends BGEditorDialog<Transaction> {
        private AssistPaymentEditor editor;

        public TransactionEditorDialog(String title, Transaction data) {
            super(title, (Object)data);
            this.editor = new AssistPaymentEditor();
        }

        public void doDialogPanel() {
            this.panel.add((Component)((Object)this.editor), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
            this.editor.init(((ClientContext)TransactionPanel.this.getContext()).getModule(), ((ClientContext)TransactionPanel.this.getContext()).getModuleId());
            this.editor.setData(((Transaction)this.data).getId());
        }

        public boolean doApply() throws Exception {
            this.editor.submitData();
            return true;
        }
    }
}

