/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.buyemoney.server.protocols.wm;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.modules.buyemoney.server.protocols.ProtocolException;
import ru.bitel.bgbilling.modules.buyemoney.server.protocols.wm.WMOperation;
import ru.bitel.bgbilling.modules.buyemoney.server.protocols.wm.WMRetvalException;
import ru.bitel.bgbilling.modules.buyemoney.server.protocols.wm.WMSigner;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.security.EyelessHostnameVerifier;
import ru.bitel.common.security.EyelessSSLSocketFactory;
import ru.bitel.common.util.DebugUtils;

public class WMXI {
    private final String WMXI_URL_CLASSIC_X1 = "https://w3s.webmoney.ru/asp/XMLInvoice.asp";
    private final String WMXI_URL_LITE_X1 = "https://w3s.wmtransfer.com/asp/XMLInvoiceCert.asp";
    private final String WMXI_URL_CLASSIC_X2 = "https://w3s.webmoney.ru/asp/XMLTrans.asp";
    private final String WMXI_URL_LITE_X2 = "https://w3s.wmtransfer.com/asp/XMLTransCert.asp";
    private final String WMXI_URL_CLASSIC_X3 = "https://w3s.webmoney.ru/asp/XMLOperations.asp";
    private final String WMXI_URL_LITE_X3 = "https://w3s.wmtransfer.com/asp/XMLOperationsCert.asp";
    private final String WMXI_URL_CLASSIC_X4 = "https://w3s.webmoney.ru/asp/XMLOutInvoices.asp";
    private final String WMXI_URL_LITE_X4 = "https://w3s.webmoney.ru/asp/XMLOutInvoicesCert.asp";
    private final String WMXI_URL_CLASSIC_X5 = "https://w3s.webmoney.ru/asp/XMLFinishProtect.asp";
    private final String WMXI_URL_LITE_X5 = "https://w3s.wmtransfer.com/asp/XMLFinishProtectCert.asp";
    private final String WMXI_URL_CLASSIC_X6 = "https://w3s.webmoney.ru/asp/XMLSendMsg.asp";
    private final String WMXI_URL_LITE_X6 = "https://w3s.wmtransfer.com/asp/XMLSendMsgCert.asp";
    private final String WMXI_URL_CLASSIC_X7 = "https://w3s.webmoney.ru/asp/XMLClassicAuth.asp";
    private final String WMXI_URL_LITE_X7 = "https://w3s.wmtransfer.com/asp/XMLClassicAuthCert.asp";
    private final String WMXI_URL_CLASSIC_X8 = "https://w3s.webmoney.ru/asp/XMLFindWMPurse.asp";
    private final String WMXI_URL_LITE_X8 = "https://w3s.wmtransfer.com/asp/XMLFindWMPurseCert.asp";
    private final String WMXI_URL_CLASSIC_X9 = "https://w3s.webmoney.ru/asp/XMLPurses.asp";
    private final String WMXI_URL_LITE_X9 = "https://w3s.wmtransfer.com/asp/XMLPursesCert.asp";
    private final String WMXI_URL_CLASSIC_X10 = "https://w3s.webmoney.ru/asp/XMLInInvoices.asp";
    private final String WMXI_URL_LITE_X10 = "https://w3s.webmoney.ru/asp/XMLInInvoicesCert.asp";
    private final String WMXI_URL_CLASSIC_X11 = "https://passport.webmoney.ru/asp/XMLGetWMPassport.asp";
    private final String WMXI_URL_LITE_X11 = "https://passport.webmoney.ru/asp/XMLGetWMPassport.asp";
    private final String WMXI_URL_CLASSIC_X13 = "https://w3s.webmoney.ru/asp/XMLRejectProtect.asp";
    private final String WMXI_URL_LITE_X13 = "https://w3s.wmtransfer.com/asp/XMLRejectProtectCert.asp";
    private final String WMXI_URL_CLASSIC_X14 = "https://w3s.webmoney.ru/asp/XMLTransMoneyback.asp";
    private final String WMXI_URL_LITE_X14 = "https://w3s.wmtransfer.com/asp/XMLTransMoneybackCert.asp";
    private final String WMXI_URL_CLASSIC_X15a = "https://w3s.webmoney.ru/asp/XMLTrustList.asp";
    private final String WMXI_URL_LITE_X15a = "https://w3s.webmoney.ru/asp/XMLTrustListCert.asp";
    private final String WMXI_URL_CLASSIC_X15b = "https://w3s.webmoney.ru/asp/XMLTrustList2.asp";
    private final String WMXI_URL_LITE_X15b = "https://w3s.webmoney.ru/asp/XMLTrustList2Cert.asp";
    private final String WMXI_URL_CLASSIC_X15c = "https://w3s.webmoney.ru/asp/XMLTrustSave2.asp";
    private final String WMXI_URL_LITE_X15c = "https://w3s.webmoney.ru/asp/XMLTrustSave2Cert.asp";
    private final String WMXI_URL_CLASSIC_X16 = "https://w3s.webmoney.ru/asp/XMLCreatePurse.asp";
    private final String WMXI_URL_LITE_X16 = "https://w3s.wmtransfer.com/asp/XMLCreatePurseCert.asp";
    private boolean classic = true;
    private File wm_cert;
    private String encoding;
    private String kwm;
    private String wmid;
    private String pass;
    private Object rsa_key = "";
    private Object rsa_cert = "";
    private SimpleDateFormat DATEFORMAT = new SimpleDateFormat("yyyyMMdd HH:mm:ss");

    public WMXI(File wm_cert, String encoding) {
        if (wm_cert == null || encoding == null) {
            throw new IllegalArgumentException();
        }
        this.wm_cert = wm_cert;
        this.encoding = encoding;
    }

    void Classic(String wmid, String pass, String kwm) {
        this.classic = true;
        this.wmid = wmid;
        this.pass = pass;
        this.kwm = kwm;
    }

    void Lite(Object rsa_key, Object rsa_cert, String pass) {
        this.classic = false;
        this.rsa_key = rsa_key;
        this.rsa_cert = rsa_cert;
        this.pass = pass;
    }

    private String _change_encoding(String text, String encoding, boolean entities) {
        return text;
    }

    private String _reqn() {
        return String.valueOf(System.currentTimeMillis());
    }

    private String _sign(String data) throws IOException, NoSuchAlgorithmException, SignatureException {
        WMSigner wmsigner = new WMSigner(this.wmid, this.pass, Utils.readByBlock((InputStream)new FileInputStream(new File(this.kwm))));
        return wmsigner.Sign(data);
    }

    private String _xml(Map<String, Object> data, String rootname) {
        HashMap<String, Object> dataxml = new HashMap<String, Object>();
        dataxml.put(rootname, data);
        return this.__xml(dataxml);
    }

    private String __xml(Map<String, Object> data) {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, Object> kv : data.entrySet()) {
            if (kv.getValue() == null) continue;
            Object value = kv.getValue() instanceof HashMap ? "\n" + this.__xml((Map)kv.getValue()) : this._change_encoding((String)kv.getValue(), "HTML-ENTITIES", true);
            result.append("<").append(kv.getKey()).append(">").append((String)value).append("</").append(kv.getKey()).append(">\n");
        }
        return result.toString();
    }

    private Document _request(String formurl, String data) throws ProtocolException {
        HttpURLConnection con = null;
        try {
            HttpsURLConnection.setDefaultSSLSocketFactory(EyelessSSLSocketFactory.INSTANCE);
            HttpsURLConnection.setDefaultHostnameVerifier((HostnameVerifier)EyelessHostnameVerifier.INSTANCE);
            URL url = new URL(formurl);
            con = (HttpsURLConnection)url.openConnection();
            con.setRequestMethod("POST");
            con.setDoOutput(true);
            con.setDoInput(true);
            con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            con.setAllowUserInteraction(true);
            PrintStream ps = new PrintStream(con.getOutputStream(), true);
            ps.print(data);
            ps.close();
            if (con.getResponseCode() == 200) {
                Document result;
                DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
                dFactory.setNamespaceAware(true);
                dFactory.setValidating(false);
                DocumentBuilder docBuilder = dFactory.newDocumentBuilder();
                Document document = result = docBuilder.parse(con.getInputStream());
                return document;
            }
            try {
                throw new ProtocolException("HTTP response code '" + con.getResponseCode() + "' not equals HTTP_OK");
            }
            catch (Exception e) {
                if (e instanceof ProtocolException) {
                    throw (ProtocolException)((Object)e);
                }
                throw new ProtocolException(e.toString());
            }
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
    }

    public Object X2(int tranid, String pursesrc, String pursedest, BigDecimal amount, int period, String pcode, String desc, int wminvid) throws ProtocolException, NoSuchAlgorithmException, SignatureException, IOException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("reqn", this._reqn());
        String amount_s = this.formatAmount(amount);
        if (this.classic) {
            data.put("wmid", this.wmid);
            data.put("sign", this._sign(String.valueOf(data.get("reqn")) + String.valueOf(tranid) + pursesrc + pursedest + amount_s + String.valueOf(period) + pcode + desc + String.valueOf(wminvid)));
        }
        HashMap<String, String> trans = new HashMap<String, String>();
        trans.put("tranid", String.valueOf(tranid));
        trans.put("pursesrc", pursesrc);
        trans.put("pursedest", pursedest);
        trans.put("amount", amount_s);
        trans.put("period", String.valueOf(period));
        trans.put("pcode", pcode);
        trans.put("desc", desc);
        trans.put("wminvid", String.valueOf(wminvid));
        data.put("trans", trans);
        String xml = this._xml(data, "w3s.request");
        String url = this.classic ? "https://w3s.webmoney.ru/asp/XMLTrans.asp" : "https://w3s.wmtransfer.com/asp/XMLTransCert.asp";
        Document result = this._request(url, xml);
        return result;
    }

    public List<WMOperation> X3(String purse, String wmtranid, String tranid, String wminvid, String orderid, Date datestart, Date datefinish) throws Exception {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("reqn", this._reqn());
        if (this.classic) {
            data.put("wmid", this.wmid);
            data.put("sign", this._sign(purse + String.valueOf(data.get("reqn"))));
        }
        HashMap<String, String> getoperations = new HashMap<String, String>();
        getoperations.put("purse", purse);
        getoperations.put("wmtranid", wmtranid != null ? wmtranid : "0");
        getoperations.put("tranid", tranid != null ? tranid : "0");
        getoperations.put("wminvid", wminvid != null ? wminvid : "0");
        getoperations.put("orderid", orderid != null ? orderid : "0");
        getoperations.put("datestart", this.formatDate(datestart));
        getoperations.put("datefinish", this.formatDate(datefinish));
        data.put("getoperations", getoperations);
        String xml = this._xml(data, "w3s.request");
        String url = this.classic ? "https://w3s.webmoney.ru/asp/XMLOperations.asp" : "https://w3s.wmtransfer.com/asp/XMLOperationsCert.asp";
        Document reply = this._request(url, xml);
        this.testReply(reply);
        ArrayList<WMOperation> result = new ArrayList<WMOperation>();
        for (Element operationEl : XMLUtils.selectElements((Node)reply, (String)"/w3s.response/operations/operation")) {
            WMOperation operation = new WMOperation();
            operation.setId(Utils.parseInt((String)operationEl.getAttribute("id")));
            operation.setTs(Utils.parseInt((String)operationEl.getAttribute("ts")));
            operation.setPursesrc(XMLUtils.selectText((Node)operationEl, (String)"pursesrc/text()"));
            operation.setPursedest(XMLUtils.selectText((Node)operationEl, (String)"pursedest/text()"));
            operation.setAmount(Utils.parseBigDecimal((String)XMLUtils.selectText((Node)operationEl, (String)"amount/text()"), null));
            operation.setComiss(Utils.parseBigDecimal((String)XMLUtils.selectText((Node)operationEl, (String)"comiss/text()"), null));
            operation.setOpertype(Utils.parseInt((String)XMLUtils.selectText((Node)operationEl, (String)"opertype/text()")));
            operation.setWminvid(Utils.parseInt((String)XMLUtils.selectText((Node)operationEl, (String)"wminvid/text()")));
            operation.setOrderid(Utils.parseInt((String)XMLUtils.selectText((Node)operationEl, (String)"orderid/text()")));
            operation.setTranid(Utils.parseInt((String)XMLUtils.selectText((Node)operationEl, (String)"tranid/text()")));
            operation.setPeriod(Utils.parseInt((String)XMLUtils.selectText((Node)operationEl, (String)"period/text()")));
            operation.setDesc(XMLUtils.selectText((Node)operationEl, (String)"desc/text()"));
            operation.setDatecrt(this.parseDate(XMLUtils.selectText((Node)operationEl, (String)"datecrt/text()")));
            operation.setDateupd(this.parseDate(XMLUtils.selectText((Node)operationEl, (String)"dateupd/text()")));
            operation.setCorrwm(XMLUtils.selectText((Node)operationEl, (String)"corrwm/text()"));
            operation.setRest(Utils.parseBigDecimal((String)XMLUtils.selectText((Node)operationEl, (String)"rest/text()"), null));
            operation.setTimelock(XMLUtils.selectText((Node)operationEl, (String)"timelock/text()") != null);
            result.add(operation);
        }
        return result;
    }

    private Date parseDate(String datestr) {
        try {
            return this.DATEFORMAT.parse(datestr);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String formatDate(Date date) {
        return date != null ? this.DATEFORMAT.format(date) : null;
    }

    private String formatAmount(BigDecimal amount) {
        String value = null;
        if (amount != null) {
            DecimalFormat df = new DecimalFormat("#.##");
            DecimalFormatSymbols dfs = new DecimalFormatSymbols();
            dfs.setDecimalSeparator('.');
            dfs.setMinusSign('-');
            df.setDecimalFormatSymbols(dfs);
            value = df.format(amount);
        }
        return value;
    }

    private void testReply(Document result) throws ProtocolException {
        try {
            XMLUtils.selectNode((Node)result, (String)"/w3s.response/retval").getTextContent();
            XMLUtils.selectNode((Node)result, (String)"/w3s.response/retdesc").getTextContent();
        }
        catch (Exception e) {
            throw new ProtocolException(e.toString());
        }
        new WMRetvalException();
    }

    public Object X9(String wmid) throws NoSuchAlgorithmException, SignatureException, IOException, ProtocolException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("reqn", this._reqn());
        if (this.classic) {
            data.put("wmid", this.wmid);
            data.put("sign", this._sign(wmid + String.valueOf(data.get("reqn"))));
        }
        HashMap<String, String> getpurses = new HashMap<String, String>();
        getpurses.put("wmid", wmid);
        data.put("getpurses", getpurses);
        String xml = this._xml(data, "w3s.request");
        String url = this.classic ? "https://w3s.webmoney.ru/asp/XMLPurses.asp" : "https://w3s.wmtransfer.com/asp/XMLPursesCert.asp";
        Document result = this._request(url, xml);
        return result;
    }

    public static void main(String[] args) throws Exception {
        String DOC_ENCODING = "windows-1251";
        File crt = new File("/home/dimon/projects/webmoney/WebMoneyCA.crt");
        WMXI wmxi = new WMXI(crt, "windows-1251");
        wmxi.Classic("323446780013", "123456", "/home/dimon/projects/webmoney/323446780013.kwm");
        List<WMOperation> response = wmxi.X3("R198105158104", null, null, null, null, new Date(new Date().getTime() - 7776000000L), new Date());
        DebugUtils.dumpVar(response);
    }
}

