/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.drwebn.client;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.services.ServiceConfigTabbedPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriod;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.module.common.bean.Service;
import ru.bitel.bgbilling.kernel.module.common.service.ModuleService;
import ru.bitel.bgbilling.modules.drwebn.common.bean.DrwebTariff;
import ru.bitel.bgbilling.modules.drwebn.common.service.DrwebService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.table.BGTableModel;

public class ServiceConfigTariffs
extends ServiceConfigTabbedPanel {
    private int tariffId = -1;
    private Map<Integer, Service> serviceMap = new HashMap<Integer, Service>();
    private Map<Integer, DrwebTariff> tariffMap = new HashMap<Integer, DrwebTariff>();
    private BGTableModel<TableData> model;
    private BGUTable table;
    private JPanel editPanel;
    private BGTextField title = new BGTextField();
    private BGComboBox<ComboBoxItem> services = new BGComboBox();
    private BGComboBox<ComboBoxItem> servicesForNew = new BGComboBox();
    private BGTextField groupTitle = new BGTextField();
    private BGControlPanelPeriod workPeriod = new BGControlPanelPeriod();
    private BGControlPanelPeriod viewPeriod = new BGControlPanelPeriod();
    private BGComboBox<ComboBoxItem> nextTariff = new BGComboBox();
    private BGTextField groupForView = new BGTextField();
    private JCheckBox onlyForNew = new JCheckBox("\u0422\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u043d\u043e\u0432\u044b\u0445");
    private BGButtonPanelOkCancel okCancelPanel = new BGButtonPanelOkCancel();
    SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy");

    public ServiceConfigTariffs() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        this.model = new BGTableModel<TableData>("tariffs"){

            protected void initColumns() {
                this.addColumnId();
                this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", String.class, -1, 150, -1, "title", true);
                this.addColumn("\u0423\u0441\u043b\u0443\u0433\u0430", String.class, -1, 150, -1, "serviceTitle", true);
                this.addColumn("\u0423\u0441\u043b\u0443\u0433\u0430 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438", String.class, -1, 150, -1, "serviceTitleForNew", true);
                this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0433\u0440\u0443\u043f\u043f\u044b", String.class, -1, 150, -1, "groupTitle", true);
                this.addColumn("\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c", String.class, -1, 150, -1, "dateView", true);
                this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f", String.class, -1, 150, -1, "dateWork", true);
            }
        };
        this.table = new BGUTable(this.model);
        this.table.setSelectionMode(0);
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ServiceConfigTariffs.this.editItem();
                }
            }
        });
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.getEditPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private JPanel getEditPanel() {
        if (this.editPanel != null) {
            return this.editPanel;
        }
        this.editPanel = new JPanel();
        this.editPanel.setLayout(new GridBagLayout());
        this.editPanel.setVisible(false);
        this.editPanel.setBorder((Border)new BGTitleBorder("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440"));
        this.okCancelPanel.addActionListener(e -> {
            if (BGButtonPanelOkCancel.OK.getActionCommand().equals(e.getActionCommand())) {
                this.stopEditTariff(true);
            } else if (BGButtonPanelOkCancel.CANCEL.getActionCommand().equals(e.getActionCommand())) {
                this.stopEditTariff(false);
            }
        });
        this.workPeriod.setTitleBorderName("\u0414\u0435\u0439\u0441\u0442\u0432\u0443\u0435\u0442");
        this.viewPeriod.setTitleBorderName("\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c");
        JPanel panel1 = new JPanel(new GridBagLayout());
        panel1.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435"), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        panel1.add((Component)new JLabel("\u0423\u0441\u043b\u0443\u0433\u0430"), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        panel1.add((Component)new JLabel("\u0423\u0441\u043b\u0443\u0433\u0430 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438"), new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        panel1.add((Component)new JLabel("\u0413\u0440\u0443\u043f\u043f\u0430"), new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        panel1.add((Component)this.title, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        panel1.add((Component)this.services, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        panel1.add((Component)this.servicesForNew, new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        panel1.add((Component)this.groupTitle, new GridBagConstraints(3, 1, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        JPanel panel2 = new JPanel(new GridBagLayout());
        panel2.add((Component)this.workPeriod, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 21, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel2.add((Component)this.viewPeriod, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 21, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel2.add((Component)new JLabel("\u0421\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0439 \u0442\u0430\u0440\u0438\u0444"), new GridBagConstraints(2, 0, 1, 1, 0.0, 1.0, 21, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel2.add((Component)this.nextTariff, new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0, 21, 0, new Insets(0, 5, 0, 5), 0, 0));
        JPanel panel3 = new JPanel();
        panel3.setLayout(new GridBagLayout());
        panel3.add((Component)new JLabel("\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u0434\u043b\u044f \u0433\u0440\u0443\u043f\u043f"), new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 21, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel3.add((Component)this.groupForView, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 21, 2, new Insets(0, 5, 0, 0), 0, 0));
        panel3.add((Component)this.onlyForNew, new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0, 21, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.editPanel.add((Component)panel1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.editPanel.add((Component)panel2, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 21, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.editPanel.add((Component)panel3, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.editPanel.add((Component)this.okCancelPanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        return this.editPanel;
    }

    private void startEditTariff(DrwebTariff tariff) {
        this.tariffId = tariff.getId();
        this.title.setText(tariff.getTitle());
        this.services.setSelectedId(String.valueOf(tariff.getSid()));
        this.servicesForNew.setSelectedId(String.valueOf(tariff.getSidForNew()));
        this.groupTitle.setText(tariff.getGroupTitle());
        this.viewPeriod.setDateCalendar1(TimeUtils.convertDateToCalendar((Date)tariff.getDateFromView()));
        this.viewPeriod.setDateCalendar2(TimeUtils.convertDateToCalendar((Date)tariff.getDateToView()));
        this.workPeriod.setDateCalendar1(TimeUtils.convertDateToCalendar((Date)tariff.getDateFromWork()));
        this.workPeriod.setDateCalendar2(TimeUtils.convertDateToCalendar((Date)tariff.getDateToWork()));
        this.nextTariff.setSelectedItem((Object)tariff.getNextTariff());
        this.groupForView.setText(tariff.getGroupForView());
        this.onlyForNew.setSelected(tariff.isOnlyForNew());
        this.editPanel.setVisible(true);
    }

    private void stopEditTariff(boolean save) {
        try {
            if (save) {
                if (!TimeUtils.periodInRange((Date)this.viewPeriod.getDateFrom(), (Date)this.viewPeriod.getDateTo(), (Date)this.workPeriod.getDateFrom(), (Date)this.workPeriod.getDateTo())) {
                    ClientUtils.showErrorMessageDialog((String)"\u041f\u0435\u0440\u0438\u043e\u0434 \u043f\u043e\u043a\u0430\u0437\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 \u043f\u0435\u0440\u0438\u043e\u0434\u0430 \u0440\u0430\u0431\u043e\u0442\u044b");
                    return;
                }
                DrwebTariff tariff = new DrwebTariff();
                tariff.setId(this.tariffId);
                tariff.setSid(Integer.parseInt(this.services.getSelectedId()));
                tariff.setSidForNew(Integer.parseInt(this.servicesForNew.getSelectedId()));
                tariff.setGroupTitle(this.groupTitle.getText());
                tariff.setTitle(this.title.getText());
                tariff.setDateFromView(this.viewPeriod.getDateFrom());
                tariff.setDateToView(this.viewPeriod.getDateTo());
                tariff.setDateFromWork(this.workPeriod.getDateFrom());
                tariff.setDateToWork(this.workPeriod.getDateTo());
                tariff.setGroupForView(this.groupForView.getText());
                tariff.setOnlyForNew(this.onlyForNew.isSelected());
                tariff.setNextTariff(Integer.parseInt(this.nextTariff.getSelectedId()));
                ((DrwebService)this.getContext().getPort(DrwebService.class)).tariffUpdate(tariff);
                this.trySetData();
            }
            this.editPanel.setVisible(false);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    public void deleteItem() {
        try {
            DrwebTariff tariff;
            if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0442\u0430\u0440\u0438\u0444?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0442\u0430\u0440\u0438\u0444\u0430", 0) == 0 && (tariff = this.tariffMap.get(((TableData)this.model.getSelectedRow()).getId())) != null) {
                ((DrwebService)this.getContext().getPort(DrwebService.class)).tariffDelete(tariff.getId());
                this.trySetData();
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    public void editItem() {
        DrwebTariff s = this.tariffMap.get(((TableData)this.model.getSelectedRow()).getId());
        if (s != null) {
            this.startEditTariff(s);
        }
    }

    public void newItem() {
        this.startEditTariff(new DrwebTariff());
    }

    public void setData() throws Exception {
        List serviceList = ((ModuleService)this.getContext().getWebService(ModuleService.class, 0)).serviceList(this.getModuleId());
        DefaultComboBoxModel<ComboBoxItem> serviceModel = new DefaultComboBoxModel<ComboBoxItem>();
        DefaultComboBoxModel<ComboBoxItem> serviceModelForNew = new DefaultComboBoxModel<ComboBoxItem>();
        this.serviceMap.clear();
        for (Service service : serviceList) {
            ComboBoxItem idTitle = new ComboBoxItem(service.getId(), service.getTitle());
            serviceModel.addElement(idTitle);
            serviceModelForNew.addElement(idTitle);
            this.serviceMap.put(service.getId(), service);
        }
        this.services.setModel(serviceModel);
        this.servicesForNew.setModel(serviceModelForNew);
        List tariffList = ((DrwebService)this.getContext().getPort(DrwebService.class)).allTariffList();
        ArrayList<TableData> list = new ArrayList<TableData>();
        this.tariffMap.clear();
        DefaultComboBoxModel<ComboBoxItem> modelTariff = new DefaultComboBoxModel<ComboBoxItem>();
        for (DrwebTariff tariff : tariffList) {
            TableData data = new TableData(this);
            data.setId(tariff.getId());
            data.setTitle(tariff.getTitle());
            Service service = this.serviceMap.get(tariff.getSid());
            if (service != null) {
                data.setServiceTitle(service.getTitle());
            } else {
                data.setServiceTitle("\u041d\u0435\u0442 \u0443\u0441\u043b\u0443\u0433\u0438");
            }
            service = this.serviceMap.get(tariff.getSidForNew());
            if (service != null) {
                data.setServiceTitleForNew(service.getTitle());
            } else {
                data.setServiceTitleForNew("\u041d\u0435\u0442 \u0443\u0441\u043b\u0443\u0433\u0438");
            }
            data.setGroupTitle(tariff.getGroupTitle());
            String dateFromView = tariff.getDateFromView() != null ? this.format.format(tariff.getDateFromView()) : "";
            String dateToView = tariff.getDateToView() != null ? this.format.format(tariff.getDateToView()) : "";
            data.setDateView(dateFromView + "-" + dateToView);
            String dateFromWork = tariff.getDateFromWork() != null ? this.format.format(tariff.getDateFromWork()) : "";
            String dateToWork = tariff.getDateToWork() != null ? this.format.format(tariff.getDateToWork()) : "";
            data.setDateWork(dateFromWork + "-" + dateToWork);
            list.add(data);
            this.tariffMap.put(tariff.getId(), tariff);
            ComboBoxItem idTitle = new ComboBoxItem(tariff.getId(), tariff.getTitle());
            modelTariff.addElement(idTitle);
        }
        this.nextTariff.setModel(modelTariff);
        this.model.setData(list);
    }

    public class TableData {
        int id = -1;
        String title = null;
        String serviceTitle = null;
        String serviceTitleForNew = null;
        String groupTitle = null;
        String dateView = null;
        String dateWork = null;

        public TableData(ServiceConfigTariffs this$0) {
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getServiceTitle() {
            return this.serviceTitle;
        }

        public void setServiceTitle(String serviceTitle) {
            this.serviceTitle = serviceTitle;
        }

        public String getGroupTitle() {
            return this.groupTitle;
        }

        public void setGroupTitle(String groupTitle) {
            this.groupTitle = groupTitle;
        }

        public String getDateView() {
            return this.dateView;
        }

        public void setDateView(String dateView) {
            this.dateView = dateView;
        }

        public String getDateWork() {
            return this.dateWork;
        }

        public void setDateWork(String dateWork) {
            this.dateWork = dateWork;
        }

        public String getServiceTitleForNew() {
            return this.serviceTitleForNew;
        }

        public void setServiceTitleForNew(String serviceTitleForNew) {
            this.serviceTitleForNew = serviceTitleForNew;
        }
    }
}

