/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.gar.client;

import bitel.billing.module.common.BGDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGToolTip;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.plugins.gar.common.bean.GarAddressCity;
import ru.bitel.bgbilling.plugins.gar.common.bean.GarAddressHouse;
import ru.bitel.bgbilling.plugins.gar.common.bean.GarAddressStreet;
import ru.bitel.bgbilling.plugins.gar.common.bean.GarLoadedReport;
import ru.bitel.bgbilling.plugins.gar.common.service.GarService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.list.BGUCheckList;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.model.IdTitle;

public class GarManagerPanel
extends BGUPanel {
    private final SearchPanel searchPanel = new SearchPanel();
    private final InfoPanel infoPanel = new InfoPanel();
    private final StreetsListPanel streetsListPanel = new StreetsListPanel();
    private GarService garService;

    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        JPanel leftPanel = new JPanel(new GridBagLayout());
        leftPanel.add((Component)this.searchPanel, new GridBagConstraints(0, 0, 1, 2, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        JPanel rightPanel = new JPanel(new GridBagLayout());
        rightPanel.add((Component)this.infoPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        rightPanel.add((Component)this.streetsListPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add((Component)new BGSplitPaneNoBorder(1, (Component)leftPanel, (Component)rightPanel, 400L), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.searchPanel.loadRegions();
    }

    protected void initActions() {
        new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                GarManagerPanel.this.searchPanel.loadRegions();
            }
        };
    }

    private GarService getGarService() {
        if (this.garService == null) {
            this.garService = (GarService)((ClientContext)this.getContext()).getPort(GarService.class);
        }
        return this.garService;
    }

    private final class SearchPanel
    extends JPanel {
        private final BGUComboBox<IdTitle> regions;
        private final BGUList<IdTitle> searchList;
        private final JTextField searchCityField;
        AbstractBGUPanel.AsyncAction<Window> asyncSearch;

        public SearchPanel() {
            super(new GridBagLayout());
            this.regions = new BGUComboBox();
            this.searchList = new BGUList();
            this.searchCityField = new JTextField();
            this.asyncSearch = new AbstractBGUPanel.AsyncAction<Window>("", ""){

                protected Window doInBackground() {
                    Window waitwindow = ClientUtils.showWaitWindow((String)"\u041f\u043e\u0438\u0441\u043a...");
                    SearchPanel.this.switchEditableElementsOnSearchPanel(false);
                    try {
                        List cities = GarManagerPanel.this.getGarService().searchCitiesByContainsName(((IdTitle)SearchPanel.this.regions.getSelectedItem()).getId(), SearchPanel.this.searchCityField.getText());
                        SearchPanel.this.searchList.setData(cities);
                        if (Utils.notEmptyCollection((Collection)cities)) {
                            SearchPanel.this.searchList.requestFocus();
                            SearchPanel.this.searchList.setSelectedValue(cities.get(0), false);
                        }
                    }
                    catch (Exception e) {
                        ClientUtils.showErrorMessageDialog((Throwable)e);
                    }
                    return waitwindow;
                }

                protected void done(Window waitwindow) {
                    SearchPanel.this.switchEditableElementsOnSearchPanel(true);
                    if (waitwindow != null) {
                        waitwindow.dispose();
                    }
                }
            };
            this.setBorder((Border)new BGTitleBorder("\u041f\u043e\u0438\u0441\u043a"));
            this.regions.addItemListener(GarManagerPanel.this.comboBoxSelect(e -> GarManagerPanel.this.tryCall(() -> this.checkLoadedRegion(Objects.requireNonNull((IdTitle)this.regions.getSelectedItem())))));
            this.searchList.setSelectionMode(0);
            this.searchList.addListSelectionListener(e -> {
                if (!e.getValueIsAdjusting() && this.searchList.getSelectedValue() != null) {
                    GarManagerPanel.this.tryCall(() -> {
                        GarManagerPanel.this.streetsListPanel.clear();
                        GarManagerPanel.this.infoPanel.loadCityInfo((IdTitle)this.searchList.getSelectedValue());
                    });
                }
            });
            this.add((Component)new JLabel("\u0420\u0435\u0433\u0438\u043e\u043d"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
            this.add((Component)this.regions, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)new JLabel("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043d\u0430\u0441\u0435\u043b\u0451\u043d\u043d\u043e\u0433\u043e \u043f\u0443\u043d\u043a\u0442\u0430 (\u043f\u043e\u0438\u0441\u043a \u043f\u043e enter)"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
            this.add((Component)this.searchCityField, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)new JLabel("\u041d\u0430\u0439\u0434\u0435\u043d\u043d\u044b\u0435 \u043d\u0430\u0441\u0435\u043b\u0451\u043d\u043d\u044b\u0435 \u043f\u0443\u043d\u043a\u0442\u044b"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
            this.add((Component)new JScrollPane((Component)this.searchList), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.searchCityField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        SearchPanel.this.searchCities(SearchPanel.this.searchCityField.getText());
                    }
                }
            });
        }

        private void checkLoadedRegion(IdTitle selectedRegion) throws Exception {
            if (selectedRegion.getId() <= 0) {
                return;
            }
            if (!GarManagerPanel.this.getGarService().checkLoadedRegion(selectedRegion.getId())) {
                BGToolTip.showMessage(this.regions, (String)"\u0420\u0435\u0433\u0438\u043e\u043d \u043d\u0435 \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d. \u041f\u0435\u0440\u0435\u0439\u0434\u0438\u0442\u0435 \u0432 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043f\u043b\u0430\u0433\u0438\u043d\u0430 \u0434\u043b\u044f \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u0440\u0435\u0433\u0438\u043e\u043d\u0430.");
            }
        }

        private void searchCities(String data) {
            IdTitle selectedRegion = (IdTitle)this.regions.getSelectedItem();
            if (selectedRegion == null || selectedRegion.getId() < 0) {
                BGToolTip.showErrorMessage(this.regions, (String)"\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u0440\u0435\u0433\u0438\u043e\u043d!");
                return;
            }
            if (Utils.notBlankString((String)data) && data.length() >= 3) {
                this.asyncSearch.perform();
            }
        }

        private void switchEditableElementsOnSearchPanel(boolean editable) {
            this.searchCityField.setEnabled(editable);
            this.regions.setEnabled(editable);
            this.searchList.setEnabled(editable);
        }

        private void loadRegions() throws Exception {
            ArrayList<IdTitle> data = new ArrayList<IdTitle>();
            data.add(new IdTitle(-1, "-----------"));
            List l = GarManagerPanel.this.getGarService().regionList();
            l.forEach(r -> r.setTitle(String.format("[%s] %s", r.getId(), r.getTitle())));
            data.addAll(l);
            this.regions.setData(data);
        }
    }

    private final class InfoPanel
    extends JPanel {
        private final BGTextField infoName;
        private final BGTextField infoType;
        private final BGTextField infoCladrCode;
        private final BGTextField infoHierarchy;
        private final BGButton loadStreetButton;
        private GarAddressCity currentCity;

        public InfoPanel() {
            super(new GridBagLayout());
            this.infoName = new BGTextField();
            this.infoType = new BGTextField();
            this.infoCladrCode = new BGTextField();
            this.infoHierarchy = new BGTextField();
            this.loadStreetButton = new BGButton("\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0443\u043b\u0438\u0446\u044b");
            this.infoName.setEditable(false);
            this.infoType.setEditable(false);
            this.infoCladrCode.setEditable(false);
            this.infoHierarchy.setEditable(false);
            this.setBorder((Border)new BGTitleBorder("\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e\u0431 \u043e\u0431\u044a\u0435\u043a\u0442\u0435"));
            this.add((Component)new JLabel("\u0418\u0435\u0440\u0430\u0440\u0445\u0438\u044f"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this.infoHierarchy, new GridBagConstraints(1, 0, 3, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)new JLabel("\u041a\u041b\u0410\u0414\u0420 \u043a\u043e\u0434"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this.infoCladrCode, new GridBagConstraints(1, 1, 3, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)new JLabel("\u0422\u0438\u043f"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this.infoType, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435"), new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this.infoName, new GridBagConstraints(3, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this.loadStreetButton, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.loadStreetButton.addActionListener(e -> GarManagerPanel.this.streetsListPanel.loadStreetsByCity(this.currentCity));
        }

        private void loadCityInfo(IdTitle garAddressCity) throws Exception {
            GarAddressCity addressCityInfo = GarManagerPanel.this.getGarService().getGarCityInfoByCityId((long)garAddressCity.getId());
            if (addressCityInfo == null) {
                this.currentCity = null;
                return;
            }
            this.currentCity = addressCityInfo;
            this.infoName.setText(addressCityInfo.getTitle());
            this.infoType.setText(addressCityInfo.getTypeName());
            this.infoCladrCode.setText(addressCityInfo.getCladrCode());
            this.infoHierarchy.setText(addressCityInfo.getFullName());
        }
    }

    private final class StreetsListPanel
    extends JPanel {
        private final BGUCheckList<GarAddressStreet> streetList;
        private GarAddressCity currentCity;
        private final HousesListPanel housesListPanel;
        AbstractBGUPanel.AsyncAction asyncLoadStreets;

        public StreetsListPanel() {
            super(new GridBagLayout());
            this.streetList = new BGUCheckList();
            this.asyncLoadStreets = new AbstractBGUPanel.AsyncAction<List<GarAddressStreet>>("", ""){

                protected List<GarAddressStreet> doInBackground() {
                    Window waitwindow = ClientUtils.showWaitWindow((String)"\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0443\u043b\u0438\u0446...");
                    ArrayList<GarAddressStreet> streets = new ArrayList<GarAddressStreet>();
                    try {
                        GarManagerPanel.this.infoPanel.loadStreetButton.setEnabled(false);
                        streets.addAll(GarManagerPanel.this.getGarService().getStreetsByCityId((long)StreetsListPanel.this.currentCity.getId()));
                        GarManagerPanel.this.infoPanel.loadStreetButton.setEnabled(true);
                    }
                    catch (Exception e) {
                        ClientUtils.showErrorMessageDialog((Throwable)e);
                    }
                    waitwindow.dispose();
                    return streets;
                }

                protected void done(List<GarAddressStreet> streets) {
                    if (Utils.notEmptyCollection(streets)) {
                        StreetsListPanel.this.streetList.setData(streets);
                    }
                }
            };
            this.setBorder((Border)new BGTitleBorder("\u0421\u043f\u0438\u0441\u043e\u043a \u0443\u043b\u0438\u0446"));
            this.streetList.getList().setSelectionMode(0);
            this.housesListPanel = new HousesListPanel();
            this.housesListPanel.setVisible(false);
            this.add((Component)this.streetList, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this.housesListPanel, new GridBagConstraints(1, 0, 1, 1, 0.3, 1.0, 13, 1, new Insets(3, 3, 3, 3), 0, 0));
            BGButton loadStreetsWithoutHouses = new BGButton("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0443\u043b\u0438\u0446\u044b \u0432 \u0430\u0434\u0440\u0435\u0441\u043d\u044b\u0439 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a");
            this.add((Component)loadStreetsWithoutHouses, new GridBagConstraints(0, -1, 2, 1, 0.0, 0.0, 16, 2, new Insets(5, 5, 5, 5), 0, 0));
            BGButton loadStreetsWithHouses = new BGButton("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0443\u043b\u0438\u0446\u044b \u0438 \u0434\u043e\u043c\u0430 \u0432 \u0430\u0434\u0440\u0435\u0441\u043d\u044b\u0439 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a");
            this.add((Component)loadStreetsWithHouses, new GridBagConstraints(0, -1, 2, 1, 0.0, 0.0, 16, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.streetList.getList().addListSelectionListener(e -> {
                if (e.getSource() instanceof JList && e.getSource() != null) {
                    GarAddressStreet street = (GarAddressStreet)this.streetList.getValueAt(((JList)e.getSource()).getSelectedIndex());
                    if (street != null) {
                        this.housesListPanel.showHouses(street);
                    } else {
                        this.housesListPanel.clear();
                    }
                }
            });
            loadStreetsWithHouses.addActionListener(e -> this.saveStreetsToDatabase(true));
            loadStreetsWithoutHouses.addActionListener(e -> this.saveStreetsToDatabase(false));
        }

        private void loadStreetsByCity(GarAddressCity city) {
            this.currentCity = city;
            if (this.currentCity == null) {
                return;
            }
            this.asyncLoadStreets.perform((Object)city);
        }

        private void clear() {
            this.streetList.setData(Collections.emptyList());
            this.housesListPanel.clear();
        }

        private void saveStreetsToDatabase(boolean withHouses) {
            List streets;
            List list = streets = Utils.notEmptyCollection((Collection)this.streetList.getSelected()) ? new ArrayList(this.streetList.getSelected()) : this.streetList.getData();
            if (Utils.isEmptyCollection(streets)) {
                BGToolTip.showErrorMessage(this.streetList, (String)"\u041d\u0435\u0442 \u0443\u043b\u0438\u0446 \u0434\u043b\u044f \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f");
                return;
            }
            if (BGSwingUtilites.confirm((String)(withHouses ? "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0443\u043b\u0438\u0446\u044b \u0438 \u0434\u043e\u043c\u0430 \u0432 \u0430\u0434\u0440\u0435\u0441\u043d\u044b\u0439 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a" : "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0443\u043b\u0438\u0446\u044b \u0431\u0435\u0437 \u0434\u043e\u043c\u043e\u0432 \u0432 \u0430\u0434\u0440\u0435\u0441\u043d\u044b\u0439 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a"), null)) {
                try {
                    new ReportDialog(GarManagerPanel.this.getGarService().loadDataInDB(this.getCurrentCountryId(), this.currentCity, streets, withHouses)).showDialog();
                }
                catch (Exception e) {
                    ClientUtils.showErrorMessageDialog((Throwable)e);
                }
            }
        }

        private int getCurrentCountryId() throws Exception {
            int currentCountryId;
            List countries = GarManagerPanel.this.getGarService().getCountries();
            if (countries.size() == 1) {
                currentCountryId = ((IdTitle)countries.get(0)).getId();
            } else {
                countries.add(0, new IdTitle(0, "--------------------"));
                SelectCountryDialog selectCountryDialog = new SelectCountryDialog(countries);
                selectCountryDialog.showDialog();
                currentCountryId = selectCountryDialog.getSelectedCountryId();
            }
            return currentCountryId;
        }
    }

    private final class HousesListCellRenderer
    implements ListCellRenderer<GarAddressHouse> {
        private HousesListCellRenderer(GarManagerPanel garManagerPanel) {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends GarAddressHouse> list, GarAddressHouse value, int index, boolean isSelected, boolean cellHasFocus) {
            JPanel renderedPanel = new JPanel(new GridBagLayout());
            renderedPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.GRAY));
            renderedPanel.add((Component)new JLabel("\u2116: " + value.getTitle()), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(1, 1, 1, 1), 0, 0));
            renderedPanel.add((Component)new JLabel("\u0418\u043d\u0434\u0435\u043a\u0441: " + value.getPostIndex()), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(1, 1, 1, 1), 0, 0));
            renderedPanel.add((Component)new JLabel("\u041a\u0430\u0434\u0430\u0441\u0442\u0440\u043e\u0432\u044b\u0439 \u043d\u043e\u043c\u0435\u0440: " + value.getCadastralNumber()), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 2, new Insets(1, 1, 1, 1), 0, 0));
            return renderedPanel;
        }
    }

    private final class HousesListPanel
    extends JPanel {
        private final BGUList<GarAddressHouse> housesList;

        public HousesListPanel() {
            super(new GridBagLayout());
            this.housesList = new BGUList();
            this.add((Component)new JScrollPane((Component)this.housesList), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.housesList.setCellRenderer((ListCellRenderer)new HousesListCellRenderer(GarManagerPanel.this));
            this.housesList.setEnabled(false);
            BGSwingUtilites.wrapBorder((JPanel)this, (String)"\u0421\u043f\u0438\u0441\u043e\u043a \u0434\u043e\u043c\u043e\u0432");
        }

        private void showHouses(GarAddressStreet street) {
            this.housesList.setData(street.getHouses());
            this.setVisible(true);
        }

        private void clear() {
            this.housesList.setData(Collections.emptyList());
            this.setVisible(false);
        }
    }

    private static final class ReportDialog
    extends BGDialog {
        public ReportDialog(GarLoadedReport report) {
            this.getContentPane().setLayout(new GridBagLayout());
            this.setTitle("\u041e\u0442\u0447\u0435\u0442 \u043e \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u043d\u044b\u0445 \u0430\u0434\u0440\u0435\u0441\u0430\u0445");
            this.setModal(true);
            this.setResizable(false);
            Dimension dimension = new Dimension(600, 700);
            this.setSize(dimension);
            this.setMinimumSize(dimension);
            this.setPreferredSize(dimension);
            this.add(new JScrollPane(this.initMainReportPanel(report)), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pack();
            this.moveWindowToCenterScreen();
        }

        private JPanel initMainReportPanel(GarLoadedReport report) {
            GridBagConstraints constraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(3, 3, 0, 3), 0, 0);
            JPanel panel = new JPanel();
            this.addInfoAboutCities(report, panel, constraints);
            this.addInfoAboutStreets(report, panel, constraints);
            return panel;
        }

        private void addInfoAboutCities(GarLoadedReport report, JPanel panel, GridBagConstraints constraints) {
            if (report.isCreateNewCity()) {
                JPanel cityInfoPanel = new JPanel();
                BGSwingUtilites.wrapEmptyBorder((JComponent)cityInfoPanel);
                cityInfoPanel.add(new JLabel("\u0411\u044b\u043b \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d \u043d\u043e\u0432\u044b\u0439 \u043d\u0430\u0441\u0435\u043b\u0451\u043d\u043d\u044b\u0439 \u043f\u0443\u043d\u043a\u0442:"));
                cityInfoPanel.add(new JLabel(String.format("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435: %s, ID=%s", report.getNewCityName(), report.getNewCityId())));
                panel.add((Component)cityInfoPanel, constraints);
            }
        }

        private void addInfoAboutStreets(GarLoadedReport report, JPanel panel, GridBagConstraints constraints) {
            if (Utils.notEmptyCollection((Collection)report.getNewStreets())) {
                for (GarAddressStreet street : report.getNewStreets()) {
                    JPanel streetPanel = new JPanel();
                    BGSwingUtilites.wrapEmptyBorder((JComponent)streetPanel);
                    streetPanel.add(new JLabel(street.getTypeName() + "." + street.getTitle()));
                    streetPanel.add(new JLabel("(\u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u043e \u0434\u043e\u043c\u043e\u0432: " + (street.getHouses() != null ? street.getHouses().size() : 0) + ")"));
                    panel.add((Component)streetPanel, constraints);
                }
            } else {
                JPanel streetPanel = new JPanel();
                BGSwingUtilites.wrapEmptyBorder((JComponent)streetPanel);
                streetPanel.add(new JLabel("\u041d\u0435 \u0431\u044b\u043b\u043e \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u043e \u043d\u0438 \u043e\u0434\u043d\u043e\u0439 \u043d\u043e\u0432\u043e\u0439 \u0443\u043b\u0438\u0446\u044b(\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e, \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435 \u0443\u043b\u0438\u0446\u044b \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0442)"));
                panel.add((Component)streetPanel, constraints);
            }
        }
    }

    private static final class SelectCountryDialog
    extends BGDialog {
        private final BGUComboBox<IdTitle> countriesComboBox = new BGUComboBox();

        public SelectCountryDialog(List<IdTitle> countries) {
            this.getContentPane().setLayout(new GridBagLayout());
            this.setTitle("\u041e\u0442\u0447\u0435\u0442 \u043e \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u043d\u044b\u0445 \u0430\u0434\u0440\u0435\u0441\u0430\u0445");
            this.setModal(true);
            this.setResizable(false);
            Dimension dimension = new Dimension(400, 200);
            this.setSize(dimension);
            this.setMinimumSize(dimension);
            this.setPreferredSize(dimension);
            JPanel panel = new JPanel(new GridBagLayout());
            this.countriesComboBox.setData(countries);
            GridBagConstraints constraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 2, new Insets(3, 3, 0, 3), 0, 0);
            panel.add((Component)new JLabel("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u0430\u043d\u0443 \u0438\u0437 \u0441\u043f\u0438\u0441\u043a\u0430 \u0434\u043b\u044f \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0430\u0434\u0440\u0435\u0441\u043e\u0432"), constraints);
            panel.add((Component)this.countriesComboBox, constraints);
            BGButton selectButton = new BGButton("\u0412\u044b\u0431\u0440\u0430\u0442\u044c");
            selectButton.addActionListener(e -> this.setVisible(false));
            panel.add((Component)selectButton, constraints);
            this.add(panel);
            this.pack();
            this.moveWindowToCenterScreen();
        }

        private int getSelectedCountryId() {
            IdTitle selected = (IdTitle)this.countriesComboBox.getSelectedItem();
            return selected == null ? 0 : selected.getId();
        }
    }

    private static final class LoadSettingsPanel
    extends JPanel {
        private final JCheckBox cityTitleWithRegion = new JCheckBox("\u0440\u0435\u0433\u0438\u043e\u043d");
        private final JCheckBox cityTitleWithArea = new JCheckBox("\u0440\u0430\u0439\u043e\u043d");
        private final JCheckBox ignoreStreetType = new JCheckBox();

        public LoadSettingsPanel() {
            super(new GridBagLayout());
            this.setBorder((Border)new BGTitleBorder("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438"));
            this.add((Component)new JLabel("\u0412 \u0438\u043c\u044f \u0433\u043e\u0440\u043e\u0434\u0430 \u0432\u043a\u043b\u044e\u0447\u0430\u0442\u044c:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this.cityTitleWithRegion, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)new JLabel("\u0418\u0433\u043d\u043e\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0441\u043e\u043a\u0440\u0430\u0449\u0435\u043d\u0438\u0435 \u0432 \u0443\u043b\u0438\u0446\u0430\u0445:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this.ignoreStreetType, new GridBagConstraints(1, 1, 2, 1, 1.0, 1.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        }
    }
}

