/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.runtime.device;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.network.dhcp.DhcpPacket;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.bgbilling.modules.inet.server.runtime.device.PacketValueExtractor;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.ref.ConcurrentWeakHashMap;

public abstract class AbstractInetDeviceRuntime {
    private static final Logger logger = LogManager.getLogger();
    public static final int DEVICE_SEARCH_MODE_REMOTE_ID_SUB = 1;
    public static final int DEVICE_SEARCH_MODE_GIADDR = 2;
    private final PacketValueExtractor packetValueExtractor;
    private static final ConcurrentWeakHashMap<ParameterMap, PacketValueExtractor> EXTRACTOR_CACHE = new ConcurrentWeakHashMap();

    public AbstractInetDeviceRuntime(ParameterMap config) throws BGException {
        PacketValueExtractor packetValueExtractor = null;
        try {
            packetValueExtractor = (PacketValueExtractor)EXTRACTOR_CACHE.computeIfAbsent((Object)config, a -> new PacketValueExtractor((ParameterMap)a));
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        this.packetValueExtractor = packetValueExtractor;
    }

    public PacketValueExtractor getPacketValueExtractor() {
        return this.packetValueExtractor;
    }

    public Object getOption82AgentRemoteId(DhcpPacket request) {
        return this.packetValueExtractor.getOption82AgentRemoteId(request, false);
    }

    public Object getOption82AgentRemoteId(RadiusPacket request) {
        return this.packetValueExtractor.getAgentRemoteId(request);
    }

    public Object getOption82CircuitId(RadiusPacket request) {
        return this.packetValueExtractor.getOption82CircuitId(request);
    }

    public int getOption82VlanId(DhcpPacket request) {
        return this.packetValueExtractor.getOption82VlanId(request, false);
    }

    public int getOption82AgentSvlanId(DhcpPacket request) {
        return this.packetValueExtractor.getOption82AgentSvlanId(request, false);
    }

    public int getOption82VlanId(RadiusPacket request) {
        return this.packetValueExtractor.getOption82VlanId(request, false);
    }

    public int getOption82InterfaceId(DhcpPacket request) {
        return this.packetValueExtractor.getOption82InterfaceId(request, false);
    }

    public int getOption82InterfaceId(RadiusPacket request) {
        return this.packetValueExtractor.getOption82InterfaceId(request, false);
    }

    public Object getOption82Login(DhcpPacket request) {
        return this.packetValueExtractor.getOption82Login(request);
    }
}

