/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceZone;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractDirectoryIdDao;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class VoiceZoneDao
extends AbstractDirectoryIdDao<VoiceZone> {
    public VoiceZoneDao(Connection con, int moduleId) {
        super(con, moduleId, "voice_tariff_zone");
        this.fields = new HashMap();
        this.fields.put("id", "id");
        this.fields.put("title", "title");
    }

    public SearchResult<VoiceZone> searchVoiceZone(SearchResult<VoiceZone> searchResult) throws BGException {
        List list = searchResult.getList();
        Page page = searchResult.getPage();
        String[] sort = searchResult.getSort();
        String query = "SELECT SQL_CALC_FOUND_ROWS * FROM " + this.tableName + this.getSQLOrder(sort, this.fields) + page.sqlLimit();
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                list.add(this.getFromRS(rs));
            }
            rs.close();
            page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return searchResult;
    }

    public VoiceZone get(String title) throws BGException {
        return (VoiceZone)super.get("title=?", new Object[]{title});
    }

    public List<VoiceZone> list() throws BGException {
        return super.list(null, null, new Object[0]);
    }

    protected VoiceZone getFromRS(ResultSet rs) throws SQLException, BGException {
        VoiceZone zone = new VoiceZone();
        zone.setId(rs.getInt("id"));
        zone.setTitle(rs.getString("title"));
        return zone;
    }

    protected void updateImpl(VoiceZone b) throws BGException, SQLException {
        String fieldPart = " SET title=?";
        String query = b.getId() > 0 ? "UPDATE " + this.tableName + fieldPart + " WHERE id=?" : "INSERT INTO " + this.tableName + fieldPart;
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setString(index++, b.getTitle());
            if (b.getId() > 0) {
                ps.setInt(index++, b.getId());
            }
            ps.executeUpdate();
            if (b.getId() <= 0) {
                b.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
    }
}

