/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.onpay.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.onpay.common.bean.Transaction;
import ru.bitel.bgbilling.server.bean.AbstractTransactionManager;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class TransactionManager
extends AbstractTransactionManager<Transaction> {
    public TransactionManager(Connection con, int moduleId) {
        super(con, moduleId, "onpay_transaction");
        this.fields = new HashMap();
        this.fields.put("id", "id");
        this.fields.put("status", "status");
        this.fields.put("createDatetime", "create_date");
        this.fields.put("transactionDatetime", "transaction_date");
        this.fields.put("sum", "sum");
    }

    public void searchTransactionList(SearchResult<Transaction> searchResult, int onpayId, int contractId) throws BGException {
        ResultSet rs;
        PreparedStatement ps;
        if (searchResult == null) {
            throw new BGException("searchResult is null!");
        }
        Page page = searchResult.getPage();
        String[] sort = searchResult.getSort();
        Period period = searchResult.getPeriod();
        List list = searchResult.getList();
        String queryWhere = this.getQueryWhere(onpayId, contractId, period);
        StringBuilder query = new StringBuilder("SELECT * FROM ").append(this.tableName).append(queryWhere);
        query.append(this.getSQLOrder(sort, this.fields)).append(page.sqlLimit());
        try {
            ps = this.con.prepareStatement(query.toString());
            try {
                this.psSetPeriod(ps, 1, period);
                rs = ps.executeQuery();
                try {
                    while (rs.next()) {
                        list.add(this.getFromRS(rs));
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        query.setLength(0);
        query.append("SELECT COUNT(*), SUM(sum) FROM ").append(this.tableName).append(queryWhere);
        try {
            ps = this.con.prepareStatement(query.toString());
            try {
                this.psSetPeriod(ps, 1, period);
                rs = ps.executeQuery();
                try {
                    while (rs.next()) {
                        page.setRecordCount(rs.getInt(1));
                        searchResult.setSum(rs.getBigDecimal(2));
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    private String getQueryWhere(int onpayId, int contractId, Period period) {
        StringBuilder query = new StringBuilder(" WHERE true");
        if (onpayId > 0) {
            query.append(" AND sys_payment_id=").append(onpayId);
        }
        if (contractId > 0) {
            query.append(" AND contract_id=").append(contractId);
        }
        query.append(this.queryPeriod(period, "payment_date"));
        return query.toString();
    }

    public List<Transaction> getTransactionList(int contractId, Date fromDate, Date toDate) throws BGException {
        ArrayList<Transaction> result = new ArrayList<Transaction>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            StringBuilder query = new StringBuilder("SELECT * FROM ").append(this.tableName).append(" WHERE true");
            if (contractId > 0) {
                query.append(" AND contract_id=").append(contractId);
            }
            if (fromDate != null) {
                query.append(" AND payment_date>=?");
            }
            if (toDate != null) {
                query.append(" AND payment_date<=?");
            }
            ps = this.con.prepareStatement(query.toString());
            int index = 1;
            if (fromDate != null) {
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)fromDate));
            }
            if (toDate != null) {
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)toDate));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getFromRS(rs));
            }
            ps.close();
            rs.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public Transaction getTransaction(int id) throws BGException {
        Transaction result = null;
        String query = "SELECT * FROM " + this.tableName + " WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, id);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result = this.getFromRS(rs);
                }
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    protected Transaction getFromRS(ResultSet rs) throws SQLException {
        return (Transaction)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setId(rs.getInt("id"))).setContractId(rs.getInt("contract_id"))).setPaymentId(rs.getInt("payment_id"))).setCreateDate((Date)rs.getTimestamp("payment_date"))).setSum(rs.getBigDecimal("sum"))).setSysPaymentData(rs.getString("sys_payment_data")).setTransactionId(rs.getString("sys_payment_id"))).setTransactionDate((Date)rs.getTimestamp("sys_payment_date"))).build();
    }

    protected void updateImpl(Transaction transaction) throws SQLException {
        String querySet = "contract_id=?, payment_id=?, payment_date=?, summa=?, sys_payment_data=?, sys_payment_id=?, sys_payment_date=?";
        try (PreparedStatement ps = this.prepareStatement((Id)transaction, querySet);){
            int index = 1;
            ps.setInt(index++, transaction.getContractId());
            ps.setInt(index++, transaction.getPaymentId());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)transaction.getCreateDate()));
            ps.setBigDecimal(index++, transaction.getSum());
            ps.setString(index++, transaction.getSysPaymentData());
            ps.setString(index++, transaction.getTransactionId());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)transaction.getTransactionDate()));
            this.executeUpdate((Id)transaction, index, ps);
        }
    }
}

