/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.ref;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.concurrent.ConcurrentMap;
import ru.bitel.common.ref.ReferenceValueConcurrentHashMap;

public class SoftValueConcurrentHashMap<K, V>
extends ReferenceValueConcurrentHashMap<K, V>
implements ConcurrentMap<K, V> {
    public SoftValueConcurrentHashMap() {
    }

    public SoftValueConcurrentHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public SoftValueConcurrentHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    @Override
    protected Reference<V> newReference(K k, V v) {
        return new SoftValue<K, V>(k, v, this.queue);
    }

    private static class SoftValue<K, V>
    extends SoftReference<V>
    implements ReferenceValueConcurrentHashMap.ReferenceValue<K> {
        private final K key;

        public SoftValue(K key, V referent, ReferenceQueue<? super V> q) {
            super(referent, q);
            this.key = key;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Reference) {
                Object my;
                Object other = ((Reference)obj).get();
                if (other == (my = this.get())) {
                    return true;
                }
                if (other != null) {
                    return other.equals(my);
                }
            }
            return false;
        }

        @Override
        public K getKey() {
            return this.key;
        }
    }
}

