/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.server.tariff;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import ru.bitel.bgbilling.kernel.tariff.server.tree.ServiceCost;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class SmartHouseServiceCost
extends ServiceCost {
    public final int productId;
    public final int activationModeId;
    public final Date activationTime;
    public Date prolongationTime;
    public int activationServiceId;
    public BigDecimal activationPrice = BigDecimal.ZERO;
    public boolean activationPriceExternal = false;
    public static final int PROLONGATION_REJECTED = 0;
    public static final int PROLONGATION_DELAYED = 1;
    public static final int PROLONGATION_APPROVED = 2;
    public static final int PROLONGATION_PROPORTIONAL = 3;
    public int prolongation = 0;
    public Date periodTimeFrom;
    public Date periodTimeTo;
    public int periodMode;
    public int periodAmount;
    public boolean periodAlign;
    public boolean periodProportional;
    public boolean ignoreBalance;
    public BigDecimal ignoreBalanceSumma = BigDecimal.ZERO;
    public Set<Integer> contractStatusSet = new HashSet<Integer>();
    public Set<Integer> deviceStateSet = new HashSet<Integer>();

    public SmartHouseServiceCost(int productId, int activationModeId, Date activationTime) {
        this.productId = productId;
        this.activationModeId = activationModeId;
        this.activationTime = activationTime;
    }

    public SmartHouseServiceCost newCost() {
        SmartHouseServiceCost result = (SmartHouseServiceCost)new SmartHouseServiceCost(this.productId, this.activationModeId, this.activationTime).setServiceId(this.serviceId).setServiceStart(this.serviceStart).setServiceEnd(this.serviceEnd).setAmount(this.amount).to(SmartHouseServiceCost.class);
        result.prolongationTime = this.prolongationTime;
        result.periodTimeFrom = this.periodTimeFrom;
        result.periodTimeTo = this.periodTimeTo;
        result.cost = this.cost;
        if (this.activationPriceExternal) {
            result.activationPrice = this.activationPrice;
            result.activationPriceExternal = true;
        } else {
            result.activationPrice = this.activationPrice;
        }
        return result;
    }

    protected String paramsToString() {
        try {
            StringBuilder result = new StringBuilder();
            result.append("pp: ");
            result.append("sid: ");
            result.append(this.serviceId);
            result.append("; periodFrom: ");
            result.append(TimeUtils.formatFullDate((Date)this.periodTimeFrom));
            result.append("; periodTo: ");
            result.append(TimeUtils.formatFullDate((Date)this.periodTimeTo));
            result.append("; serviceStart: ");
            result.append(TimeUtils.formatDate((LocalDate)this.serviceStart));
            result.append("; serviceEnd: ");
            result.append(TimeUtils.formatDate((LocalDate)this.serviceEnd));
            result.append("; accPeriodDays: ");
            result.append(this.accountingPeriodDays);
            result.append("; amount: ");
            result.append(this.amount);
            result.append("; cost: ");
            result.append(this.cost);
            if (this.ignoreBalanceSumma != BigDecimal.ZERO) {
                result.append("; ignoreBalanceSumma: ");
                result.append(this.ignoreBalanceSumma);
            }
            if (!this.contractStatusSet.isEmpty()) {
                result.append("; contractStatusSet: ");
                result.append(Utils.toString(this.contractStatusSet));
            }
            if (!this.deviceStateSet.isEmpty()) {
                result.append("; deviceStateSet: ");
                result.append(Utils.toString(this.deviceStateSet));
            }
            return result.toString();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

