/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceSession;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceSessionAccount;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractDao;

public class VoiceSessionAccountLogDao
extends AbstractDao<VoiceSessionAccount> {
    public static final String TABLE_VOICE_SESSION_ACCOUNT_LOG = "voice_session_account_log";

    public VoiceSessionAccountLogDao(Connection con, int moduleId, Date date) {
        super(con, moduleId, TABLE_VOICE_SESSION_ACCOUNT_LOG, date);
    }

    protected VoiceSessionAccountLogDao(Connection con, int moduleId, String tableName) {
        super(con, moduleId, tableName);
    }

    public List<VoiceSessionAccount> list(int sessionId) throws BGException {
        return super.list("sessionId=?", "", new Object[]{sessionId});
    }

    protected VoiceSessionAccount getFromRS(ResultSet rs) throws SQLException, BGException {
        VoiceSessionAccount account = new VoiceSessionAccount();
        account.setContractId(rs.getInt("contractId"));
        account.setSessionId((long)rs.getInt("sessionId"));
        account.setServiceId(rs.getInt("serviceId"));
        account.setAccount(rs.getBigDecimal("account"));
        account.setAmount((long)rs.getInt("amount"));
        account.setHour((Date)rs.getDate("hour"));
        account.setDeviceId(rs.getInt("deviceId"));
        return account;
    }

    protected void updateImpl(VoiceSessionAccount account) throws BGException, SQLException {
        String query = " REPLACE " + this.tableName + " SET  contractId = ?, sessionId = ?, serviceId = ?, account = ?, amount = ?, hour = ?, deviceId = ? ";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int idx = 1;
            this.setParams(account, ps, idx);
            ps.executeUpdate();
        }
    }

    private int setParams(VoiceSessionAccount account, PreparedStatement ps, int idx) throws SQLException {
        ps.setInt(idx++, account.getContractId());
        ps.setLong(idx++, account.getSessionId());
        ps.setInt(idx++, account.getServiceId());
        ps.setBigDecimal(idx++, account.getAccount());
        ps.setLong(idx++, account.getAmount());
        ps.setTimestamp(idx++, TimeUtils.convertDateToTimestamp((Date)account.getHour()));
        ps.setInt(idx++, account.getDeviceId());
        return idx;
    }

    public static void checkTables(Connection con, int moduleId, Date date) throws SQLException {
        Statement st = con.createStatement();
        String tableName = ServerUtils.getModuleMonthTableName((String)TABLE_VOICE_SESSION_ACCOUNT_LOG, (Date)date, (int)moduleId);
        String sessionTableName = ServerUtils.getModuleMonthTableName((String)"voice_session_log", (Date)date, (int)moduleId);
        if (!ServerUtils.tableExists((Connection)con, (String)tableName)) {
            st.executeUpdate(" CREATE TABLE " + tableName + " ( `contractId` INT(10) UNSIGNED NOT NULL ,`sessionId` BIGINT(20) NOT NULL,`serviceId` INT(10) UNSIGNED NOT NULL ,`account` DECIMAL(10,5) NOT NULL ,`amount` BIGINT(20) NULL ,`hour` DATETIME NOT NULL, `deviceId` INT NOT NULL, PRIMARY KEY (`contractId`, `sessionId`, `serviceId`),KEY `session` (`sessionId`),KEY `service` (`serviceId`),INDEX `deviceId` (`deviceId`),INDEX `hour` (`hour`),CONSTRAINT `fk_" + tableName + "_session` FOREIGN KEY (`sessionId`) REFERENCES `" + sessionTableName + "` (`id`) ON UPDATE CASCADE ON DELETE CASCADE )");
        }
        st.close();
    }

    public void insertAccount(List<VoiceSessionAccount> accounts) throws BGException {
        this.updateAccountInternal(accounts, false);
    }

    public void updateAccount(List<VoiceSessionAccount> accounts) throws BGException {
        this.updateAccountInternal(accounts, true);
    }

    public void updateAccountInternal(List<VoiceSessionAccount> accounts, boolean replace) throws BGException {
        if (accounts.size() == 0) {
            return;
        }
        StringBuffer query = new StringBuffer(accounts.size() * 15);
        query.append((replace ? "REPLACE" : "INSERT") + " INTO " + this.tableName + " (contractId, sessionId, serviceId, account, amount, hour, deviceId ) VALUES ");
        for (int i = 0; i < accounts.size(); ++i) {
            if (i > 0) {
                query.append(",");
            }
            query.append(" (?,?,?,?,?,?,?)");
        }
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            int idx = 1;
            for (VoiceSessionAccount account : accounts) {
                idx = this.setParams(account, ps, idx);
            }
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void deleteAccounts(int divizer, int remainder, Date hour, int deviceId) throws BGException {
        String query = "DELETE OM " + this.tableName + " WHERE  contractId % ? = ? and hour = ? and deviceId  = ? ";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, divizer);
            ps.setInt(2, remainder);
            ps.setTimestamp(3, TimeUtils.convertDateToTimestamp((Date)hour));
            ps.setInt(4, deviceId);
            ps.executeUpdate();
        }
        catch (Exception ex) {
            throw new BGException();
        }
    }

    public void deleteAccounts(List<VoiceSession> list) throws BGException {
        if (!ServerUtils.tableExists((Connection)this.con, (String)this.tableName)) {
            return;
        }
        String query = "DELETE FROM " + this.tableName + " WHERE 1 = 1";
        query = query + " AND sessionId IN (" + Utils.toString((Iterable)list.stream().map(s -> s.getId()).collect(Collectors.toList())) + ")  ";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.executeUpdate();
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }
}

