/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.subscription.server.tariff.tree;

import java.util.Date;
import java.util.Map;
import ru.bitel.bgbilling.kernel.tariff.server.tree.old.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.old.TariffRequest;
import ru.bitel.common.TimeUtils;

public class PeriodTariffTreeNode
extends DefaultTariffTreeNode {
    private Date date1;
    private Date date2;
    protected boolean needCheckPeriodOnReset = false;

    public void init(String dataStr, int deep, int nodeID) {
        super.init(dataStr, deep, nodeID);
        Map map = this.getDataInHash();
        this.date1 = TimeUtils.parseDate((String)((String)map.get("date1")), (String)"dd.MM.yyyy");
        this.date2 = TimeUtils.parseDate((String)((String)map.get("date2")), (String)"dd.MM.yyyy");
    }

    public void processRequest(TariffRequest request) {
        Date date = (Date)request.getRequestParam("time");
        String action = (String)request.getRequestParam("action");
        if (action != null && action.equals("reset")) {
            if (!this.needCheckPeriodOnReset || date != null && (this.date1 == null || TimeUtils.dateBeforeOrEq((Date)this.date1, (Date)date)) && (this.date2 == null || TimeUtils.dateBeforeOrEq((Date)date, (Date)this.date2))) {
                this.processForChilds(request);
            }
        } else if (date != null && (this.date1 == null || TimeUtils.dateBeforeOrEq((Date)this.date1, (Date)date)) && (this.date2 == null || TimeUtils.dateBeforeOrEq((Date)date, (Date)this.date2))) {
            this.processForChilds(request);
        } else {
            request.addHistoryMsg("Not accepted on period 2 date=" + TimeUtils.formatDate((Date)date) + "; date1=" + TimeUtils.formatDate((Date)this.date1) + "; date2=" + TimeUtils.formatDate((Date)this.date2) + "\n");
        }
    }
}

