/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voiceip.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.modules.voiceip.server.bean.LoginType;

public class LoginTypeManager {
    private Connection con;
    private String tableName;

    public LoginTypeManager(Connection con, int mid) {
        this.con = con;
        this.tableName = "voiceip_login_type_" + mid;
    }

    public Map<Integer, LoginType> getTypeMap() {
        HashMap<Integer, LoginType> result = new HashMap<Integer, LoginType>();
        for (LoginType type : this.getTypeList()) {
            result.put(type.getId(), type);
        }
        return result;
    }

    public List<LoginType> getTypeList() {
        ArrayList<LoginType> result = new ArrayList<LoginType>();
        try {
            String query = "SELECT * FROM " + this.tableName + " ORDER BY title";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getTypeFromRs(rs));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void updateType(LoginType type) {
        try {
            String query = null;
            PreparedStatement ps = null;
            if (type.getId() <= 0) {
                query = "INSERT INTO " + this.tableName + " (brm, pswd_check, fm_aci, fm_aco, fm_aui, fm_auo, dc_filter, title, comment, out_tariff_mode, in_tariff_mode, ignore_account, attrs) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                ps = this.con.prepareStatement(query);
            } else {
                query = "UPDATE " + this.tableName + " SET brm=?, pswd_check=?, fm_aci=?, fm_aco=?, fm_aui=?, fm_auo=?, dc_filter=?, title=?, comment=?, out_tariff_mode=?, in_tariff_mode=?, ignore_account=?, attrs=? WHERE id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(14, type.getId());
            }
            ps.setInt(1, type.getBalanceRecalcMode());
            ps.setBoolean(2, type.isCheckPassword());
            ps.setInt(3, type.getFindModeAcctIn());
            ps.setInt(4, type.getFindModeAcctOut());
            ps.setInt(5, type.getFindModeAuthIn());
            ps.setInt(6, type.getFindModeAuthOut());
            ps.setInt(7, type.getUseDcFilterMode());
            ps.setString(8, type.getTitle());
            ps.setString(9, type.getComment());
            ps.setInt(10, type.getOutgoingTariffMode());
            ps.setInt(11, type.getIncomingTariffMode());
            ps.setBoolean(12, type.isIgnoreAccount());
            ps.setString(13, type.getAttributes());
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteType(int id) {
        try {
            String query = "DELETE FROM " + this.tableName + " WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public LoginType getTypeById(int id) {
        LoginType result = null;
        try {
            String query = "SELECT * FROM " + this.tableName + " WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = this.getTypeFromRs(rs);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private LoginType getTypeFromRs(ResultSet rs) throws SQLException {
        LoginType result = new LoginType();
        result.setId(rs.getInt("id"));
        result.setTitle(rs.getString("title"));
        result.setComment(rs.getString("comment"));
        result.setBalanceRecalcMode(rs.getInt("brm"));
        result.setCheckPassword(rs.getBoolean("pswd_check"));
        result.setFindModeAcctIn(rs.getInt("fm_aci"));
        result.setFindModeAcctOut(rs.getInt("fm_aco"));
        result.setFindModeAuthIn(rs.getInt("fm_aui"));
        result.setFindModeAuthOut(rs.getInt("fm_auo"));
        result.setUseDcFilterMode(rs.getInt("dc_filter"));
        result.setOutgoingTariffMode(rs.getInt("out_tariff_mode"));
        result.setIncomingTariffMode(rs.getInt("in_tariff_mode"));
        result.setIgnoreAccount(rs.getBoolean("ignore_account"));
        result.setAttributes(rs.getString("attrs"));
        return result;
    }

    public Map<Integer, List<String[]>> getAttributesMap() {
        HashMap<Integer, List<String[]>> result = new HashMap<Integer, List<String[]>>();
        try {
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery("SELECT id, attrs FROM " + this.tableName);
            while (rs.next()) {
                int tid = rs.getInt(1);
                String _attrs = rs.getString(2);
                if (_attrs == null) continue;
                String[] attrs = _attrs.split("\\s*\n\\s*");
                ArrayList<String[]> attrList = new ArrayList<String[]>(5);
                for (String attrAndValue : attrs) {
                    int pos = attrAndValue.indexOf("=");
                    if (pos <= 0) continue;
                    String attr = attrAndValue.substring(0, pos);
                    String value = attrAndValue.substring(pos + 1);
                    attrList.add(new String[]{attr, value});
                }
                result.put(tid, attrList);
            }
            rs.close();
            st.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }
}

