/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.botmanager.client.scheme;

import bitel.billing.module.common.BGDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.bushe.swing.event.EventBus;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.modules.botmanager.client.scheme.DialogNode;
import ru.bitel.bgbilling.modules.botmanager.client.scheme.DialogScheme;
import ru.bitel.bgbilling.modules.botmanager.client.scheme.OpenDialogOnSchemeEvent;
import ru.bitel.bgbilling.modules.botmanager.client.scheme.ViewSelectedOnSchemeDialogPanel;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotDialog;

public class DialogSchemePanel
extends BGDialog {
    private final Font idLabelFont = new Font("Serif", 0, 9);
    private JTree schemeTree = new JTree();
    private ViewSelectedOnSchemeDialogPanel viewerDialog = new ViewSelectedOnSchemeDialogPanel();

    public DialogSchemePanel(DialogScheme scheme) {
        this.setTitle("\u0421\u0445\u0435\u043c\u0430 \u043f\u043e\u0441\u0442\u0440\u043e\u0435\u043d\u0438\u044f \u0434\u0438\u0430\u043b\u043e\u0433\u043e\u0432");
        BGSplitPaneNoBorder splitPane = new BGSplitPaneNoBorder(1, (Component)new JScrollPane(this.schemeTree), (Component)this.viewerDialog, 700L);
        this.getContentPane().add((Component)splitPane);
        this.pack();
        this.setMinimumSize(new Dimension(1100, 800));
        this.setLocationRelativeTo(JOptionPane.getRootFrame());
        this.buildScheme(scheme.getRootNode());
    }

    private void buildScheme(DialogNode dialogNode) {
        this.schemeTree.setRootVisible(true);
        this.schemeTree.setModel(new BotDialogTreeModel(dialogNode));
        this.schemeTree.getSelectionModel().setSelectionMode(1);
        this.schemeTree.setCellRenderer(new DialogNodeTreeRenderer());
        this.schemeTree.addTreeSelectionListener(e -> {
            TreePath path = e.getPath();
            if (path != null && path.getLastPathComponent() instanceof DialogNode) {
                this.viewerDialog.viewDialog(((DialogNode)path.getLastPathComponent()).getBotDialog());
                this.revalidate();
                this.repaint();
            }
        });
        this.schemeTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                BotDialog selectedBotDialog;
                Object obj;
                if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e) && (obj = DialogSchemePanel.this.schemeTree.getLastSelectedPathComponent()) instanceof DialogNode && (selectedBotDialog = ((DialogNode)obj).getBotDialog()) != null) {
                    EventBus.publish((Object)new OpenDialogOnSchemeEvent(selectedBotDialog));
                }
            }
        });
    }

    private static class BotDialogTreeModel
    implements TreeModel {
        private TreeNode root;
        private EventListenerList listenerList = new EventListenerList();

        public BotDialogTreeModel(TreeNode root) {
            this.root = root;
        }

        @Override
        public Object getRoot() {
            return this.root;
        }

        @Override
        public Object getChild(Object parent, int index) {
            if (parent instanceof DialogNode) {
                return ((DialogNode)parent).getChilds().get(index);
            }
            return null;
        }

        @Override
        public int getChildCount(Object parent) {
            if (parent instanceof DialogNode) {
                List<TreeNode> childs = ((DialogNode)parent).getChilds();
                if (childs == null) {
                    return 0;
                }
                return childs.size();
            }
            return 0;
        }

        @Override
        public boolean isLeaf(Object node) {
            return this.getChildCount(node) <= 0;
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            if (parent instanceof DialogNode && child instanceof DialogNode) {
                DialogNode childDialogNode = (DialogNode)child;
                List<TreeNode> childs = ((DialogNode)parent).getChilds();
                for (int i = 0; i < childs.size(); ++i) {
                    TreeNode childNode = childs.get(i);
                    if (!(childNode instanceof DialogNode) || !childNode.equals(childDialogNode)) continue;
                    return i;
                }
            }
            return 0;
        }

        @Override
        public void addTreeModelListener(TreeModelListener l) {
            this.listenerList.add(TreeModelListener.class, l);
        }

        @Override
        public void removeTreeModelListener(TreeModelListener l) {
            this.listenerList.remove(TreeModelListener.class, l);
        }
    }

    private class DialogNodeTreeRenderer
    extends DefaultTreeCellRenderer {
        private final Border border = BorderFactory.createCompoundBorder(BorderFactory.createSoftBevelBorder(0, Color.GRAY, Color.GRAY), BorderFactory.createCompoundBorder(BorderFactory.createSoftBevelBorder(0, Color.GRAY, Color.GRAY), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        private final Border selectedTreeNodeBorder = BorderFactory.createLineBorder(Color.BLUE, 2);

        private DialogNodeTreeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JPanel nodePanel = this.makePanelNode((DialogNode)value);
            nodePanel.setBorder(hasFocus ? this.selectedTreeNodeBorder : this.border);
            return nodePanel;
        }

        private JPanel makePanelNode(final DialogNode dialogNode) {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBackground(Color.PINK);
            panel.setBorder(this.border);
            panel.add((Component)new JLabel(dialogNode.getBotDialog().getTitle()), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            JLabel idLabel = new JLabel("ID=" + dialogNode.getBotDialog().getId());
            idLabel.setFont(DialogSchemePanel.this.idLabelFont);
            panel.add((Component)idLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            panel.addMouseListener(new MouseAdapter(this){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e)) {
                        EventBus.publish((Object)new OpenDialogOnSchemeEvent(dialogNode.getBotDialog()));
                    }
                }
            });
            return panel;
        }
    }
}

