/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.runtime;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.inet.server.runtime.AbstractEventWorker;

public abstract class AsyncEventWorker
extends AbstractEventWorker
implements EventListener<Event>,
Runnable {
    private static final Logger logger = LogManager.getLogger();

    public AsyncEventWorker(ScheduledExecutorService scheduledExecutorService, BlockingQueue<Object> taskQueue, int capacity, int maxCapacity, long errorPause) throws BGException {
        super(scheduledExecutorService, taskQueue, capacity, maxCapacity, errorPause);
    }

    public void doTasks(long waitNextTask, int batchSize, long batchWait, long batchPause) throws BGException {
        try {
            Object task;
            ArrayList<FutureTaskEntry> taskEntryList = new ArrayList<FutureTaskEntry>();
            int count = 0;
            while ((task = this.taskQueue.poll(waitNextTask, TimeUnit.MILLISECONDS)) != null) {
                try {
                    Object result = this.doTask(task);
                    ++count;
                    if (result instanceof Object[]) {
                        Object[] array = (Object[])result;
                        result = array[0];
                        array[0] = task;
                        if (result instanceof Future) {
                            taskEntryList.add(new FutureTaskEntry(this, array, (Future)result));
                        } else {
                            this.taskDone(array, result);
                        }
                    } else if (result instanceof Future) {
                        taskEntryList.add(new FutureTaskEntry(this, task, (Future)result));
                    } else {
                        this.taskDone(task, result);
                    }
                    if (batchSize <= 0) {
                        if (taskEntryList.size() > 20) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("Waiting " + batchWait + " millis for future results will done...");
                            }
                            if (this.awaitResult(taskEntryList, batchWait, TimeUnit.MILLISECONDS) < 0L) {
                                throw new BGException((Throwable)new TimeoutException());
                            }
                        }
                    } else if ((count + 1) % batchSize == 0) {
                        if (taskEntryList.size() > 0) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("Waiting " + batchWait + " millis for future results will done...");
                            }
                            if (this.awaitResult(taskEntryList, batchWait, TimeUnit.MILLISECONDS) < 0L) {
                                throw new BGException((Throwable)new TimeoutException());
                            }
                        }
                        Thread.sleep(batchPause);
                    }
                    int queueCount = this.count.decrementAndGet();
                    if (this.needUnlink && queueCount < this.capacity) {
                        this.needUnlink = false;
                        this.link();
                    }
                    if (this.linked || queueCount >= this.capacity) continue;
                    this.link();
                }
                catch (BGException ex) {
                    boolean currentTask = false;
                    for (FutureTaskEntry entry : taskEntryList) {
                        if (entry.task == task) {
                            currentTask = true;
                        }
                        this.putFirst(entry.task);
                    }
                    if (!currentTask) {
                        this.putFirst(task);
                    }
                    throw ex;
                }
            }
            if (taskEntryList.size() > 0) {
                long nanos;
                if (logger.isDebugEnabled()) {
                    logger.debug("Waiting " + batchWait + " millis for last future results will done...");
                }
                if ((nanos = this.awaitResult(taskEntryList, batchWait, TimeUnit.MILLISECONDS)) < 0L) {
                    throw new BGException((Throwable)new TimeoutException());
                }
            }
            if ((this.needUnlink || !this.linked) && this.count.get() < this.capacity) {
                this.link();
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    protected abstract Object doTask(Object var1) throws BGException;

    protected abstract void taskDone(Object var1, Object var2) throws BGException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long awaitResult(List<FutureTaskEntry> taskEntryList, long timeout, TimeUnit unit) throws InterruptedException, BGException {
        if (taskEntryList.size() == 0) {
            return 0L;
        }
        nanos = unit.toNanos(timeout);
        done = false;
        try {
            lastTime = System.nanoTime();
            iter = taskEntryList.iterator();
            while (iter.hasNext()) {
                entry = iter.next();
                f = entry.result;
                result /* !! */  = Boolean.FALSE;
                if (f.isDone()) ** GOTO lbl41
                if (nanos > 0L) break block28;
                var14_12 = -1L;
                if (done) ** GOTO lbl73
            }
            ** GOTO lbl51
        }
        catch (Throwable var22_32) {
            block32: {
                block33: {
                    if (done) break block32;
                    AsyncEventWorker.logger.info("Timeout waiting futures");
                    iter = taskEntryList.iterator();
                    break block33;
lbl99:
                    // 3 sources

                    while (iter.hasNext()) {
                        entry = iter.next();
                        f = entry.result;
                        if (f.isDone()) {
                            result /* !! */  = Boolean.FALSE;
                            try {
                                result /* !! */  = f.get();
                            }
                            catch (ExecutionException ex) {
                                AsyncEventWorker.logger.error(ex.getMessage(), (Throwable)ex);
                            }
                            iter.remove();
                            this.taskDone(entry.task, result /* !! */ );
                            continue;
                        }
                        f.cancel(true);
                    }
lbl115:
                    // 2 sources

                    return var10_8;
                }
                while (iter.hasNext()) {
                    entry = iter.next();
                    f = entry.result;
                    if (f.isDone()) {
                        result /* !! */  = Boolean.FALSE;
                        try {
                            result /* !! */  = f.get();
                        }
                        catch (ExecutionException ex) {
                            AsyncEventWorker.logger.error(ex.getMessage(), (Throwable)ex);
                        }
                        iter.remove();
                        this.taskDone(entry.task, result /* !! */ );
                        continue;
                    }
                    f.cancel(true);
                }
            }
            throw var22_32;
        }
        {
            block28: {
                AsyncEventWorker.logger.info("Timeout waiting futures");
                iter = taskEntryList.iterator();
                ** GOTO lbl57
            }
            try {
                result /* !! */  = f.get(nanos, TimeUnit.NANOSECONDS);
                ** GOTO lbl37
            }
            catch (CancellationException var14_13) {
                ** GOTO lbl37
            }
            catch (ExecutionException ex) {
                AsyncEventWorker.logger.error(ex.getMessage(), (Throwable)ex);
                ** GOTO lbl37
            }
            catch (TimeoutException toe) {
                block29: {
                    block30: {
                        block31: {
                            var15_29 = -1L;
                            if (done) break block29;
                            AsyncEventWorker.logger.info("Timeout waiting futures");
                            iter = taskEntryList.iterator();
                            break block30;
lbl37:
                            // 4 sources

                            now = System.nanoTime();
                            nanos -= now - lastTime;
                            lastTime = now;
                            break block31;
lbl41:
                            // 1 sources

                            try {
                                result /* !! */  = f.get();
                            }
                            catch (ExecutionException ex) {
                                AsyncEventWorker.logger.error(ex.getMessage(), (Throwable)ex);
                            }
                        }
                        AsyncEventWorker.logger.info("Future is done");
                        iter.remove();
                        this.taskDone(entry.task, result /* !! */ );
                        continue;
lbl51:
                        // 1 sources

                        done = true;
                        var10_8 = Math.max(nanos, 0L);
                        if (done) ** GOTO lbl115
                        AsyncEventWorker.logger.info("Timeout waiting futures");
                        iter = taskEntryList.iterator();
                        ** GOTO lbl99
lbl57:
                        // 3 sources

                        while (iter.hasNext()) {
                            entry = iter.next();
                            f = entry.result;
                            if (f.isDone()) {
                                result /* !! */  = Boolean.FALSE;
                                try {
                                    result /* !! */  = f.get();
                                }
                                catch (ExecutionException ex) {
                                    AsyncEventWorker.logger.error(ex.getMessage(), (Throwable)ex);
                                }
                                iter.remove();
                                this.taskDone(entry.task, result /* !! */ );
                                continue;
                            }
                            f.cancel(true);
                        }
lbl73:
                        // 2 sources

                        return var14_12;
                    }
                    while (iter.hasNext()) {
                        entry = iter.next();
                        f = entry.result;
                        if (f.isDone()) {
                            result /* !! */  = Boolean.FALSE;
                            try {
                                result /* !! */  = f.get();
                            }
                            catch (ExecutionException ex) {
                                AsyncEventWorker.logger.error(ex.getMessage(), (Throwable)ex);
                            }
                            iter.remove();
                            this.taskDone(entry.task, result /* !! */ );
                            continue;
                        }
                        f.cancel(true);
                    }
                }
                return var15_29;
                break;
            }
        }
    }

    class FutureTaskEntry {
        final Object task;
        final Future<?> result;

        public FutureTaskEntry(AsyncEventWorker this$0, Object task, Future<?> result) {
            this.task = task;
            this.result = result;
        }
    }
}

