/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server;

import bitel.billing.server.ModuleBase;
import bitel.billing.server.contract.bean.ContractServiceManager;
import jakarta.annotation.Resource;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.MenuItem;
import ru.bitel.bgbilling.kernel.container.managed.ContainerContext;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.container.resource.ResourceAdapter;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ModuleEntity;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntime;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.events.ContractTariffUpdateEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractCloseEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractDeleteEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractWrapEvent;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.CardPacket;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.StatusEvent;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.UserCard;
import ru.bitel.bgbilling.modules.cerbercrypt.server.DigitalTVServiceActivator;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.CardPacketManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.StatusEventManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.TariffRequestManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.UserCardManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.event.SubscriptionChangedEvent;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.XMLDatabaseSerializer;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Id;

public class Module
extends ModuleBase {
    private static final String[] PACKAGES = new String[]{"ru.bitel.bgbilling.modules.cerbercrypt.server"};

    public String[] getServerPackages() {
        return PACKAGES;
    }

    public void serializeContract(Connection con, int cid, int mid, XMLStreamWriter tables, boolean onlyCurrent) throws SQLException, XMLStreamException {
        ServerUtils.addItemsFromRS((Connection)con, (XMLStreamWriter)tables, (String)("user_card_" + mid), (String)"cid", (String)String.valueOf(cid), null, (boolean)onlyCurrent, (String)"date1", (String)"date2");
        ServerUtils.addItemsFromRS((Connection)con, (XMLStreamWriter)tables, (String)("card_" + mid), (String)"cid", (String)String.valueOf(cid), null, (boolean)false, null, null);
        String query = "SELECT card_packet.*, packet.title AS _packet_title FROM card_packet_" + mid + " AS card_packet LEFT JOIN packet_" + mid + " AS packet ON card_packet.pid=packet.id WHERE card_packet.cid=? ";
        if (onlyCurrent) {
            query = query + " AND card_packet.date1<=CURDATE() AND (card_packet.date2 IS NULL OR CURDATE()<=card_packet.date2)";
        }
        PreparedStatement ps = con.prepareStatement(query);
        ps.setInt(1, cid);
        ResultSet rs = ps.executeQuery();
        new XMLDatabaseSerializer(tables).addItemsFromRS("card_packet_" + mid, null, null, rs);
        rs.close();
        ps.close();
    }

    public void moduleAction(ServerContext ctx, int mid, Event event) throws Exception {
        super.moduleAction(ctx, mid, event);
        int cid = event.getContractId();
        if (event instanceof ContractDeleteEvent) {
            ContractDeleteEvent cdEvent = (ContractDeleteEvent)event;
            if (!cdEvent.isCheck()) {
                Connection con = ctx.getConnection();
                ServerUtils.deleteRowsFromTable((Connection)con, (String)("user_card_" + mid), (String)"cid", (String)String.valueOf(cid), null);
                ServerUtils.deleteRowsFromTable((Connection)con, (String)("card_packet_" + mid), (String)"cid", (String)String.valueOf(cid), null);
            }
        } else if (event instanceof ContractCloseEvent) {
            ContractCloseEvent ccEvent = (ContractCloseEvent)event;
            if (ccEvent.isCheck()) {
                return;
            }
            Connection con = ctx.getConnection();
            CardPacketManager cpm = new CardPacketManager(con, mid);
            UserCardManager ucm = new UserCardManager(con, mid, 0);
            Date date = ccEvent.getDate();
            List<UserCard> cards = ucm.getList(cid);
            for (UserCard userCard : cards) {
                if (userCard.getDate2() != null && !userCard.getDate2().after(ccEvent.getDate())) continue;
                userCard.setDate2(ccEvent.getDate());
                ucm.update((Id)userCard);
            }
            List<CardPacket> cpackets = cpm.getCardPacketList(cid, date);
            for (CardPacket cpack : cpackets) {
                if (cpack.getDateTo() != null && !cpack.getDateTo().after(date)) continue;
                cpack.setDateTo(date);
                cpm.updateCardPacket(cpack);
            }
            ucm.close();
        } else if (event instanceof ContractWrapEvent) {
            ContractWrapEvent cwEvent = (ContractWrapEvent)event;
            if (cwEvent.isCheck()) {
                return;
            }
            Connection con = ctx.getConnection();
            CardPacketManager cpm = new CardPacketManager(con, mid);
            UserCardManager ucm = new UserCardManager(con, mid, 0);
            Date dateClose = cwEvent.getDateClose();
            Date dateOpen = cwEvent.getDateOpen();
            List<UserCard> cards = ucm.getList(cid);
            HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
            for (UserCard card : cards) {
                if (card.getDate2() == null || card.getDate2().after(cwEvent.getDateClose())) {
                    card.setDate2(cwEvent.getDateClose());
                    ucm.update((Id)card);
                }
                UserCard newCard = new UserCard();
                newCard.setId(0);
                newCard.setComment(card.getComment());
                newCard.setContractId(cwEvent.getToContractId());
                newCard.setDate1(cwEvent.getDateOpen());
                newCard.setNumber(card.getNumber());
                newCard.setSubscrDate(cwEvent.getDateOpen());
                ucm.update((Id)newCard);
                hashMap.put(card.getId(), newCard.getId());
            }
            List<CardPacket> cpackets = cpm.getCardPacketList(cid, dateClose);
            for (CardPacket cpack : cpackets) {
                if (cpack.getDateTo() == null || cpack.getDateTo().after(dateClose)) {
                    cpack.setDateTo(dateClose);
                    cpm.updateCardPacket(cpack);
                }
                CardPacket newCpack = new CardPacket();
                newCpack.setUsercardId(((Integer)hashMap.get(cpack.getUsercardId())).intValue());
                newCpack.setDateFrom(dateOpen);
                newCpack.setContractId(cwEvent.getToContractId());
                newCpack.setPacketId(cpack.getPacketId());
                newCpack.setStatus(cpack.getStatus());
                newCpack.setId(0);
                cpm.updateCardPacket(newCpack);
            }
            ucm.close();
        }
    }

    public void unlockService(Connection con, int mid, ContractRuntime contractRuntime, BigDecimal balance, BigDecimal limit, boolean lightweight) throws BGException {
        int contractId = contractRuntime.contractId;
        CardPacketManager cardPacketManager = new CardPacketManager(con, mid);
        StatusEventManager eventManager = new StatusEventManager(con, mid);
        UserCardManager cardManager = new UserCardManager(con, mid, 0);
        GregorianCalendar now = new GregorianCalendar();
        StatusEvent statusEvent = StatusEvent.builder().setTime((Calendar)now).setStatus(1).build();
        HashMap<Integer, UserCard> cardMap = new HashMap<Integer, UserCard>();
        List<CardPacket> lockedList = cardPacketManager.getStatusedCardPacketList(now, contractId, 2);
        for (CardPacket cardPacket : lockedList) {
            UserCard card;
            statusEvent.setCardPacketId(cardPacket.getId());
            statusEvent.setUserId(0);
            eventManager.addEvent(cardPacket, statusEvent);
            if (cardMap.containsKey(cardPacket.getUsercardId()) || (card = (UserCard)cardManager.get(cardPacket.getUsercardId())) == null) continue;
            cardMap.put(cardPacket.getUsercardId(), card);
        }
        Calendar nextDay = (Calendar)((Calendar)now).clone();
        nextDay.add(5, 1);
        for (CardPacket cardPacket : cardPacketManager.getCardPacketList(contractId, nextDay.getTime())) {
            for (StatusEvent e : eventManager.getEvents(cardPacket.getId(), nextDay)) {
                if (e.getStatus() != 2) continue;
                eventManager.deleteEvent(cardPacket.getId(), nextDay);
            }
        }
        for (UserCard userCard : cardMap.values()) {
            try {
                cardManager.updateSubscribe(now.getTime(), userCard, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        cardManager.close();
    }

    public void unlockServiceNow(Connection con, int mid, ContractRuntime contractRuntime, BigDecimal balance, BigDecimal limit, boolean lightweight) throws BGException {
        this.unlockService(con, mid, contractRuntime, balance, limit, lightweight);
    }

    public void lockService(Connection con, int mid, ContractRuntime contractRuntime, BigDecimal balance, BigDecimal limit, boolean lightweight) throws BGException {
        int contractId = contractRuntime.contractId;
        CardPacketManager cardPacketManager = new CardPacketManager(con, mid);
        StatusEventManager eventManager = new StatusEventManager(con, mid);
        UserCardManager cardManager = new UserCardManager(con, mid, 0);
        GregorianCalendar now = new GregorianCalendar();
        StatusEvent statusEvent = StatusEvent.builder().setTime((Calendar)now).setStatus(2).build();
        HashMap<Integer, UserCard> cardMap = new HashMap<Integer, UserCard>();
        List<CardPacket> unlockedList = cardPacketManager.getStatusedCardPacketList(now, contractId, 1);
        for (CardPacket cardPacket : unlockedList) {
            UserCard card;
            statusEvent.setCardPacketId(cardPacket.getId());
            statusEvent.setUserId(0);
            eventManager.addEvent(cardPacket, statusEvent);
            if (cardMap.containsKey(cardPacket.getUsercardId()) || (card = (UserCard)cardManager.get(cardPacket.getUsercardId())) == null) continue;
            cardMap.put(cardPacket.getUsercardId(), card);
        }
        Calendar nextDay = (Calendar)((Calendar)now).clone();
        nextDay.add(5, 1);
        for (CardPacket cardPacket : cardPacketManager.getCardPacketList(contractId, nextDay.getTime())) {
            for (StatusEvent e : eventManager.getEvents(cardPacket.getId(), nextDay)) {
                if (e.getStatus() != 1) continue;
                eventManager.deleteEvent(cardPacket.getId(), nextDay);
            }
        }
        for (UserCard userCard : cardMap.values()) {
            try {
                cardManager.updateSubscribe(now.getTime(), userCard, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        cardManager.close();
    }

    public void start(final Connection con, final BGModule module) throws BGException {
        super.start(con, module);
        try {
            String moduleId = String.valueOf(module.getId());
            Context jndiModuleContext = null;
            try {
                jndiModuleContext = (Context)Setup.getEnvironment().lookup(moduleId);
            }
            catch (NamingException e) {
                jndiModuleContext = Setup.getEnvironment().createSubcontext(moduleId);
            }
            jndiModuleContext.bind("digitalTVSA", (Object)new ResourceAdapter<DigitalTVServiceActivator>(){

                public DigitalTVServiceActivator borrow(ContainerContext ctx, int moduleId, Resource resource, Class<?> clazz, Class<?> resourceClazz, Class<?> fieldClass, Object bean) throws BGException {
                    return DigitalTVServiceActivator.newInstance((ParameterMap)ctx.getModuleSetup(), con, ctx.getModuleId(), Calendar.getInstance());
                }

                public void commit(DigitalTVServiceActivator r) {
                }

                public void recycle(DigitalTVServiceActivator r) {
                    r.close();
                }
            });
        }
        catch (NamingException e) {
            throw new BGException((Throwable)e);
        }
        EventProcessor.getInstance().addListener((EventListener)new EventListener<ContractTariffUpdateEvent>(){

            public void notify(ContractTariffUpdateEvent e, EventListenerContext ctx) throws Exception {
                TariffRequestManager tariffRequestManager;
                Set<Integer> autosyncPackets;
                int mid = module.getId();
                Connection con = ctx.getConnection();
                ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(mid));
                int cid = e.getContractTariff().getContractId();
                Date dateFrom = e.getContractTariff().getPeriod().getDateFrom();
                int userId = e.getUserId();
                Date now = new Date();
                if (dateFrom == null || TimeUtils.dateBefore((Date)dateFrom, (Date)now)) {
                    dateFrom = now;
                }
                if ((autosyncPackets = (tariffRequestManager = new TariffRequestManager(con, mid)).getPacketsAutosync((ParameterMap)moduleSetup, cid, dateFrom, TariffRequestManager.AutosyncOnMode.ONTARIFFCHANGE)) != null) {
                    CardPacketManager cmp = new CardPacketManager(con, mid, userId);
                    cmp.replaceCardPackets(cid, dateFrom, autosyncPackets, "[\u043e\u0442\u043a\u0440\u044b\u0442 \u043f\u0440\u0438 \u0441\u043c\u0435\u043d\u0435 \u0442\u0430\u0440\u0438\u0444\u0430]", " [\u0437\u0430\u043a\u0440\u044b\u0442 \u043f\u0440\u0438 \u0441\u043c\u0435\u043d\u0435 \u0442\u0430\u0440\u0438\u0444\u0430]");
                    try (UserCardManager cardManager = new UserCardManager(con, mid, userId);){
                        List<UserCard> uclist = cardManager.getList(cid, dateFrom);
                        if (!uclist.isEmpty()) {
                            SubscriptionChangedEvent event = new SubscriptionChangedEvent(mid, cid, uclist.stream().map(uc -> uc.getId()).collect(Collectors.toSet()), -3, 4, new HashSet<Integer>(autosyncPackets), dateFrom);
                            ctx.publishAfterCommit((Event)event);
                            for (UserCard uc2 : uclist) {
                                cardManager.updateSubscribe(dateFrom, uc2.getId(), true);
                            }
                        }
                    }
                }
            }
        }, ContractTariffUpdateEvent.class);
    }

    public List<ModuleEntity> getObjectEntities(Connection con, int mid, int objectId) throws BGException {
        ArrayList<ModuleEntity> entries = new ArrayList<ModuleEntity>();
        try (UserCardManager userCardManager = new UserCardManager(con, mid, objectId);){
            List<UserCard> cardList = userCardManager.getListByObject(objectId);
            for (UserCard card : cardList) {
                ModuleEntity entity = new ModuleEntity();
                entity.setComment(card.getComment());
                entity.setName(card.getGuiTitle());
                entity.setPeriod(TimeUtils.formatPeriod((Date)card.getDate1(), (Date)card.getDate2()));
                entries.add(entity);
            }
        }
        catch (BGException ex) {
            ex.printStackTrace();
        }
        return entries;
    }

    public List<MenuItem> getContractWebMenuItems(Connection con, String module, int moduleId, int contractId) throws Exception {
        HashSet<Integer> disableIds = new HashSet<Integer>();
        int sid = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId)).getInt("cerbercrypt.virtual_cinema.serviceId", 0);
        Set services = new ContractServiceManager(con).getContractServiceSet(contractId, new Date());
        if (sid == 0 || services.contains(sid)) {
            disableIds.add(2);
        }
        return this.disableContractWebMenuItems(this.getWebMenuItems(con, module, moduleId), disableIds);
    }
}

