/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTask;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.UserCard;
import ru.bitel.bgbilling.modules.cerbercrypt.server.task.Synchronizer;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;

public class SubscribeSynchronizer
extends RunTask {
    private int mid;
    private Collection<UserCard> usercards;

    public SubscribeSynchronizer(int mid, final UserCard usercard) {
        this.mid = mid;
        this.usercards = new ArrayList<UserCard>(){
            {
                this.add(usercard);
            }
        };
    }

    public SubscribeSynchronizer(int mid, Collection<UserCard> usercards) {
        this.mid = mid;
        this.usercards = usercards;
    }

    public String getDescription() {
        Synchronizer synch = new Synchronizer();
        synch.initTask(Setup.getSetup(), 0, "mid=" + this.mid);
        synch.setExecutingTime(new GregorianCalendar());
        synch.setUserCards(this.usercards);
        return synch.getDescription();
    }

    public void executeTask() {
        Synchronizer synch = new Synchronizer();
        synch.initTask(this.setup, 0, "mid=" + this.mid);
        synch.setExecutingTime(new GregorianCalendar());
        synch.setUserCards(this.usercards);
        synch.startTask();
    }

    public String getUniqueKeyQueue() {
        List oneusercardsnumber = this.usercards.stream().map(uc -> uc.getNumber()).collect(Collectors.toList());
        return "cerbercrypt-" + this.mid + "-synchronizer-" + Utils.toString(oneusercardsnumber);
    }

    public String getUniqueKeyParallel() {
        return "cerbercrypt-" + this.mid + "-synchronizer";
    }
}

