/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting.ip;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import ru.bitel.bgbilling.apps.inet.accounting.Accounting;
import ru.bitel.bgbilling.apps.inet.accounting.FlowAgentInterface;
import ru.bitel.bgbilling.apps.inet.accounting.InetConnectionAutoRuntime;
import ru.bitel.bgbilling.apps.inet.accounting.InetConnectionRuntime;
import ru.bitel.bgbilling.apps.inet.accounting.IpRangeRuntime;
import ru.bitel.bgbilling.apps.inet.accounting.ip.ConnectionRangeSet;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.server.InetUtils;
import ru.bitel.common.RangeUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.util.Matcher;
import ru.bitel.common.util.Ranger;

public class HourlyAutoConnectionSet {
    private final Accounting accounting;
    private final FlowAgentInterface iface;
    private final ReentrantLock lock = new ReentrantLock();
    private final ConcurrentHashMap<Long, Hour> hourlyMap = new ConcurrentHashMap();
    private long currentHour = -1L;
    private Hour current = null;
    private final Ranger<InetConnectionAutoRuntime, Date> periodRanger = new Ranger<InetConnectionAutoRuntime, Date>(this){

        public Date getMinValue(InetConnectionAutoRuntime r) {
            return r.inetServRuntime.getInetServ().getDateFrom();
        }

        public Date getMaxValue(InetConnectionAutoRuntime r) {
            return r.inetServRuntime.getInetServ().getDateTo();
        }
    };

    public HourlyAutoConnectionSet(Accounting accounting, FlowAgentInterface iface) throws BGException {
        this.accounting = accounting;
        this.iface = iface;
    }

    public void add(InetConnectionAutoRuntime connectionRuntime) {
        InetServ inetServ = connectionRuntime.inetServRuntime.getInetServ();
        for (Map.Entry<Long, Hour> entry : this.hourlyMap.entrySet()) {
            Date date = new Date(entry.getKey());
            if (!TimeUtils.dateInRange((Date)date, (Date)inetServ.getDateFrom(), (Date)inetServ.getDateTo())) continue;
            entry.getValue().add(connectionRuntime);
        }
    }

    public void remove(InetConnectionAutoRuntime connectionRuntime, InetServ inetServ) {
        for (Map.Entry<Long, Hour> entry : this.hourlyMap.entrySet()) {
            Date date = new Date(entry.getKey());
            if (!TimeUtils.dateInRange((Date)date, (Date)inetServ.getDateFrom(), (Date)inetServ.getDateTo())) continue;
            entry.getValue().remove(connectionRuntime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Hour getHour(Long hour) {
        assert (hour == hour / 3600000L * 3600000L);
        if (hour == this.currentHour) {
            return this.current;
        }
        Hour hourInstance = this.hourlyMap.get(hour);
        if (hourInstance != null) {
            this.currentHour = hour;
            this.current = hourInstance;
            return this.current;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(hour);
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)calendar);
        this.lock.lock();
        try {
            hourInstance = this.hourlyMap.get(calendar.getTimeInMillis());
            if (hourInstance != null) {
                this.hourlyMap.put(hour, hourInstance);
                this.currentHour = hour;
                Hour hour2 = this.current = hourInstance;
                return hour2;
            }
            this.clean(hour);
            Date date = TimeUtils.convertCalendarToDate((Calendar)calendar);
            ArrayList<InetConnectionAutoRuntime> sessions = new ArrayList<InetConnectionAutoRuntime>(50);
            for (final Integer deviceId : this.iface.deviceIds) {
                ConcurrentMap<Integer, InetConnectionAutoRuntime> sessionMap = this.accounting.connectionMapAuto.getDeviceMap(deviceId);
                if (sessionMap == null) continue;
                if (this.iface.agentDeviceId == deviceId && this.iface.iface != -1) {
                    Matcher<InetConnectionAutoRuntime> matcher = new Matcher<InetConnectionAutoRuntime>(){

                        public boolean matched(InetConnectionAutoRuntime x) {
                            return Accounting.isWorkingAutoIface(HourlyAutoConnectionSet.this.accounting, HourlyAutoConnectionSet.this.iface, deviceId, x);
                        }
                    };
                    sessions.addAll(RangeUtils.subListContains(sessionMap.values(), (Matcher)matcher, this.periodRanger, (Comparable)date, (Comparable)date));
                    continue;
                }
                sessions.addAll(RangeUtils.subListContains(sessionMap.values(), this.periodRanger, (Comparable)date, (Comparable)date));
            }
            Hour newHourInstance = new Hour(sessions);
            hourInstance = this.hourlyMap.put(hour, newHourInstance);
            if (hourInstance == null) {
                hourInstance = newHourInstance;
            }
            this.currentHour = hour;
            this.current = hourInstance;
        }
        finally {
            this.lock.unlock();
        }
        this.currentHour = hour;
        this.current = hourInstance;
        return this.current;
    }

    public InetConnectionRuntime getSession(IpAddress address, Long hour) {
        Hour hourInstance = this.getHour(hour);
        InetConnectionRuntime result = (InetConnectionRuntime)((Object)hourInstance.addressSet.get(address));
        if (result != null) {
            return result;
        }
        result = hourInstance.rangeSet.get(address);
        if (result != null) {
            return result;
        }
        return hourInstance.fullInterface.get();
    }

    private void clean(Long hour) {
        assert (this.lock.isHeldByCurrentThread());
        long millis = System.currentTimeMillis();
        if (millis < hour) {
            hour = InetUtils.getHour(millis);
        }
        hour = hour - 259200000L;
        Iterator<Map.Entry<Long, Hour>> iter = this.hourlyMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Long, Hour> entry = iter.next();
            if (entry.getKey() >= hour) continue;
            iter.remove();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + System.identityHashCode(this);
    }

    final class Hour {
        final ConcurrentMap<IpAddress, InetConnectionAutoRuntime> addressSet;
        final ConnectionRangeSet rangeSet;
        final AtomicReference<InetConnectionAutoRuntime> fullInterface = new AtomicReference();

        Hour(List<InetConnectionAutoRuntime> list) {
            this.addressSet = new ConcurrentHashMap<IpAddress, InetConnectionAutoRuntime>(512);
            ArrayList<IpRangeRuntime> rangeList = new ArrayList<IpRangeRuntime>(Math.max(50, list.size() / 2));
            for (InetConnectionAutoRuntime connectionRuntime : list) {
                for (IpRangeRuntime range : connectionRuntime.rangeSets) {
                    if (range.isSingleAddress()) {
                        if (range.getSingleAddress().address == null) continue;
                        this.addressSet.put(range.getSingleAddress(), connectionRuntime);
                        continue;
                    }
                    rangeList.add(range);
                }
                if (!connectionRuntime.inetServRuntime.isAddressAllInterface(HourlyAutoConnectionSet.this.accounting)) continue;
                this.fullInterface.set(connectionRuntime);
            }
            this.rangeSet = ConnectionRangeSet.newInstanceFromRanges(rangeList);
        }

        public void add(InetConnectionAutoRuntime connectionRuntime) {
            for (IpRangeRuntime range : connectionRuntime.rangeSets) {
                if (range.isSingleAddress()) {
                    if (range.getSingleAddress().address == null) continue;
                    this.addressSet.put(range.getSingleAddress(), connectionRuntime);
                    continue;
                }
                this.rangeSet.add((Object)range);
            }
            if (connectionRuntime.inetServRuntime.isAddressAllInterface(HourlyAutoConnectionSet.this.accounting)) {
                this.fullInterface.set(connectionRuntime);
            }
        }

        public void remove(InetConnectionAutoRuntime connectionRuntime) {
            for (IpRangeRuntime range : connectionRuntime.rangeSets) {
                if (range.isSingleAddress()) {
                    if (range.getSingleAddress().address == null) continue;
                    this.addressSet.remove(range.getSingleAddress(), (Object)connectionRuntime);
                    continue;
                }
                this.rangeSet.remove((Object)range);
            }
            if (connectionRuntime.inetServRuntime.isAddressAllInterface(HourlyAutoConnectionSet.this.accounting)) {
                this.fullInterface.set(null);
            }
        }
    }
}

