/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import ru.bitel.bgbilling.client.util.ClientUtils;

public class BGTextField
extends JTextField {
    private boolean emptyTextFlag = false;
    private boolean emptyTextFlagSet = false;
    private String placeHolderText = "";
    private FocusAdapter focusAdapter = null;
    private CaretListener caretListener = null;
    private Font baseFont = this.getFont();
    private Color baseColor = this.getForeground();
    private boolean doNotShowHelpText;

    public BGTextField() {
        this(0);
    }

    public BGTextField(int columns) {
        super(columns);
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension size = super.getMinimumSize();
        int columns = this.getColumns();
        if (columns != 0) {
            Insets insets = this.getInsets();
            size.width = columns * this.getColumnWidth() + insets.left + insets.right;
        }
        return size;
    }

    @Override
    public String getText() {
        String text = "";
        if (!this.emptyTextFlag && !BGTextField.super.getText().equals(this.placeHolderText)) {
            text = super.getText();
        }
        return text;
    }

    public void setPromptText(String helpText) {
        this.setPromptText(helpText, true, true);
    }

    public void setPromptText(String helpText, boolean clearText, boolean emptyTextFlag) {
        this.placeHolderText = helpText;
        this.emptyTextFlagSet = this.emptyTextFlag = emptyTextFlag;
        if (super.getText().isEmpty()) {
            this.setFont(this.getFont().deriveFont(2));
            this.setForeground(Color.GRAY);
            this.setText(helpText);
        }
        if (this.focusAdapter == null) {
            this.addFocusListener(this.getFocusAdapter());
        }
        if (this.caretListener == null) {
            this.addCaretListener(this.getCaretListener());
        }
    }

    private CaretListener getCaretListener() {
        if (this.caretListener == null) {
            this.caretListener = new CaretListener(){

                @Override
                public void caretUpdate(CaretEvent e) {
                    if (!BGTextField.this.isEnabled() || !BGTextField.this.isEditable()) {
                        return;
                    }
                    if (!BGTextField.super.getText().equals("") && !BGTextField.super.getText().equals(BGTextField.this.placeHolderText)) {
                        BGTextField.this.setFont(BGTextField.this.baseFont);
                        BGTextField.this.setForeground(BGTextField.this.baseColor);
                        BGTextField.this.emptyTextFlag = false;
                        BGTextField.this.doNotShowHelpText = true;
                    } else {
                        BGTextField.this.doNotShowHelpText = false;
                        BGTextField.this.emptyTextFlag = BGTextField.this.emptyTextFlagSet;
                    }
                    BGTextField.this.firePropertyChange("textChange", null, BGTextField.this.getText());
                }
            };
        }
        return this.caretListener;
    }

    private FocusAdapter getFocusAdapter() {
        if (this.focusAdapter == null) {
            this.focusAdapter = new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    if (BGTextField.this.doNotShowHelpText || !BGTextField.this.isEnabled() || !BGTextField.this.isEditable()) {
                        return;
                    }
                    if (BGTextField.this.emptyTextFlag && BGTextField.super.getText().equals(BGTextField.this.placeHolderText)) {
                        try {
                            BGTextField.this.getDocument().remove(0, BGTextField.this.getDocument().getLength());
                        }
                        catch (BadLocationException ex) {
                            ClientUtils.showErrorMessageDialog(ex);
                        }
                    } else {
                        boolean old = BGTextField.this.emptyTextFlag;
                        BGTextField.this.emptyTextFlag = false;
                        BGTextField.this.setSelectionStart(0);
                        BGTextField.this.setSelectionEnd(BGTextField.this.getText().length());
                        BGTextField.this.emptyTextFlag = old;
                    }
                    BGTextField.this.setFont(BGTextField.this.baseFont);
                    BGTextField.this.setForeground(BGTextField.this.baseColor);
                }

                @Override
                public void focusLost(FocusEvent e) {
                    if (BGTextField.this.doNotShowHelpText || !BGTextField.this.isEnabled() || !BGTextField.this.isEditable()) {
                        return;
                    }
                    BGTextField.this.emptyTextFlag = BGTextField.this.emptyTextFlag;
                    BGTextField.this.setFont(BGTextField.this.getFont().deriveFont(2));
                    BGTextField.this.setForeground(Color.GRAY);
                    try {
                        BGTextField.this.getDocument().remove(0, BGTextField.this.getDocument().getLength());
                        BGTextField.this.getDocument().insertString(0, BGTextField.this.placeHolderText, null);
                    }
                    catch (BadLocationException ex) {
                        ClientUtils.showErrorMessageDialog(ex);
                    }
                }
            };
        }
        return this.focusAdapter;
    }

    public boolean isNotPromtText() {
        return this.getFont() == this.baseFont && this.getForeground() == this.baseColor;
    }
}

