/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.client.constructor;

import bitel.billing.module.common.BGDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.reports.client.constructor.FilterPanel;
import ru.bitel.bgbilling.modules.reports.client.constructor.ParameterField;
import ru.bitel.bgbilling.modules.reports.client.constructor.ReportConstructorPanel;
import ru.bitel.bgbilling.modules.reports.client.constructor.ReportFilterListPanel;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGButtonPanel;
import ru.bitel.common.client.BGButtonPanelOkCancel;

public class FilterDialog
extends BGDialog {
    private static final GridBagConstraints CONSTRAINTS = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 1, new Insets(3, 3, 3, 3), 0, 0);
    private final BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();

    protected FilterDialog(ReportConstructorPanel reportConstructorPanel, FilterPanel filterPanel, ReportFilterListPanel reportFilterListPanel) {
        this.setTitle("\u0424\u0438\u043b\u044c\u0442\u0440: " + filterPanel.getReportFilter().getGuiTitle());
        this.initOkCancelButtons(reportConstructorPanel, filterPanel, reportFilterListPanel);
        this.setLayout(new GridBagLayout());
        this.add(filterPanel, CONSTRAINTS);
        this.add((Component)this.okCancel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 16, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.pack();
        this.moveWindowToCenterScreen();
        this.show();
    }

    private void initOkCancelButtons(ReportConstructorPanel reportConstructorPanel, FilterPanel filterPanel, ReportFilterListPanel reportFilterListPanel) {
        this.okCancel.getButtonOk().addActionListener(e -> {
            try {
                boolean error = false;
                for (ParameterField parameterField : filterPanel.getParameterFields()) {
                    String parameterValue = parameterField.getText();
                    if (Utils.isBlankString((String)parameterValue)) {
                        error = true;
                        ClientUtils.showErrorMessageDialog((String)"\u041d\u0430\u0437\u043d\u0430\u0447\u044c\u0442\u0435 \u0438\u043c\u0435\u043d\u0430 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u0434\u043b\u044f \u0444\u0438\u043b\u044c\u0442\u0440\u0430 \u043e\u0442\u0447\u0435\u0442\u0430!");
                        break;
                    }
                    if (!this.isValidParameterName(parameterField, filterPanel, reportFilterListPanel)) {
                        error = true;
                        ClientUtils.showErrorMessageDialog((String)"\u0418\u043c\u0435\u043d\u0430 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u0434\u043b\u044f \u0444\u0438\u043b\u044c\u0442\u0440\u0430 \u0434\u043e\u043b\u0436\u043d\u044b \u0431\u044b\u0442\u044c \u0443\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u0432\u0441\u0435\u0433\u043e \u043e\u0442\u0447\u0435\u0442\u0430");
                        break;
                    }
                    parameterField.getField().set(filterPanel.getReportFilter(), parameterValue);
                }
                if (filterPanel.getModuleIdField() != null) {
                    int moduleId = Utils.parseInt((String)filterPanel.getModuleIdField().getText(), (int)-1);
                    if (moduleId <= 0) {
                        ClientUtils.showErrorMessageDialog((String)"\u0414\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u0444\u0438\u043b\u044c\u0442\u0440\u0430 \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 ID \u043c\u043e\u0434\u0443\u043b\u044f(\u043f\u043b\u0430\u0433\u0438\u043d\u0430)");
                        return;
                    }
                    filterPanel.getModuleIdField().getField().set(filterPanel.getReportFilter(), moduleId);
                }
                if (filterPanel.getSqlRequestField() != null) {
                    filterPanel.getSqlRequestField().getField().set(filterPanel.getReportFilter(), filterPanel.getSqlRequestField().getText());
                }
                if (!error) {
                    reportFilterListPanel.getSelectedFilters().add(filterPanel);
                    reportConstructorPanel.generateReport(false);
                    this.setVisible(false);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        });
        this.okCancel.getButton(BGButtonPanel.CANCEL).addActionListener(e -> this.setVisible(false));
    }

    private boolean isValidParameterName(ParameterField newField, FilterPanel newFilterPanel, ReportFilterListPanel reportFilterListPanel) {
        boolean isValid = true;
        ArrayList<FilterPanel> l = new ArrayList<FilterPanel>(reportFilterListPanel.getSelectedFilters());
        l.add(newFilterPanel);
        block0: for (FilterPanel filterPanel : l) {
            for (ParameterField field : filterPanel.getParameterFields()) {
                if (!field.getText().equals(newField.getText()) || field == newField) continue;
                isValid = false;
                continue block0;
            }
        }
        return isValid;
    }
}

