/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.directory.address;

import bitel.billing.module.common.BGTextArea;
import bitel.billing.module.common.IntTextField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.CalendarPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.directory.address.AddressParamTableModel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.function.Async;
import ru.bitel.common.model.IdTitle;
import ru.bitel.oss.kernel.directories.address.common.bean.AddressEntityData;
import ru.bitel.oss.kernel.directories.address.common.bean.AddressEntityParam;
import ru.bitel.oss.kernel.directories.address.common.bean.AddressEntityType;
import ru.bitel.oss.kernel.directories.address.common.bean.HouseCoordinates;
import ru.bitel.oss.kernel.directories.address.common.bean.Street;
import ru.bitel.oss.kernel.directories.address.common.service.AddressService;

public class AddressHouseEditor
extends BGEditorDialog<AddressEntityData> {
    private AddressService addressService;
    private Street street;
    private BGTextField parentTitle = new BGTextField(50);
    private BGUComboBox<IdTitle> area = new BGUComboBox();
    private BGUComboBox<IdTitle> quarter = new BGUComboBox();
    private IntTextField postIndex = new IntTextField(8);
    private IntTextField amount = new IntTextField(8);
    private JTextField entityTitle = new JTextField(10);
    private BGTextArea comment = new BGTextArea(2, 70);
    private final CoordinatesPanel coordinatesPanel = new CoordinatesPanel();
    private AddressParamTableModel paramTableModel = new AddressParamTableModel();
    private BGUTable paramTable = new BGUTable(this.paramTableModel);

    public AddressHouseEditor(String title, AddressEntityData data, ClientContext clientContext) {
        super(title, data, clientContext);
    }

    private AddressService getAddressService() {
        if (this.addressService == null) {
            this.addressService = this.clientContext.getPort(AddressService.class, 0);
        }
        return this.addressService;
    }

    @Override
    public void doDialogPanel() {
        this.panel.add((Component)this.getTitlePanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.panel.add((Component)this.getHouseDataPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.panel.add((Component)this.getParamPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        try {
            AddressService addressService = this.getAddressService();
            Async<List> areaItemsAsync = Async.of(() -> addressService.addressEntityItems(AddressEntityType.AREA, this.street.getCityId()));
            Async<List> quarterItemsAsync = Async.of(() -> addressService.addressEntityItems(AddressEntityType.QUARTER, this.street.getCityId()));
            this.data = addressService.addressEntityDataGet(((AddressEntityData)this.data).getAddressEntityType(), ((AddressEntityData)this.data).getRecordId());
            this.entityTitle.setText(((AddressEntityData)this.data).getTitle());
            this.postIndex.setText(((AddressEntityData)this.data).getEntityParameter("postIndex"));
            this.amount.setText(((AddressEntityData)this.data).getEntityParameter("amount"));
            this.comment.setText(((AddressEntityData)this.data).getEntityParameter("comment"));
            this.coordinatesPanel.setCoordinates((AddressEntityData)this.data);
            int areaId = Utils.parseInt(((AddressEntityData)this.data).getEntityParameter("areaId"));
            List areaItems = areaItemsAsync.get();
            areaItems.add(0, IdTitle.NO_SELECT);
            this.area.setData(areaItems);
            this.area.setSelectedItem(areaItems.stream().filter(a -> a.getId() == areaId).findFirst().orElse((IdTitle)areaItems.get(0)));
            int quarterId = Utils.parseInt(((AddressEntityData)this.data).getEntityParameter("quarterId"));
            List quarterItems = quarterItemsAsync.get();
            quarterItems.add(0, IdTitle.NO_SELECT);
            this.quarter.setData(quarterItems);
            this.quarter.setSelectedItem(quarterItems.stream().filter(a -> a.getId() == quarterId).findFirst().orElse((IdTitle)quarterItems.get(0)));
            this.paramTableModel.setData(((AddressEntityData)this.data).getConfigParams());
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    @Override
    public boolean doApply() throws Exception {
        if (this.entityTitle.getText().trim().length() == 0) {
            ClientUtils.showErrorMessageDialog("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435");
            return false;
        }
        try {
            ((AddressEntityData)this.data).getEntityParams().clear();
            ((AddressEntityData)this.data).setParentId(this.street.getId());
            ((AddressEntityData)this.data).setTitle(this.entityTitle.getText());
            ((AddressEntityData)this.data).addEntityParameter("postIndex", this.postIndex.getText());
            ((AddressEntityData)this.data).addEntityParameter("areaId", String.valueOf(((IdTitle)this.area.getSelectedItem()).getId()));
            ((AddressEntityData)this.data).addEntityParameter("quarterId", String.valueOf(((IdTitle)this.quarter.getSelectedItem()).getId()));
            ((AddressEntityData)this.data).addEntityParameter("amount", this.amount.getText());
            ((AddressEntityData)this.data).addEntityParameter("comment", this.comment.getText());
            ((AddressEntityData)this.data).addEntityParameter("latitude", this.coordinatesPanel.getLatitude());
            ((AddressEntityData)this.data).addEntityParameter("longitude", this.coordinatesPanel.getLongitude());
            ((AddressEntityData)this.data).setConfigParams(this.paramTableModel.getRows());
            this.getAddressService().addressEntityDataUpdate((AddressEntityData)this.data);
            return true;
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
            return false;
        }
    }

    public void setTitleLabelText(String text) {
        this.parentTitle.setText(text);
    }

    public void setStreet(Street street) {
        this.street = street;
    }

    private JPanel getTitlePanel() {
        Color bgColor = this.parentTitle.getBackground();
        Font font = this.parentTitle.getFont();
        this.parentTitle.setEditable(false);
        this.parentTitle.setBackground(bgColor);
        this.parentTitle.setFont(font.deriveFont(font.getSize2D() * 1.3f).deriveFont(1));
        this.parentTitle.setHorizontalAlignment(0);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.parentTitle, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getHouseDataPanel() {
        this.postIndex.setMaxValue(999999L);
        this.entityTitle.setHorizontalAlignment(0);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0414\u043e\u043c/\u0434\u0440\u043e\u0431\u044c:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u0418\u043d\u0434\u0435\u043a\u0441:"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u041a\u0432\u0430\u0440\u0442\u0438\u0440:"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u0420\u0430\u0439\u043e\u043d:"), new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u041a\u0432\u0430\u0440\u0442\u0430\u043b:"), new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        panel.add((Component)this.entityTitle, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.postIndex, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)this.amount, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 10, 0, 0), 0, 0));
        panel.add(this.area, new GridBagConstraints(3, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 10, 0, 0), 0, 0));
        panel.add(this.quarter, new GridBagConstraints(4, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)new JScrollPane(this.comment), new GridBagConstraints(0, 3, 5, 1, 0.0, 0.0, 10, 1, new Insets(2, 0, 0, 0), 0, 0));
        panel.add((Component)this.coordinatesPanel, new GridBagConstraints(0, 4, 5, 1, 0.0, 0.0, 10, 1, new Insets(2, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getParamPanel() {
        this.paramTable.setRowHeight(18);
        this.paramTable.setFont(new Font("Dialog", 0, 13));
        this.paramTable.setSelectionMode(0);
        BGSwingUtilites.handleMouseClicked(this.paramTable, e -> this.paramTableMouseClicked((MouseEvent)e));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)BGSwingUtilites.wrapScrollPane(this.paramTable, 800, 200), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 0, 0, 0), 0, 0));
        return panel;
    }

    private void paramTableMouseClicked(MouseEvent event) {
        AddressEntityParam entityParam = (AddressEntityParam)this.paramTableModel.getSelectedRow();
        int col = this.paramTable.convertColumnIndexToModel(this.paramTable.columnAtPoint(event.getPoint()));
        if (entityParam != null && "date".equals(entityParam.getType()) && col == 3 && event.getClickCount() == 2) {
            JPopupMenu popupMenu = new JPopupMenu();
            CalendarPanel calendarPanel = new CalendarPanel();
            calendarPanel.setCalendar(TimeUtils.parseCalendar(entityParam.getValue(), "dd.MM.yyyy"));
            calendarPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            calendarPanel.addPropertyChangeListener(ce -> {
                if ("updateCalendar".equals(ce.getPropertyName())) {
                    entityParam.setValue(TimeUtils.format(calendarPanel.getCalendar(), "dd.MM.yyyy"));
                    popupMenu.setVisible(false);
                }
            });
            popupMenu.add(calendarPanel);
            popupMenu.show(event.getComponent(), event.getX(), event.getY());
        } else if (entityParam != null && "boolean".equals(entityParam.getType()) && col == 3 && event.getClickCount() == 2) {
            entityParam.setValue(String.valueOf(Boolean.valueOf(entityParam.getValue()) == false));
            this.paramTableModel.fireTableCellUpdated(this.paramTable.convertRowIndexToModel(this.paramTable.rowAtPoint(event.getPoint())), col);
        }
    }

    private final class CoordinatesPanel
    extends JPanel {
        private final JTextField latitude = new JTextField();
        private final JTextField longitude = new JTextField();

        private CoordinatesPanel() {
            this.setLayout(new GridBagLayout());
            this.add((Component)this.latitude, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
            this.add((Component)new JLabel("/"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
            this.add((Component)this.longitude, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
            JButton searchCoordinates = new JButton("\u041d\u0430\u0439\u0442\u0438 \u043a\u043e\u043e\u0440\u0434\u0438\u043d\u0430\u0442\u044b");
            this.add((Component)searchCoordinates, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
            BGSwingUtilites.wrapBorder(this, "\u041a\u043e\u043e\u0440\u0434\u0438\u043d\u0430\u0442\u044b");
            try {
                searchCoordinates.setEnabled(AddressHouseEditor.this.getAddressService().checkGarPluginInstalled());
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
            searchCoordinates.addActionListener(e -> {
                try {
                    HouseCoordinates coordinates = AddressHouseEditor.this.getAddressService().searchCoordinatesByHouseId(((AddressEntityData)AddressHouseEditor.this.data).getRecordId());
                    if (coordinates != null) {
                        this.latitude.setText(String.valueOf(coordinates.getLatitude()));
                        this.longitude.setText(String.valueOf(coordinates.getLongitude()));
                    }
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog(ex);
                }
            });
        }

        void setCoordinates(AddressEntityData addressEntityData) {
            this.latitude.setText(Utils.maskNull(addressEntityData.getEntityParameter("latitude")));
            this.longitude.setText(Utils.maskNull(addressEntityData.getEntityParameter("longitude")));
        }

        String getLatitude() {
            return Utils.maskNull(this.latitude.getText());
        }

        String getLongitude() {
            return Utils.maskNull(this.longitude.getText());
        }
    }
}

