/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.resource.client.device.type;

import bitel.billing.module.common.BGTextArea;
import bitel.billing.module.common.BSHEditor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.model.ConfigParameter;
import ru.bitel.bgbilling.kernel.dynamic.client.DynamicClassChooser;
import ru.bitel.bgbilling.kernel.dynamic.common.bean.DynamicClass;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGConfigEditor;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.function.Async;
import ru.bitel.oss.kernel.entity.common.bean.EntitySpec;
import ru.bitel.oss.kernel.entity.common.service.EntityService;
import ru.bitel.oss.systems.inventory.resource.common.bean.Device;
import ru.bitel.oss.systems.inventory.resource.common.bean.DeviceType;
import ru.bitel.oss.systems.inventory.resource.common.service.DeviceService;

public abstract class DeviceTypePanel<D extends Device<D, T>, T extends DeviceType>
extends BGUPanel {
    protected TableModel model = new TableModel(TableModel.class.getName(), this.getDeviceTypeClass());
    protected BGEditor editor;
    protected AtomicReference<T> currentRef = new AtomicReference();

    protected abstract Map<String, String> getParams();

    public DeviceTypePanel(ClientContext ctx) {
        super((LayoutManager)new BorderLayout(), ctx);
    }

    @Override
    protected abstract void jbInit();

    protected abstract Class<T> getDeviceTypeClass();

    @Override
    protected void shownNotify() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent(this);
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh(e -> Async.of(() -> this.model.setData(this.getWs().deviceTypeList())));
    }

    protected abstract DeviceService<D, T> getWs();

    protected abstract T newDeviceType();

    class TableModel
    extends BGTableModel<T> {
        public TableModel(String name, Class<T> clazz) {
            super(name, clazz);
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, -1, -1, "title", true, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, -1, -1, "comment", true, HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    class HandlerParameterEditor
    extends BGEditorDialog<ConfigParameter> {
        private JTextField paramValue = new JTextField(50);

        public HandlerParameterEditor(DeviceTypePanel this$0, String title, ConfigParameter data) {
            super(title, data);
        }

        @Override
        public void doDialogPanel() {
            JTextField field = new JTextField();
            Font font = field.getFont();
            font = font.deriveFont(font.getSize2D() * 1.2f);
            Color bgColor = field.getBackground();
            JTextField handlerName = new JTextField(50);
            handlerName.setFont(font);
            handlerName.setEditable(false);
            handlerName.setBackground(bgColor);
            handlerName.setHorizontalAlignment(0);
            JTextField paramKey = new JTextField(50);
            paramKey.setFont(font);
            paramKey.setEditable(false);
            paramKey.setBackground(bgColor);
            paramKey.setHorizontalAlignment(0);
            this.paramValue.setFont(font);
            this.paramValue.setHorizontalAlignment(0);
            BGTextArea paramText = new BGTextArea(5, 50);
            paramText.setEditable(false);
            this.panel.add((Component)new JLabel("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((Component)handlerName, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440(\u043a\u043b\u044e\u0447):"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((Component)paramKey, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.paramValue, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((Component)new JScrollPane(paramText), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 0, 0), 0, 0));
            handlerName.setText(((ConfigParameter)this.data).getHandlerName());
            paramKey.setText(((ConfigParameter)this.data).getKey());
            this.paramValue.setText(Utils.isEmptyString(((ConfigParameter)this.data).getValue()) ? ((ConfigParameter)this.data).getDefaultValue() : ((ConfigParameter)this.data).getValue());
            paramText.setText(((ConfigParameter)this.data).getText());
        }

        @Override
        public boolean doApply() throws Exception {
            ((ConfigParameter)this.data).setValue(this.paramValue.getText().equals(((ConfigParameter)this.data).getDefaultValue()) ? null : this.paramValue.getText());
            return true;
        }
    }

    class ConfigParamTableModel
    extends BGTableModel<ConfigParameter> {
        private BGConfigEditor config;
        private Map<String, List<ConfigParameter>> configParameterMap;

        public ConfigParamTableModel() {
            super(ConfigParamTableModel.class.getName());
            this.configParameterMap = new HashMap<String, List<ConfigParameter>>();
        }

        public void setData(DynamicClass className, String ifaceName, List<ConfigParameter> configParameterList) {
            this.configParameterMap.put(ifaceName, configParameterList);
            ArrayList data = new ArrayList();
            this.configParameterMap.values().forEach(a -> data.addAll(a));
            String[] configValues = this.config.getText().split("\n");
            data.forEach(a -> {
                for (String configValue : configValues) {
                    if (!configValue.startsWith(a.getKey() + "=")) continue;
                    a.setValue(configValue.substring((a.getKey() + "=").length()));
                    break;
                }
            });
            this.setData(data);
        }

        public void setConfig(BGConfigEditor config) {
            this.config = config;
            this.configParameterMap.clear();
        }

        @Override
        protected void initColumns() {
            this.addColumn("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a", 200, 300, 400, "handlerName", true, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440", 200, 300, 400, "key", true, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", 200, 200, -1, "value", true, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e", 200, 200, 200, "defaultValue", true, HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    protected abstract class DeviceTypeFormScript
    extends BGUPanel {
        protected abstract BSHEditor getScriptEditor();

        protected abstract String getScript();

        protected abstract void setScript(String var1);

        public DeviceTypeFormScript() {
            super(new BorderLayout());
        }

        @Override
        protected void jbInit() {
            BGSwingUtilites.wrapEmptyBorder(this);
            this.add((Component)this.getScriptEditor(), "Center");
        }

        @Override
        protected void initActions() {
            new AbstractBGUPanel.BGActionNew(e -> this.getScriptEditor().setText(""));
            new AbstractBGUPanel.BGActionEdit(e -> this.getScriptEditor().setText(this.getScript()));
            new AbstractBGUPanel.DefaultAction("ok", "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c"){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    DeviceTypeFormScript.this.setScript(DeviceTypeFormScript.this.getScriptEditor().getText());
                }
            };
        }
    }

    protected class DeviceTypeFormMain
    extends BGUPanel {
        private BGTextField title;
        private BGUComboBox<EntitySpec> entitySpec;
        private JTextArea comment;
        private BGConfigEditor config;
        private JCheckBox source;
        private DynamicClassChooser orderManagerClass;
        private DynamicClassChooser protocolClass;
        private DynamicClassChooser managerClass;
        protected boolean showDeviceManager;
        protected boolean showEntity;
        protected boolean showSource;
        protected boolean showProtocolHandler;
        protected DynamicClassChooser.SelectDynamicClass selectDynamicClass;
        protected ConfigParamTableModel configParamTableModel;

        public DeviceTypeFormMain() {
            super(new BorderLayout());
            this.showDeviceManager = true;
            this.showEntity = true;
            this.showSource = true;
            this.showProtocolHandler = true;
            this.selectDynamicClass = null;
            this.configParamTableModel = new ConfigParamTableModel();
        }

        public DeviceTypeFormMain(boolean showEntity, boolean showDeviceManager, boolean showProtocolHandler, boolean showSource) {
            super(new BorderLayout());
            this.showDeviceManager = true;
            this.showEntity = true;
            this.showSource = true;
            this.showProtocolHandler = true;
            this.selectDynamicClass = null;
            this.configParamTableModel = new ConfigParamTableModel();
            this.showEntity = showEntity;
            this.showDeviceManager = showDeviceManager;
            this.showProtocolHandler = showProtocolHandler;
            this.showSource = showSource;
        }

        @Override
        protected void jbInit() {
            BGSwingUtilites.wrapEmptyBorder(this);
            Map<String, String> params = DeviceTypePanel.this.getParams();
            this.selectDynamicClass = (className, ifaceName) -> {
                try {
                    this.configParamTableModel.setData(className, ifaceName, DeviceTypePanel.this.getWs().configParameterList(className.getClassName()));
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog(ex);
                }
            };
            String iface = params.get("om.iface");
            this.orderManagerClass = new DynamicClassChooser(true);
            this.orderManagerClass.setIfaceName(iface);
            this.orderManagerClass.setSuperclassName(params.get("om.super"));
            this.orderManagerClass.setDerivingIfaces(Collections.singleton(iface));
            this.orderManagerClass.setSelectHandler(this.selectDynamicClass);
            iface = params.get("ph.iface");
            this.protocolClass = new DynamicClassChooser(true);
            this.protocolClass.setIfaceName(iface);
            this.protocolClass.setSuperclassName(params.get("ph.super"));
            this.protocolClass.setDerivingIfaces(Collections.singleton(iface));
            this.protocolClass.setSelectHandler(this.selectDynamicClass);
            iface = params.get("dm.iface");
            this.managerClass = new DynamicClassChooser(true);
            this.managerClass.setIfaceName(iface);
            this.managerClass.setSuperclassName(params.get("dm.super"));
            this.managerClass.setDerivingIfaces(Collections.singleton(iface));
            this.managerClass.setSelectHandler(this.selectDynamicClass);
            this.title = new BGTextField();
            this.entitySpec = new BGUComboBox();
            this.comment = new JTextArea(8, 0);
            this.comment.setMargin(new Insets(3, 3, 3, 3));
            this.config = new BGConfigEditor();
            this.source = new JCheckBox();
            this.source.setText(params.get("is.source"));
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 3), 0, 0));
            panel.add((Component)this.title, new GridBagConstraints(0, 1, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 0, 0, 3), 0, 0));
            if (this.showSource) {
                panel.add((Component)this.source, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 3), 0, 0));
            }
            if (this.showEntity) {
                panel.add((Component)new JLabel("\u041d\u0430\u0431\u043e\u0440 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u043e\u0432:"), new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 3), 0, 0));
                panel.add(this.entitySpec, new GridBagConstraints(0, 7, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 0, 0, 3), 0, 0));
            }
            panel.add((Component)new JLabel(params.get("om.title") + ":"), new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 3), 0, 0));
            panel.add((Component)this.orderManagerClass, new GridBagConstraints(0, 9, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 0, 0, 3), 0, 0));
            panel.add((Component)new JLabel(params.get("protocol.handler.title") + ":"), new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 3), 0, 0));
            panel.add((Component)this.protocolClass, new GridBagConstraints(0, 11, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 0, 0, 3), 0, 0));
            if (!this.showProtocolHandler) {
                BGSwingUtilites.setEnabled(this.protocolClass, false);
            }
            if (this.showDeviceManager) {
                panel.add((Component)new JLabel("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a \u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e\u043c:"), new GridBagConstraints(0, 12, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 3), 0, 0));
                panel.add((Component)this.managerClass, new GridBagConstraints(0, 13, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 0, 0, 3), 0, 0));
            }
            JPanel extraPanel = this.addExtraPanel();
            panel.add((Component)extraPanel, new GridBagConstraints(0, 14, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 0, 0, 3), 0, 0));
            panel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(0, 15, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 3), 0, 0));
            panel.add((Component)new JScrollPane(this.comment), new GridBagConstraints(0, 16, 1, 1, 0.0, 1.0, 10, 1, new Insets(3, 0, 0, 3), 0, 0));
            this.add((Component)new BGSplitPaneNoBorder(1, panel, (Component)this.getConfigPanel(), 400L), "Center");
        }

        protected JPanel getConfigPanel() {
            BGUTable table = new BGUTable(this.configParamTableModel);
            table.setSelectionMode(0);
            BGSwingUtilites.handleEdit((JTable)table, this, "handler.parameter.edit");
            JTabbedPane tabbedPane = new JTabbedPane();
            tabbedPane.add("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u043e\u0432", new JScrollPane(table));
            tabbedPane.add("\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f", this.config);
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)tabbedPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 5, 0, 0), 0, 0));
            return panel;
        }

        protected JPanel addExtraPanel() {
            return new JPanel(new BorderLayout());
        }

        @Override
        protected void initActions() {
            new AbstractBGUPanel.BGActionNew(e -> {
                Object current = DeviceTypePanel.this.newDeviceType();
                this.config.setText("");
                this.configParamTableModel.deleteRows();
                this.configParamTableModel.setConfig(this.config);
                this.title.setText("");
                this.comment.setText("");
                this.orderManagerClass.performAction("refresh");
                this.protocolClass.performAction("refresh");
                if (this.showDeviceManager) {
                    this.managerClass.performAction("refresh");
                }
                DeviceTypePanel.this.currentRef.set(current);
                this.showExtraValues();
            });
            new AbstractBGUPanel.BGActionEdit(e -> {
                DeviceType current = (DeviceType)DeviceTypePanel.this.currentRef.get();
                this.config.setText(current.getConfig());
                this.configParamTableModel.deleteRows();
                this.configParamTableModel.setConfig(this.config);
                this.title.setText(current.getTitle());
                List entitySpecList = ((ClientContext)this.getContext()).getPort(EntityService.class, 0).entitySpecList();
                entitySpecList.add(0, new EntitySpec(" --- "));
                this.entitySpec.setData(entitySpecList);
                this.entitySpec.setSelectedItem(current.getDeviceEntitySpecId());
                this.orderManagerClass.performAction("refresh");
                if (current.getSaHandlerClass() != null) {
                    this.orderManagerClass.setSelectedItem(current.getSaHandlerClass());
                } else if (this.orderManagerClass.getClasses().size() > 0) {
                    this.orderManagerClass.setSelectedIndex(0);
                }
                this.protocolClass.performAction("refresh");
                if (current.getProtocolHandlerClass() != null) {
                    this.protocolClass.setSelectedItem(current.getProtocolHandlerClass());
                } else if (this.protocolClass.getClasses().size() > 0) {
                    this.protocolClass.setSelectedIndex(0);
                }
                if (this.showDeviceManager) {
                    this.managerClass.performAction("refresh");
                    if (current.getDeviceManagerClass() != null) {
                        this.managerClass.setSelectedItem(current.getDeviceManagerClass());
                    } else {
                        this.managerClass.setSelectedIndex(0);
                    }
                }
                this.comment.setText(current.getComment());
                this.source.setSelected(current.isSource());
                this.showExtraValues();
            });
            new AbstractBGUPanel.DefaultAction("ok", "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c"){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    DeviceType current = (DeviceType)DeviceTypePanel.this.currentRef.get();
                    current.setTitle(DeviceTypeFormMain.this.title.getText());
                    current.setComment(DeviceTypeFormMain.this.comment.getText());
                    current.setConfig(DeviceTypeFormMain.this.config.getText());
                    current.setSaHandlerClass(DeviceTypeFormMain.this.orderManagerClass.getSelectedClass());
                    current.setProtocolHandlerClass(DeviceTypeFormMain.this.protocolClass.getSelectedClass());
                    current.setDeviceManagerClass(DeviceTypeFormMain.this.managerClass.getSelectedClass());
                    if (DeviceTypeFormMain.this.entitySpec.getSelectedItem() != null) {
                        current.setDeviceEntitySpecId(((EntitySpec)DeviceTypeFormMain.this.entitySpec.getSelectedItem()).getId());
                    }
                    current.setSource(DeviceTypeFormMain.this.source.isSelected());
                    DeviceTypeFormMain.this.saveExtraValues();
                }
            };
            new AbstractBGUPanel.DefaultAction("handler.parameter.edit", ""){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    ConfigParameter configParameter = (ConfigParameter)DeviceTypeFormMain.this.configParamTableModel.getSelectedRow();
                    new HandlerParameterEditor(DeviceTypePanel.this, "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430", configParameter).open();
                    List configParameters = DeviceTypeFormMain.this.configParamTableModel.getRows();
                    for (int index = 0; index < configParameters.size(); ++index) {
                        if (!((ConfigParameter)configParameters.get(index)).getKey().equals(configParameter.getKey())) continue;
                        ((ConfigParameter)configParameters.get(index)).setValue(configParameter.getValue());
                        DeviceTypeFormMain.this.configParamTableModel.fireTableCellUpdated(index, 2);
                    }
                    DeviceTypeFormMain.this.updateConfig(configParameter.getKey(), configParameter.getValue());
                }
            };
        }

        private void updateConfig(String key, String value) {
            boolean update = false;
            Object cfg = this.config.getText();
            int pos = ("\n" + (String)cfg).indexOf("\n" + key + "=");
            if (pos > -1) {
                int end = ((String)cfg).indexOf("\n", pos);
                boolean remove = Utils.isEmptyString(value);
                cfg = ((String)cfg).substring(0, pos > 0 ? pos - 1 : 0) + (String)(remove ? "" : "\n" + key + "=" + value) + (end > -1 ? ((String)cfg).substring(remove ? end + 1 : end) : "");
                update = true;
            }
            if (!update && !Utils.isEmptyString(value)) {
                cfg = (String)cfg + (((String)cfg).endsWith("\n") ? "" : "\n") + key + "=" + value;
            }
            this.config.setText((String)cfg);
        }

        protected void showExtraValues() {
        }

        protected void saveExtraValues() {
        }
    }

    protected abstract class DeviceTypeForm
    extends BGUPanel {
        protected JTabbedPane pane;
        protected List<BGUPanel> panels;

        public DeviceTypeForm() {
            super(new BorderLayout());
            this.setName("deviceTypeForm");
        }

        @Override
        protected abstract void jbInit();

        @Override
        protected void initActions() {
            new AbstractBGUPanel.BGActionNew(e -> {
                for (BGUPanel panel : this.panels) {
                    panel.performAction("new");
                }
                this.pane.setSelectedIndex(0);
                this.performActionOpen();
            });
            new AbstractBGUPanel.BGActionEdit(e -> {
                DeviceType selected = (DeviceType)DeviceTypePanel.this.model.getSelectedRow();
                if (selected != null) {
                    selected = DeviceTypePanel.this.getWs().deviceTypeGet(selected.getId());
                    DeviceTypePanel.this.currentRef.set(selected);
                    for (BGUPanel panel : this.panels) {
                        panel.performAction("edit");
                    }
                    this.pane.setSelectedIndex(0);
                    this.performActionOpen();
                }
            });
            new AbstractBGUPanel.BGActionDelete(e -> {
                if (!this.isEnabled()) {
                    ClientUtils.showErrorMessageDialog("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430");
                    return;
                }
                DeviceTypePanel.this.currentRef.set((DeviceType)DeviceTypePanel.this.model.getSelectedRow());
                if (DeviceTypePanel.this.currentRef.get() == null) {
                    return;
                }
                if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u044d\u0442\u043e\u0442 \u0442\u0438\u043f \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f", 0) == 0) {
                    DeviceTypePanel.this.getWs().deviceTypeDelete(((DeviceType)DeviceTypePanel.this.currentRef.get()).getId());
                    DeviceTypePanel.this.performAction("refresh");
                }
            });
            new AbstractBGUPanel.DefaultAction("ok", "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c"){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    for (BGUPanel panel : DeviceTypeForm.this.panels) {
                        panel.performAction("ok");
                    }
                    int id = DeviceTypePanel.this.getWs().deviceTypeUpdate((DeviceType)DeviceTypePanel.this.currentRef.get());
                    DeviceTypePanel.this.performAction("refresh");
                    DeviceTypePanel.this.model.setSelectedRow(id);
                    DeviceTypeForm.this.performActionClose();
                }
            };
        }
    }
}

