/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mangooffice.client;

import bitel.billing.module.common.FloatTextField;
import bitel.billing.module.common.IntTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.mangooffice.common.bean.MangoAccount;
import ru.bitel.bgbilling.modules.mangooffice.common.bean.MangoAccountProduct;
import ru.bitel.bgbilling.modules.mangooffice.common.bean.MangoAccountStatus;
import ru.bitel.bgbilling.modules.mangooffice.common.service.MangoService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;

public class MangoContractAccountPanel
extends BGUPanel {
    private MangoService mangoService = null;
    private MangoAccount account = null;
    private JPanel createPanel = new JPanel(new GridBagLayout());
    private BGButton createCredentialsButton = new BGButton("\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u0443\u0447\u0435\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435");
    private BGButton bindCredentialsButton = new BGButton("\u041f\u0440\u0438\u0432\u044f\u0437\u0430\u0442\u044c \u0443\u0447\u0435\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435");
    private JTextPane accountLabel = new JTextPane();
    private JPanel accountPanel = null;
    private JPanel productPanel = new JPanel(new GridBagLayout());
    private JPanel productEditorPanel = new JPanel(new GridBagLayout());
    private BGUComboBox<IdTitle> typeProductComboBox = new BGUComboBox();
    private BGTableModel<MangoAccountProduct> model;
    private BGUTable table = new BGUTable(this.model);
    protected Map<Integer, IdTitle> tariffTypeMap = null;
    protected List<IdTitle> tariffTypeList = null;
    AbstractBGUPanel.AsyncAction<MangoAccountStatus> getStatus = new AbstractBGUPanel.AsyncAction<MangoAccountStatus>("async", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

        protected MangoAccountStatus doInBackground() throws Exception {
            if (MangoContractAccountPanel.this.account == null) {
                return null;
            }
            return MangoContractAccountPanel.this.mangoService.getMangoAccountStatus(MangoContractAccountPanel.this.account.getControl());
        }

        protected void done(MangoAccountStatus result) throws Exception {
            if (result != null) {
                String blockDes = result.getBlockDescription();
                MangoContractAccountPanel.this.accountLabel.setText("<html><body><pre><b>\u041b\u043e\u0433\u0438\u043d:</b> " + MangoContractAccountPanel.this.account.getControl() + "  <b>\u041f\u0430\u0440\u043e\u043b\u044c:</b> " + MangoContractAccountPanel.this.account.getPassword() + "  <b>accountId:</b> " + MangoContractAccountPanel.this.account.getAccountId() + "<br><b>\u0421\u0442\u0430\u0442\u0443\u0441:</b> \"" + result.getStatusDescription() + "\" " + (String)(Utils.notBlankString((String)blockDes) ? " <b>\u0411\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u043a\u0430:</b> \"" + blockDes + "\"" : "") + " <b>\u0411\u0430\u043b\u0430\u043d\u0441:</b> " + Utils.formatCost((BigDecimal)result.getBalance()) + "</pre></body></html>");
                MangoContractAccountPanel.this.accountLabel.setText(MangoContractAccountPanel.this.accountLabel.getText() + "   " + result.toString());
                MangoContractAccountPanel.this.accountLabel.updateUI();
                MangoContractAccountPanel.this.accountLabel.setBackground(null);
            }
        }
    };

    protected void jbInit() throws Exception {
        try {
            this.mangoService = (MangoService)((ClientContext)this.getContext()).getPort(MangoService.class);
            BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
            okCancel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
            IntTextField idField = new IntTextField(20);
            JPanel bindPanel = new JPanel(new GridBagLayout());
            bindPanel.setBorder(BorderFactory.createCompoundBorder((Border)new BGTitleBorder("\u041f\u0440\u0438\u0432\u044f\u0437\u0430\u0442\u044c \u0443\u0447\u0435\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435"), BorderFactory.createEmptyBorder(0, 3, 3, 3)));
            bindPanel.add((Component)idField, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            bindPanel.add((Component)new JLabel("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 accountId(id \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u0430 \u0438\u0437 Mango) "), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            bindPanel.add((Component)okCancel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            bindPanel.setVisible(false);
            this.createPanel.add((Component)this.createCredentialsButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 10), 0, 0));
            this.createPanel.add((Component)this.bindCredentialsButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 10), 0, 0));
            this.createPanel.add((Component)bindPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 10), 0, 0));
            this.accountPanel = this.getAccountPanel();
            this.model = new BGTableModel<MangoAccountProduct>("\u041f\u0440\u043e\u0434\u0443\u043a\u0442\u044b"){

                protected void initColumns() {
                    this.addColumnId();
                    this.addColumn("\u0422\u0430\u0440\u0438\u0444", -1, 80, -1, "productTitle", true);
                    this.addColumn("Product Id", -1, 250, -1, "productId", true);
                    this.addColumn("\u0414\u0430\u0442\u0430", -1, 150, -1, "dateFrom", true, DatetimeTableCellRenderer.DEFAULT_DDMMYYYY_HHMMSS());
                    this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", -1, 150, -1, "status", true);
                }

                public Object getValueAt(MangoAccountProduct val, int column) throws Exception {
                    switch (column) {
                        case 1: {
                            IdTitle plan = MangoContractAccountPanel.this.tariffTypeMap.get(val.getPlanId());
                            return plan != null ? plan.getTitle() : "<\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d>";
                        }
                        case 4: {
                            return val.getStatusDescription();
                        }
                    }
                    return super.getValue((Object)val, column);
                }
            };
            this.table.setModel(this.model);
            this.productEditorPanel.setVisible(false);
            BGButtonPanelOkCancel okCancelEditor = new BGButtonPanelOkCancel();
            okCancelEditor.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
            this.productEditorPanel.setBorder(BorderFactory.createCompoundBorder((Border)new BGTitleBorder("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043f\u0440\u043e\u0434\u0443\u043a\u0442"), BorderFactory.createEmptyBorder(0, 3, 3, 3)));
            this.productEditorPanel.add((Component)new JLabel("\u0422\u0430\u0440\u0438\u0444: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 0), 0, 0));
            this.productEditorPanel.add((Component)this.typeProductComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 0, 5, 5), 0, 0));
            this.productEditorPanel.add((Component)okCancelEditor, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.productPanel.setBorder(BorderFactory.createCompoundBorder((Border)new BGTitleBorder("\u041f\u0440\u043e\u0434\u0443\u043a\u0442\u044b"), BorderFactory.createEmptyBorder(0, 3, 3, 3)));
            this.productPanel.add((Component)new JScrollPane((Component)this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.productPanel.add((Component)this.productEditorPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.setLayout(new GridBagLayout());
            this.add(this.createPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 10), 0, 0));
            this.add(this.accountPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 17, new Insets(5, 5, 0, 10), 0, 0));
            this.add(Box.createVerticalBox(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.001, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add(this.productPanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
            this.createCredentialsButton.addActionListener(e -> {
                try {
                    this.mangoService.createAccount(((ClientContext)this.getContext()).getContractId());
                    this.performAction("refresh", "refresh");
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            });
            this.bindCredentialsButton.addActionListener(e -> {
                this.createCredentialsButton.setVisible(false);
                this.bindCredentialsButton.setVisible(false);
                idField.setText("");
                bindPanel.setVisible(true);
            });
            okCancel.addActionListener(e -> {
                if (e.getActionCommand().equals("ok")) {
                    int accountId = Utils.parseInt((String)idField.getText(), (int)-1);
                    if (accountId < 1) {
                        ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 accountId!");
                        return;
                    }
                    try {
                        this.mangoService.bindAccount(((ClientContext)this.getContext()).getContractId(), accountId);
                        this.performAction("refresh", "refresh");
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                }
                this.createCredentialsButton.setVisible(true);
                this.bindCredentialsButton.setVisible(true);
                bindPanel.setVisible(false);
            });
            okCancelEditor.addActionListener(e -> {
                if (e.getActionCommand().equals("ok")) {
                    try {
                        IdTitle select = (IdTitle)this.typeProductComboBox.getSelectedItem();
                        if (select == null) {
                            ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u0442\u0430\u0440\u0438\u0444");
                            return;
                        }
                        this.mangoService.productAdd(((ClientContext)this.getContext()).getContractId(), select.getId());
                        this.model.setData(this.mangoService.getProductList(((ClientContext)this.getContext()).getContractId()));
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                }
                this.productEditorPanel.setVisible(false);
            });
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private JPanel getAccountPanel() {
        JPanel accountPanel = new JPanel(new GridBagLayout());
        FloatTextField balanceTextField = new FloatTextField();
        BGTextField commentField = new BGTextField();
        commentField.setPromptText("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439");
        BGButtonPanelOkCancel okCancelBalance = new BGButtonPanelOkCancel();
        okCancelBalance.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        JPanel balancePanel = new JPanel(new GridBagLayout());
        balancePanel.setBorder(BorderFactory.createCompoundBorder((Border)new BGTitleBorder("\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0431\u0430\u043b\u0430\u043d\u0441"), BorderFactory.createEmptyBorder(0, 3, 0, 3)));
        balancePanel.add((Component)new JLabel("\u0421\u0443\u043c\u043c\u0430:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        balancePanel.add((Component)balanceTextField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 5, 10), 0, 0));
        balancePanel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 5, 0), 0, 0));
        balancePanel.add((Component)commentField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 0, 10), 0, 0));
        balancePanel.add((Component)okCancelBalance, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 5, 10), 0, 0));
        this.accountLabel.setEditable(false);
        this.accountLabel.setBorder(null);
        this.accountLabel.setBackground(null);
        this.accountLabel.setContentType("text/html");
        accountPanel.add((Component)this.accountLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        accountPanel.add((Component)balancePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        okCancelBalance.addActionListener(e -> {
            if (e.getActionCommand().equals("ok")) {
                String operation;
                BigDecimal sum = Utils.parseBigDecimal((String)balanceTextField.getText(), (BigDecimal)BigDecimal.ZERO);
                String comment = commentField.getText();
                if (BigDecimal.ZERO.equals(sum)) {
                    ClientUtils.showErrorMessageDialog((String)"\u0421\u0443\u043c\u043c\u0430 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u043e\u0442\u043b\u0438\u0447\u043d\u0430\u044f \u043e\u0442 0 !");
                    return;
                }
                if (Utils.isBlankString((String)comment)) {
                    ClientUtils.showErrorMessageDialog((String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439!");
                    return;
                }
                String string = operation = BigDecimal.ZERO.compareTo(sum) < 1 ? "\u043f\u0440\u0438\u0431\u0430\u0432\u0438\u0442\u044c" : "\u0443\u0431\u0430\u0432\u0438\u0442\u044c";
                if (ClientUtils.confirm((String)("\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 " + operation + " \u0431\u0430\u043b\u0430\u043d\u0441 \u043d\u0430 " + Utils.formatCost((BigDecimal)sum.abs()) + " ?"), (String)"\u0418\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u0431\u0430\u043b\u0430\u043d\u0441\u0430")) {
                    try {
                        this.mangoService.changeMangoBalance(((ClientContext)this.getContext()).getContractId(), sum, comment);
                        this.performAction("refresh", "refresh");
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                }
            }
            balanceTextField.setText("");
            commentField.setText("");
            commentField.setPromptText("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439");
        });
        return accountPanel;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            if (e.getActionCommand() == "refresh") {
                this.accountPanel.setVisible(false);
                this.createPanel.setVisible(false);
                this.productPanel.setVisible(false);
                this.account = this.mangoService.getContractAccount(((ClientContext)this.getContext()).getContractId());
                if (this.account != null) {
                    this.accountPanel.setVisible(true);
                    this.productPanel.setVisible(true);
                    this.createPanel.setVisible(false);
                    this.accountLabel.setText("<html><body><pre><b>\u041b\u043e\u0433\u0438\u043d:</b> " + this.account.getControl() + "  <b>\u041f\u0430\u0440\u043e\u043b\u044c:</b> " + this.account.getPassword() + "  <b>accountId:</b> " + this.account.getAccountId() + "<br> </pre></body></html>");
                    this.getStatus.perform(null, "async");
                    if (this.tariffTypeList != null) {
                        this.typeProductComboBox.setData(this.tariffTypeList);
                    }
                    this.model.setData(this.mangoService.getProductList(((ClientContext)this.getContext()).getContractId()));
                } else {
                    this.accountPanel.setVisible(false);
                    this.productPanel.setVisible(false);
                    this.createPanel.setVisible(true);
                }
            }
        });
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
            if (this.account == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0414\u043b\u044f \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043d\u0430\u043b\u0438\u0447\u0438\u0435 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430!");
                return;
            }
            if (this.tariffTypeList == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0414\u043b\u044f \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u044b \u0442\u0430\u0440\u0438\u0444\u044b! \u0414\u043e\u0431\u0430\u0432\u044c\u0442\u0435 \u0438\u0445 \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044e \u043c\u043e\u0434\u0443\u043b\u044f");
                return;
            }
            this.productEditorPanel.setVisible(true);
        });
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            MangoAccountProduct product = (MangoAccountProduct)this.model.getSelectedRow();
            if (product == null) {
                ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u0437\u0430\u043a\u0440\u044b\u0432\u0430\u0435\u043c\u044b\u0439 \u043f\u0440\u043e\u0434\u0443\u043a\u0442");
                return;
            }
            if (ClientUtils.confirm((String)("\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0437\u0430\u043a\u0440\u044b\u0442\u044c \u043f\u0440\u043e\u0434\u0443\u043a\u0442: " + String.valueOf(this.tariffTypeMap.get(product.getPlanId()))), (String)"\u0417\u0430\u043a\u0440\u044b\u0442\u0438\u0435")) {
                this.mangoService.productRemove(product.getId());
                this.performAction("refresh", "refresh");
            }
        });
    }
}

