/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.npay.client;

import bitel.billing.module.services.ServicePanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGDecimalTextField;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.PeriodTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractService;
import ru.bitel.bgbilling.kernel.module.common.service.ModuleService;
import ru.bitel.bgbilling.modules.npay.common.bean.ServiceObject;
import ru.bitel.bgbilling.modules.npay.common.service.NPayService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Period;

public class EntityServicePropertiesPanel
extends ServicePanel {
    private int npayModuleId = -1;
    private int serviceObjectId;
    private ServiceObject currentRow;
    private BGUTable table = null;
    private BGControlPanelPeriodNoB servicePeriod = new BGControlPanelPeriodNoB();
    private BGDialogToolBar toolBar = new BGDialogToolBar();
    private HashSet<Integer> deleted = new HashSet();
    private EntityPayServiceTableModel tableModel = new EntityPayServiceTableModel();
    private ModuleService moduleService = null;
    private ContractService contractService = null;
    private Map<Integer, NPayService> npayServiceMap = new HashMap<Integer, NPayService>();

    public EntityServicePropertiesPanel() {
        this.jbInit();
    }

    private void jbInit() {
        this.toolBar.setDefaultButtons(e -> this.actionPerformed(e));
        this.table = new BGUTable((TableModel)((Object)this.tableModel));
        this.table.setSelectionMode(0);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.toolBar, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 3, 0), 0, 0));
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.toolBar.setToolBar(new String[]{"newItem", "editItem", "deleteItem"});
        BGSwingUtilites.handleLDMouseClicked((Component)this.table, e -> this.editItem());
    }

    public void setData() {
        Integer npayMid = (Integer)this.params.get("npayMid");
        if (npayMid != null && npayMid > 0) {
            this.npayModuleId = npayMid;
            try {
                this.tableModel.setData(this.getNPayService(this.npayModuleId).serviceObjectList(this.getContractId(), this.objectId, this.getModuleId(), this.id, false, new Date()));
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
    }

    public void deleteItem() {
        ServiceObject serviceObject = (ServiceObject)this.tableModel.getSelectedRow();
        if (serviceObject == null) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443!");
        } else {
            this.serviceObjectId = serviceObject.getId();
            if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0430\u0431\u043e\u043d\u043f\u043b\u0430\u0442\u0443?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
                this.tableModel.getRows().remove(serviceObject);
                if (this.serviceObjectId > 0) {
                    this.deleted.add(this.serviceObjectId);
                }
                this.tableModel.fireTableDataChanged();
            }
        }
    }

    public void editItem() {
        ServiceObject serviceObject = (ServiceObject)this.tableModel.getSelectedRow();
        if (serviceObject == null) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443!");
        } else {
            this.serviceObjectId = serviceObject.getId();
            this.startEdit(serviceObject);
        }
    }

    public void newItem() {
        this.serviceObjectId = 0;
        this.startEdit(ServiceObject.builder().build());
    }

    private void startEdit(ServiceObject serviceObject) {
        try {
            if (this.npayModuleId < 0) {
                ClientUtils.showErrorMessageDialog((String)"\u041c\u043e\u0434\u0443\u043b\u044c NPAY \u043d\u0435 \u0441\u043e\u043e\u0442\u043d\u0435\u0441\u0435\u043d \u0441 \u043c\u043e\u0434\u0443\u043b\u0435\u043c VOICE!");
                return;
            }
            if (!this.getContractService().hasModuleInstance(this.getContractId(), this.npayModuleId)) {
                ClientUtils.showErrorMessageDialog((String)("\u041a \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u043d\u0435 \u043f\u0440\u0438\u0432\u044f\u0437\u0430\u043d \u044d\u043a\u0437\u0435\u043c\u043f\u043b\u044f\u0440 \u043c\u043e\u0434\u0443\u043b\u044f NPAY \u0441 \u043a\u043e\u0434\u043e\u043c " + this.npayModuleId + ". \u0414\u043e\u0431\u0430\u0432\u044c\u0442\u0435 \u0435\u0433\u043e \u0432 \u0441\u043f\u0438\u0441\u043e\u043a \u043c\u043e\u0434\u0443\u043b\u0435\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430!"));
                return;
            }
            this.currentRow = serviceObject;
            if (this.serviceObjectId == 0) {
                this.currentRow.setContractId(this.getContractId());
                this.currentRow.setServiceId(-1);
                this.currentRow.setCol(BigDecimal.ONE);
                this.currentRow.setDate1(new Date());
                this.currentRow.setEntityMid(this.getModuleId());
                this.currentRow.setEntityId(this.getId());
                new ServiceEditorDialog("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0443\u0441\u043b\u0443\u0433\u0438", this.currentRow).open();
            } else {
                new ServiceEditorDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0443\u0441\u043b\u0443\u0433\u0438", this.currentRow).open();
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    public boolean updateData() {
        if (this.npayModuleId <= 0) {
            return true;
        }
        String objectId = (String)this.params.get("objectId");
        if (Utils.isEmptyString((String)objectId)) {
            objectId = "0";
        }
        for (Integer id : this.deleted) {
            try {
                this.getNPayService(this.npayModuleId).serviceObjectDelete(this.getContractId(), id.intValue());
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
        this.deleted.clear();
        for (ServiceObject serviceObject : this.tableModel.getRows()) {
            try {
                serviceObject.setEntityId(this.id);
                Date accountDateTo = null;
                try {
                    accountDateTo = (Date)this.getAttrs().get("accountDateTo");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (accountDateTo != null && (serviceObject.getDate2() == null || serviceObject.getDate2().after(accountDateTo))) {
                    serviceObject.setDate2(accountDateTo);
                }
                this.getNPayService(this.npayModuleId).serviceObjectUpdate(this.getContractId(), serviceObject);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
                return false;
            }
        }
        return true;
    }

    private ModuleService getModuleService() {
        if (this.moduleService == null) {
            this.moduleService = (ModuleService)this.getContext().getPort(ModuleService.class, 0);
        }
        return this.moduleService;
    }

    private ContractService getContractService() {
        if (this.contractService == null) {
            this.contractService = (ContractService)this.getContext().getPort(ContractService.class, 0);
        }
        return this.contractService;
    }

    private NPayService getNPayService(int npayModuleId) {
        NPayService npayService = this.npayServiceMap.get(npayModuleId);
        if (npayService == null) {
            npayService = (NPayService)this.getContext().getPort(NPayService.class, npayModuleId);
            this.npayServiceMap.put(npayModuleId, npayService);
        }
        return npayService;
    }

    class EntityPayServiceTableModel
    extends BGTableModel<ServiceObject> {
        public static final String COLUMN_ID = "id";
        public static final String COLUMN_SID = "sid";
        public static final String COLUMN_COL = "col";

        public EntityPayServiceTableModel() {
            super("phoneEntityPayService");
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 180, 180, 180, "period", true, (TableCellRenderer)new PeriodTableCellRenderer());
            this.addColumn("\u0423\u0441\u043b\u0443\u0433\u0430", -1, -1, -1, "serviceTitle", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0426\u0435\u043d\u0430 \u0437\u0430 \u0435\u0434.", 180, 180, 180, "cost", false, (TableCellRenderer)DecimalTableCellRenderer.DEFAULT());
            this.addColumn("\u041a\u043e\u043b-\u0432\u043e", 80, 80, 80, COLUMN_COL, true, (TableCellRenderer)new DecimalTableCellRenderer("###,###,###,##0.000"));
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, -1, -1, "comment", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }

        public Object getValue(ServiceObject val, int column) throws Exception {
            String identifier = this.getIdentifier(column);
            if ("period".equals(identifier)) {
                return new Period(val.getDate1(), val.getDate2());
            }
            return super.getValue((Object)val, column);
        }
    }

    class ServiceEditorDialog
    extends BGEditorDialog<ServiceObject> {
        private BGDecimalTextField colTf;
        private BGDecimalTextField costTf;
        private BGUList<IdTitle> serviceList;
        private JTextArea comment;

        public ServiceEditorDialog(String title, ServiceObject data) {
            super(title, (Object)data);
            this.colTf = new BGDecimalTextField(10);
            this.costTf = new BGDecimalTextField(10);
            this.serviceList = new BGUList();
            this.comment = new JTextArea(3, 30);
        }

        public void doDialogPanel() {
            ArrayList services = new ArrayList();
            try {
                EntityServicePropertiesPanel.this.getModuleService().moduleServiceList(EntityServicePropertiesPanel.this.npayModuleId).forEach(a -> services.add(new IdTitle(a.getId(), a.getTitle())));
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
            this.serviceList.setData(services);
            this.serviceList.setEnabled(EntityServicePropertiesPanel.this.serviceObjectId == 0);
            this.serviceList.setSelectionMode(0);
            this.serviceList.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            this.comment.setMargin(new Insets(3, 3, 3, 3));
            JScrollPane scrollserviceList = new JScrollPane((Component)this.serviceList);
            scrollserviceList.setMinimumSize(new Dimension((int)scrollserviceList.getMinimumSize().getWidth(), 200));
            scrollserviceList.setPreferredSize(new Dimension((int)scrollserviceList.getPreferredSize().getWidth(), 200));
            this.panel.add((Component)this.getTopPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u0423\u0441\u043b\u0443\u0433\u0430:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((Component)scrollserviceList, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 2, new Insets(2, 5, 5, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((Component)new JScrollPane(this.comment), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 2, new Insets(2, 5, 5, 0), 0, 0));
            this.panel.validate();
            this.serviceList.setSelectedId(((ServiceObject)this.data).getServiceId(), true);
            this.costTf.setText(Optional.ofNullable(((ServiceObject)this.data).getCost()).map(a -> Utils.formatBigDecimal((BigDecimal)a, (int)2)).orElse(""));
            this.colTf.setText(((ServiceObject)this.data).getCol().toPlainString());
            EntityServicePropertiesPanel.this.servicePeriod.setDateFrom(((ServiceObject)this.data).getDate1());
            EntityServicePropertiesPanel.this.servicePeriod.setDateTo(((ServiceObject)this.data).getDate2());
            this.comment.setText(((ServiceObject)this.data).getComment());
        }

        private JPanel getTopPanel() {
            JLabel label = new JLabel("\u0426\u0435\u043d\u0430 \u0437\u0430 \u0435\u0434. (\u043e\u043f\u0446\u0438\u043e\u043d.) [?]:");
            label.setToolTipText("\u043f\u0435\u0440\u0435\u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u0435 \u0446\u0435\u043d\u044b \u0438\u0437 \u0442\u0430\u0440\u0438\u0444\u0430");
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434: "), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            panel.add((Component)label, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
            panel.add((Component)EntityServicePropertiesPanel.this.servicePeriod, new GridBagConstraints(-1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 5, 0, 5), 0, 0));
            panel.add((Component)this.colTf, new GridBagConstraints(-1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 0), 0, 0));
            panel.add((Component)this.costTf, new GridBagConstraints(-1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(3, 5, 0, 0), 0, 0));
            return panel;
        }

        public boolean doApply() throws Exception {
            IdTitle item = (IdTitle)this.serviceList.getSelectedValue();
            if (item == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0443\u0441\u043b\u0443\u0433\u0443!");
                return false;
            }
            String col = this.colTf.getText();
            String serviceTitle = item.getGuiTitle();
            if (Utils.isBlankString((String)col)) {
                ClientUtils.showErrorMessageDialog((String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e!");
                return false;
            }
            EntityServicePropertiesPanel.this.currentRow.setId(EntityServicePropertiesPanel.this.serviceObjectId);
            EntityServicePropertiesPanel.this.currentRow.setServiceId(item.getId());
            EntityServicePropertiesPanel.this.currentRow.setCost(Utils.parseBigDecimal((String)this.costTf.getText(), null));
            EntityServicePropertiesPanel.this.currentRow.setCol(Utils.parseBigDecimal((String)col, (BigDecimal)BigDecimal.ONE));
            EntityServicePropertiesPanel.this.currentRow.setDate1(EntityServicePropertiesPanel.this.servicePeriod.getDateFrom());
            EntityServicePropertiesPanel.this.currentRow.setDate2(EntityServicePropertiesPanel.this.servicePeriod.getDateTo());
            EntityServicePropertiesPanel.this.currentRow.setServiceTitle(serviceTitle);
            EntityServicePropertiesPanel.this.currentRow.setComment(this.comment.getText());
            if (EntityServicePropertiesPanel.this.currentRow.getId() == 0) {
                EntityServicePropertiesPanel.this.tableModel.getRows().add(EntityServicePropertiesPanel.this.currentRow);
                EntityServicePropertiesPanel.this.currentRow.setId(-1);
            }
            EntityServicePropertiesPanel.this.tableModel.fireTableDataChanged();
            return true;
        }
    }
}

