/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.shop.client.directory;

import bitel.billing.module.common.BGControlPanelContractSelect;
import bitel.billing.module.common.BGDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Date;
import javax.swing.Box;
import org.jfree.ui.tabbedui.VerticalLayout;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriod;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.plugins.shop.common.bean.StockItem;
import ru.bitel.bgbilling.plugins.shop.common.service.WarehouseOperationService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGButtonPanelOkCancel;

public class TransferStockItemToContractDialog
extends BGDialog {
    private final BGControlPanelContractSelect contractSelect = new BGControlPanelContractSelect(false, true, true);
    private final BGControlPanelPeriod periodPanel = new BGControlPanelPeriod();

    public TransferStockItemToContractDialog(WarehouseOperationService warehouseOperationService, StockItem stockItem) {
        if (stockItem == null) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u043e\u0432\u0430\u0440 \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435!");
            return;
        }
        BGButtonPanelOkCancel okCancelPanel = new BGButtonPanelOkCancel();
        okCancelPanel.getButtonOk().addActionListener(e -> {
            if (Utils.isEmptyCollection((Collection)this.contractSelect.getContractList())) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440!");
                return;
            }
            Date dateFrom = this.periodPanel.getDateFrom();
            Date dateTo = this.periodPanel.getDateTo();
            if (dateFrom == null) {
                ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u0430 \u0434\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430 \u043f\u0435\u0440\u0438\u043e\u0434\u0430!");
                return;
            }
            try {
                warehouseOperationService.transferToContract(stockItem.getId(), ((Integer)this.contractSelect.getContractList().get(0)).intValue(), dateFrom, dateTo);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
            this.dispose();
        });
        okCancelPanel.getButton("cancel").addActionListener(e -> this.dispose());
        this.getRootPane().setLayout((LayoutManager)new VerticalLayout());
        this.getRootPane().add(Box.createRigidArea(new Dimension(0, 5)));
        this.getRootPane().add((Component)this.contractSelect);
        this.getRootPane().add(Box.createRigidArea(new Dimension(0, 5)));
        this.getRootPane().add((Component)this.periodPanel);
        this.getRootPane().add(Box.createRigidArea(new Dimension(0, 5)));
        this.getRootPane().add((Component)okCancelPanel);
        this.getRootPane().add(Box.createRigidArea(new Dimension(0, 5)));
        this.setPreferredSize(new Dimension(350, 150));
        this.setModal(true);
        this.pack();
        this.moveWindowToCenterScreen();
    }
}

