/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.agr.server.bean;

import java.math.BigDecimal;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.modules.agr.common.bean.AGREnvironment;
import ru.bitel.bgbilling.modules.agr.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.agr.server.bean.AGRAction;
import ru.bitel.bgbilling.modules.agr.server.bean.AGRErrorCode;
import ru.bitel.bgbilling.modules.agr.server.bean.AGRException;
import ru.bitel.common.Utils;
import ru.bitel.common.util.DebugUtils;

public class AGRRequest
extends BGLogger {
    private AGRAction action = null;
    private String merchantTransId;
    private Long signTime;
    private String signString;
    private String paymentName;
    private int paymentId;
    private String agrTransId;
    private BigDecimal merchantTransAmount;
    private long vendorTransId;
    private AGREnvironment environment = null;
    private TransactionStatus status = null;
    private Date from;
    private Date to;
    private int vendorId;

    public static AGRRequest parseRequest(String jsonString, String pathInfo) throws AGRException {
        Logger logger = LoggerFactory.getLogger(AGRRequest.class);
        if (Utils.isBlankString((String)jsonString)) {
            throw new AGRException(AGRErrorCode.ERROR_IN_REQUEST_FROM_AGR, "\u0412\u0445\u043e\u0434\u044f\u0449\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043d\u0435 \u0434\u043e\u043b\u0436\u043d\u044b \u0431\u044b\u0442\u044c \u043f\u0443\u0441\u0442\u044b!");
        }
        if (Utils.isBlankString((String)pathInfo)) {
            throw new AGRException(AGRErrorCode.ERROR_IN_REQUEST_FROM_AGR, "Action \u0434\u043e\u043b\u0436\u0435\u043d \u043f\u0440\u0438\u0441\u0443\u0442\u0441\u0442\u0432\u043e\u0432\u0430\u0442\u044c \u0432 url!");
        }
        logger.debug("\t\u041f\u0430\u0440\u0441\u0438\u043d\u0433 \u0437\u0430\u043f\u0440\u043e\u0441\u0430");
        logger.debug("\t\u0412\u0445\u043e\u0434\u044f\u0449\u0438\u0435 \u0434\u0430\u043d\u043d\u044b\u0435: pathInfo = {}; json = {}", (Object)pathInfo, (Object)jsonString);
        AGRRequest result = new AGRRequest();
        String[] pathParts = pathInfo.split("/");
        String action = pathParts[pathParts.length - 1];
        result.setAction(AGRAction.valueOf(action.toUpperCase()));
        try {
            JSONObject jsonObject = new JSONObject(jsonString);
            if (jsonObject.has("AGR_TRANS_ID")) {
                result.setAgrTransId(String.valueOf(jsonObject.getLong("AGR_TRANS_ID")));
            }
            if (jsonObject.has("ENVIRONMENT")) {
                result.setEnvironment(AGREnvironment.valueOf((String)jsonObject.getString("ENVIRONMENT")));
            }
            if (jsonObject.has("FROM")) {
                result.setFrom(new Date(jsonObject.getLong("FROM")));
            }
            if (jsonObject.has("TO")) {
                result.setTo(new Date(jsonObject.getLong("TO")));
            }
            if (jsonObject.has("MERCHANT_TRANS_AMOUNT")) {
                result.setMerchantTransAmount(jsonObject.getBigDecimal("MERCHANT_TRANS_AMOUNT"));
            }
            if (jsonObject.has("PAYMENT_NAME")) {
                result.setPaymentName(jsonObject.getString("PAYMENT_NAME"));
            }
            if (jsonObject.has("PAYMENT_ID")) {
                result.setPaymentId(jsonObject.getInt("PAYMENT_ID"));
            }
            if (jsonObject.has("MERCHANT_TRANS_ID")) {
                result.setMerchantTransId(jsonObject.getString("MERCHANT_TRANS_ID"));
            }
            if (jsonObject.has("STATUS")) {
                result.setStatus((TransactionStatus)TransactionStatus.ALL.getStatusByCode(String.valueOf(jsonObject.getInt("STATUS"))));
            }
            if (jsonObject.has("VENDOR_TRANS_ID")) {
                result.setVendorTransId(jsonObject.getLong("VENDOR_TRANS_ID"));
            }
            if (jsonObject.has("SIGN_TIME")) {
                result.setSignTime(jsonObject.getLong("SIGN_TIME"));
            }
            if (jsonObject.has("SIGN_STRING")) {
                result.setSignString(jsonObject.getString("SIGN_STRING"));
            }
            if (jsonObject.has("VENDOR_ID")) {
                result.setVendorId(jsonObject.getInt("VENDOR_ID"));
            }
        }
        catch (IllegalArgumentException | JSONException e) {
            throw new AGRException(AGRErrorCode.ERROR_IN_REQUEST_FROM_AGR, "Error in request: " + e.getMessage(), e);
        }
        if (Utils.isBlankString((String)result.getSignString()) || result.getSignTime() == null || result.getSignTime() <= 0L) {
            throw new AGRException(AGRErrorCode.ACTION_NOT_FOUND, "Not enough parameters: SIGN_STRING and/or SIGN_TIME");
        }
        if (Utils.notBlankString((String)action)) {
            switch (result.getAction()) {
                case INFO: {
                    if (!Utils.isBlankString((String)result.getMerchantTransId())) break;
                    throw new AGRException(AGRErrorCode.ACTION_NOT_FOUND, "Not enough parameters");
                }
                case PAY: {
                    if (!Utils.isBlankString((String)result.getAgrTransId()) && result.getVendorId() > 0 && !Utils.isBlankString((String)result.getPaymentName()) && result.getPaymentId() > 0 && !Utils.isBlankString((String)result.getMerchantTransId()) && result.getMerchantTransAmount() != null && result.getMerchantTransAmount().compareTo(BigDecimal.ZERO) > 0 && result.getEnvironment() != null) break;
                    throw new AGRException(AGRErrorCode.ACTION_NOT_FOUND, "Not enough parameters");
                }
                case NOTIFY: {
                    if (!Utils.isBlankString((String)result.getAgrTransId()) && result.getVendorTransId() > 0L && result.getStatus() != null) break;
                    throw new AGRException(AGRErrorCode.ACTION_NOT_FOUND, "Not enough parameters");
                }
                case CANCEL: {
                    if (!Utils.isBlankString((String)result.getAgrTransId()) && result.getVendorTransId() > 0L) break;
                    throw new AGRException(AGRErrorCode.ACTION_NOT_FOUND, "Not enough parameters");
                }
                case STATEMENT: {
                    if (result.getFrom() != null && result.getTo() != null) break;
                    throw new AGRException(AGRErrorCode.ACTION_NOT_FOUND, "Not enough parameters");
                }
                case UNKNOWN: {
                    break;
                }
            }
        }
        logger.debug("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u043f\u0430\u0440\u0441\u0438\u043d\u0433\u0430: {}", (Object)result.toString());
        return result;
    }

    public AGRAction getAction() {
        return this.action;
    }

    public String getMerchantTransId() {
        return this.merchantTransId;
    }

    public Long getSignTime() {
        return this.signTime;
    }

    public String getSignString() {
        return this.signString;
    }

    public String getPaymentName() {
        return this.paymentName;
    }

    public String getAgrTransId() {
        return this.agrTransId;
    }

    public BigDecimal getMerchantTransAmount() {
        return this.merchantTransAmount;
    }

    public AGREnvironment getEnvironment() {
        return this.environment;
    }

    public TransactionStatus getStatus() {
        return this.status;
    }

    public Date getFrom() {
        return this.from;
    }

    public Date getTo() {
        return this.to;
    }

    public long getVendorTransId() {
        return this.vendorTransId;
    }

    public int getPaymentId() {
        return this.paymentId;
    }

    public int getVendorId() {
        return this.vendorId;
    }

    public void setAction(AGRAction action) {
        this.action = action;
    }

    public void setMerchantTransId(String merchantTransId) {
        this.merchantTransId = merchantTransId;
    }

    public void setSignTime(Long signTime) {
        this.signTime = signTime;
    }

    public void setSignString(String signString) {
        this.signString = signString;
    }

    public void setPaymentName(String paymentName) {
        this.paymentName = paymentName;
    }

    public void setAgrTransId(String agrTransId) {
        this.agrTransId = agrTransId;
    }

    public void setMerchantTransAmount(BigDecimal merchantTransAmount) {
        this.merchantTransAmount = merchantTransAmount;
    }

    public void setVendorTransId(long vendorTransId) {
        this.vendorTransId = vendorTransId;
    }

    public void setEnvironment(AGREnvironment environment) {
        this.environment = environment;
    }

    public void setStatus(TransactionStatus status) {
        this.status = status;
    }

    public void setFrom(Date from) {
        this.from = from;
    }

    public void setTo(Date to) {
        this.to = to;
    }

    public void setVendorId(int vendorId) {
        this.vendorId = vendorId;
    }

    public void setPaymentId(int paymentId) {
        this.paymentId = paymentId;
    }

    public String toString() {
        return DebugUtils.dumpObject((Object)((Object)this));
    }
}

