/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.tariff;

import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.kernel.tariff.server.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.bgbilling.modules.voice.server.tariff.VoiceTariffRequest;
import ru.bitel.common.ParameterMap;

public class PrefixPartTariffTreeNode
extends DefaultTariffTreeNode<VoiceTariffRequest, TariffContext> {
    private final Pattern pattern;
    private final int dest;
    private final int zone;

    public PrefixPartTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        Pattern pattern = null;
        String prefix = parameterMap.get("prefix", null);
        if (prefix != null) {
            try {
                pattern = Pattern.compile("^(" + prefix + ")");
            }
            catch (Exception ex) {
                System.err.println("Error prefix compile: " + prefix);
            }
        }
        this.pattern = pattern;
        this.dest = parameterMap.getInt("dest", 0);
        this.zone = parameterMap.getInt("zone", 0);
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace("prefix = {}; pattern = {}", (Object)prefix, (Object)pattern);
            this.getLogger().trace("dest = {}", (Object)this.dest);
            this.getLogger().trace("zone = {}", (Object)this.zone);
        }
    }

    protected int executeImpl(Long treeNodeId, VoiceTariffRequest voiceTariffRequest, TariffContext context) {
        Set prefixAcceptedSet = voiceTariffRequest.getAcceptedSet(PrefixPartTariffTreeNode.class);
        if (voiceTariffRequest.phoneTo != null && this.pattern != null && prefixAcceptedSet.size() == 0) {
            Matcher m;
            String phoneRest = voiceTariffRequest.phoneToRest;
            if (phoneRest == null) {
                phoneRest = voiceTariffRequest.phoneTo;
            }
            if (this.getLogger().isTraceEnabled()) {
                this.getLogger().trace("voiceTariffRequest.phoneToRest = {}", (Object)voiceTariffRequest.phoneToRest);
                this.getLogger().trace("voiceTariffRequest.phoneTo = {}", (Object)voiceTariffRequest.phoneTo);
                this.getLogger().trace("phoneRest => {}", (Object)phoneRest);
            }
            if ((m = this.pattern.matcher(phoneRest)).find()) {
                String eqPart = m.group(0);
                voiceTariffRequest.phoneToRest = phoneRest = phoneRest.substring(eqPart.length());
                if (this.dest > 0) {
                    voiceTariffRequest.destId = this.dest;
                }
                if (this.zone > 0) {
                    voiceTariffRequest.zoneId = this.zone;
                }
                if (this.getLogger().isTraceEnabled()) {
                    this.getLogger().trace("result ( phoneRest => " + voiceTariffRequest.phoneToRest + ", phoneTo => " + voiceTariffRequest.phoneTo + ", dest => " + voiceTariffRequest.destId + ", zoneId => " + voiceTariffRequest.zoneId + " )");
                }
                return 1;
            }
        }
        return 0;
    }

    protected int postExecuteImpl(Long treeNodeId, VoiceTariffRequest req, TariffContext ctx, int executeResult) {
        Set prefixAcceptedSet = req.getAcceptedSet(PrefixPartTariffTreeNode.class);
        if (executeResult == 1) {
            prefixAcceptedSet.add(1L);
        }
        return executeResult;
    }
}

