/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.function;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import ru.bitel.bgbilling.common.BGRuntimeException;
import ru.bitel.common.function.ThrowingSupplier;

public class Lazy<T>
implements Supplier<T>,
Serializable {
    private static final long serialVersionUID = 0L;
    final ThrowingSupplier<T> delegate;
    volatile transient boolean initialized;
    transient T value;

    Lazy(ThrowingSupplier<T> delegate) {
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() throws RuntimeException {
        if (!this.initialized) {
            Lazy lazy = this;
            synchronized (lazy) {
                if (!this.initialized) {
                    try {
                        T t = this.delegate.get();
                        this.value = t;
                        this.initialized = true;
                        return t;
                    }
                    catch (Exception e) {
                        if (e instanceof RuntimeException) {
                            throw (RuntimeException)e;
                        }
                        throw new BGRuntimeException(e);
                    }
                }
            }
        }
        return this.value;
    }

    public String toString() {
        return "Lazy(" + String.valueOf(this.delegate) + ")";
    }

    public static <T> Lazy<T> of(ThrowingSupplier<T> delegate) {
        return delegate instanceof Lazy ? (Lazy<T>)((Object)delegate) : new Lazy<T>(Objects.requireNonNull(delegate));
    }

    public <U> Lazy<U> handle(BiFunction<? super T, Throwable, ? extends U> fn) {
        Objects.requireNonNull(fn);
        return new Lazy<Object>(() -> {
            try {
                T result = this.get();
                return fn.apply((T)result, (Throwable)null);
            }
            catch (Throwable ex) {
                return fn.apply(null, ex);
            }
        });
    }
}

