/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.monitoring.client.admin;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.plugins.monitoring.client.admin.MonitoringLoggingPanel;
import ru.bitel.bgbilling.plugins.monitoring.common.bean.MonitoringComponent;
import ru.bitel.bgbilling.plugins.monitoring.common.service.MonitoringService;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.function.Async;

public class JmxAppsPanel
extends BGUPanel {
    private JPanel managePanel = null;
    private MonitoringLoggingPanel loggingPanel = new MonitoringLoggingPanel();
    private BGUList<MonitoringComponent> jmxAppItemList = new BGUList();

    protected void jbInit() throws Exception {
        BGSplitPaneNoBorder splitPane = new BGSplitPaneNoBorder(1, (Component)this.getAppsListPanel(), (Component)this.getManagePanel(), 400L);
        this.setLayout(new GridBagLayout());
        this.add((Component)splitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    private JPanel getAppsListPanel() {
        this.jmxAppItemList.setCellRenderer((javax.swing.ListCellRenderer)new ListCellRenderer());
        this.jmxAppItemList.setSelectionMode(0);
        BGSwingUtilites.handleLDMouseClicked(this.jmxAppItemList, e -> this.performAction("open"));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0421\u043f\u0438\u0441\u043e\u043a \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0439:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)new JScrollPane((Component)this.jmxAppItemList), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        return panel;
    }

    private JPanel getManagePanel() {
        this.managePanel = new JPanel(new CardLayout());
        this.managePanel.add((Component)new JPanel(), "empty");
        this.managePanel.add((Component)this.getAppsManagePanel(), "manage");
        return this.managePanel;
    }

    private JPanel getAppsManagePanel() {
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add((Component)((Object)this.loggingPanel), "\u041b\u043e\u0433\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435");
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)tabbedPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        return panel;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> Async.of(() -> this.jmxAppItemList.setData(((MonitoringService)((ClientContext)this.getContext()).getWebService(MonitoringService.class)).componentList())));
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
            MonitoringComponent monitoringComponent = (MonitoringComponent)this.jmxAppItemList.getSelectedValue();
            if (monitoringComponent != null) {
                new JmxAppItemEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435", monitoringComponent).open();
            } else {
                ClientUtils.showMessageDialog((Object)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u0438\u0437 \u0441\u043f\u0438\u0441\u043a\u0430");
            }
        });
        new AbstractBGUPanel.DefaultAction("open", "\u041e\u0442\u043a\u0440\u044b\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                MonitoringComponent monitoringComponent = (MonitoringComponent)JmxAppsPanel.this.jmxAppItemList.getSelectedValue();
                if (monitoringComponent != null) {
                    ((CardLayout)JmxAppsPanel.this.managePanel.getLayout()).show(JmxAppsPanel.this.managePanel, "manage");
                    JmxAppsPanel.this.loggingPanel.setMonitoringComponent(monitoringComponent);
                }
            }
        };
    }

    class ListCellRenderer
    extends DefaultListCellRenderer {
        private JPanel panel = null;
        private JLabel id = null;
        private JLabel title = null;
        private JLabel name = null;

        ListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.getPanel();
            this.panel.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            MonitoringComponent component = (MonitoringComponent)value;
            this.id.setText("ID#" + component.getModuleId());
            this.title.setText(component.getTitle());
            this.name.setText(String.valueOf(component.getType()) + ": " + component.getModuleName());
            return this.panel;
        }

        private JPanel getPanel() {
            if (this.panel == null) {
                this.id = new JLabel();
                this.id.setFont(this.id.getFont().deriveFont(this.id.getFont().getSize2D() * 0.9f));
                this.id.setForeground(UIManager.getColor("Label.disabledForeground"));
                this.title = new JLabel();
                this.title.setFont(this.title.getFont().deriveFont(this.title.getFont().getSize2D() * 1.3f));
                this.name = new JLabel();
                this.name.setFont(this.name.getFont().deriveFont(this.name.getFont().getSize2D() * 0.8f));
                this.panel = new JPanel(new GridBagLayout());
                this.panel.add((Component)this.title, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 0, 3), 0, 0));
                this.panel.add((Component)this.id, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 0, 5), 0, 0));
                this.panel.add((Component)this.name, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 5, 5, 5), 0, 0));
            }
            return this.panel;
        }
    }

    class JmxAppItemEditor
    extends BGEditorDialog<MonitoringComponent> {
        private JTextField title;
        private JTextField serviceUrl;
        private JTextField username;
        private JTextField password;

        public JmxAppItemEditor(String title, MonitoringComponent data) {
            super(title, (Object)data);
            this.title = new JTextField(40);
            this.serviceUrl = new JTextField(40);
            this.username = new JTextField(40);
            this.password = new JTextField(40);
        }

        public void doDialogPanel() {
            this.panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
            this.panel.add((Component)this.title, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
            this.panel.add((Component)new JLabel("JMXServiceURL:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 10, 0, 0), 0, 0));
            this.panel.add((Component)this.serviceUrl, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
            this.panel.add((Component)new JLabel("Username:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 10, 0, 0), 0, 0));
            this.panel.add((Component)this.username, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
            this.panel.add((Component)new JLabel("\u041f\u0430\u0440\u043e\u043b\u044c:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 10, 0, 0), 0, 0));
            this.panel.add((Component)this.password, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
            this.title.setText(((MonitoringComponent)this.data).getTitle());
        }

        public boolean doApply() throws Exception {
            ((MonitoringComponent)this.data).setTitle(this.title.getText());
            try {
                JmxAppsPanel.this.performAction("refresh");
                return true;
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
                return false;
            }
        }
    }
}

