<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:import href="layout.xsl"/>

<xsl:template match="/">
	<xsl:call-template name="main">
  		<xsl:with-param name="mode" select="'pub'"/>
  	</xsl:call-template>
</xsl:template>

<xsl:template match="/data/data">
<xsl:choose>
	<xsl:when test="@code = '0'">
		<xsl:call-template name="code_0"/>
	</xsl:when>
	<xsl:when test="@code = '2'">
		<xsl:call-template name="code_2"/>
	</xsl:when>
	<xsl:when test="@code = '3'">
	 	<xsl:call-template name="code_3"/>
	</xsl:when>
	<xsl:when test="@code = '4'">
	 	<xsl:call-template name="code_4"/>
	</xsl:when>	
	<xsl:when test="@code = '14'">
	 	<xsl:call-template name="code_14"/>
	</xsl:when>
	<xsl:when test="@code = '21'">
	 	<xsl:call-template name="code_21"/>
	</xsl:when>
	<xsl:when test="@code = '23'">
	 	<xsl:call-template name="code_23"/>
	</xsl:when>
	<xsl:when test="@code = '24'">
	 	<xsl:call-template name="code_24"/>
	</xsl:when>
	<xsl:when test="@code = '25'">
	 	<xsl:call-template name="code_25"/>
	</xsl:when>
	<xsl:when test="@code = '33'">
	 	<xsl:call-template name="code_33"/>
	</xsl:when>
</xsl:choose>
</xsl:template>

<xsl:template name="code_0">
<h2>ОШИБКА: Таблица reject_to_accept_<xsl:value-of select="@mid" /> не найдена</h2>
</xsl:template>

<xsl:template name="code_2">
<h2>ОШИБКА: Неверный пароль логина</h2>
		<p>Логин найден, но введённый пароль не соответствует его паролю.</p>
		<p>Уважаемый абонент! Пароль указан неправильно, проверьте раскладку ввода языковой панели (EN, отключите CapsLock) и заново наберите пароль</p>
</xsl:template>

<xsl:template name="code_3">
<h2>ОШИБКА: Тарифные планы не найдены</h2>
<p>Уважаемый абонент! У договора не установлен ни один тарифный план для данного модуля на день авторизации. Обратитесь в службу технической поддержки.</p>
</xsl:template>

<xsl:template name="code_4">
<h2>ОШИБКА: Ошибка баланса</h2>
<p>Уважаемый абонент! Ваш баланс равен <xsl:value-of select="../contract/@balance_rest"/>. Пополнить счет можно в ближайшем платежном терминале (при оплате укажите № договора <xsl:value-of select="../contract/@title"/>) или в офисе компании Маглан. Для более подробной информации состояния Вашего счета зайдите на сайт статистики</p>
</xsl:template>

<xsl:template name="code_14">
<h2>ОШИБКА: Логин и карта не найдены</h2>
<p>Не найдены ни логин ни карта по данным пакета.</p>
</xsl:template>

<xsl:template name="code_21">
<h2>ОШИБКА: Превышен лимит сессий</h2>
<p>Уважаемый абонент! У данного логина установлено ограничение на число одновременных сессий. </p>
</xsl:template>

<xsl:template name="code_23">
<h2>ОШИБКА: Запрещён вход в это время</h2>
<p>Уважаемый абонент! У данного логина установлено ограничение по времени входа либо работы.</p>
</xsl:template>

<xsl:template name="code_24">
<h2>ОШИБКА: Превышен лимит услуги</h2>
<p>Уважаемый абонент! У данного логина установлено ограничение по объёму услуги.</p>
</xsl:template>

<xsl:template name="code_25">
<h2>ОШИБКА: Превышен лимит наработки</h2>
<p>Уважаемый абонент! У логина установлено ограничение по денежной наработке.</p>
</xsl:template>

<xsl:template name="code_33">
<h2>ОШИБКА: Договор не активен</h2>
<p>Уважаемый абонент! Статус договора не позволяет авторизовать логин</p>
</xsl:template>

</xsl:stylesheet>