/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.common.event.sa;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.access.Access;
import ru.bitel.bgbilling.apps.inet.access.InetConnectionManager;
import ru.bitel.bgbilling.apps.inet.access.InetConnectionRuntime;
import ru.bitel.bgbilling.apps.inet.access.sa.ServiceActivatorEvent;
import ru.bitel.bgbilling.apps.inet.access.sa.ServiceActivatorEventType;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.EventType;
import ru.bitel.bgbilling.kernel.event.PartitionedQueueEvent;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.inet.common.bean.InetConnection;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.InetServState;
import ru.bitel.bgbilling.modules.inet.common.event.sa.InetSaServModifyEvent;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetApplication;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntimeMap;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServTypeRuntime;
import ru.bitel.common.Utils;
import ru.bitel.common.sql.ConnectionSet;

@EventType(autoAcknowledge=false, timeToLive=432000000L, deliveryMode=1)
@XmlRootElement
public class InetSaOptionsModifyEvent
extends PartitionedQueueEvent {
    private static final transient Logger logger = LogManager.getLogger();
    @XmlAttribute
    private final int deviceId;
    @XmlAttribute
    private final int inetServId;
    @XmlAttribute
    private final long connectionId;
    @XmlAttribute
    private final Set<Integer> options;
    @XmlAttribute
    private Set<Integer> oldOptions;
    @XmlAttribute
    private final boolean force;

    protected InetSaOptionsModifyEvent() {
        this.deviceId = -1;
        this.inetServId = -1;
        this.connectionId = -1L;
        this.options = null;
        this.force = false;
    }

    public InetSaOptionsModifyEvent(int moduleId, int userId, InetConnection connection, Set<Integer> optionSet) {
        this(moduleId, connection.getContractId(), userId, connection.getDeviceId(), connection.getServId(), connection.getId(), optionSet);
    }

    public InetSaOptionsModifyEvent(int moduleId, int userId, InetConnection connection, Set<Integer> optionSet, boolean force) {
        this(moduleId, connection.getContractId(), userId, connection.getDeviceId(), connection.getServId(), connection.getId(), optionSet, force);
    }

    public InetSaOptionsModifyEvent(int moduleId, int userId, InetServ inetServ, Set<Integer> optionSet) {
        this(moduleId, inetServ.getContractId(), userId, inetServ.getDeviceId(), inetServ.getId(), 0L, optionSet);
    }

    public InetSaOptionsModifyEvent(int moduleId, int contractId, int userId, int deviceId, int inetServId, long connectionId, Set<Integer> optionSet) {
        this(moduleId, contractId, userId, deviceId, inetServId, connectionId, optionSet, false);
    }

    public InetSaOptionsModifyEvent(int moduleId, int contractId, int userId, int deviceId, int inetServId, long connectionId, Set<Integer> optionSet, boolean force) {
        super(moduleId, contractId, userId);
        this.deviceId = deviceId;
        this.inetServId = inetServId;
        this.connectionId = connectionId;
        this.options = optionSet;
        this.force = force;
    }

    public void prepareMessage(Message message) throws JMSException {
        super.prepareMessage(message);
        message.setIntProperty("deviceId", this.deviceId);
    }

    public ServiceActivatorEvent toSaEvent(Access access, ConnectionSet connectionSet, boolean manageConnections, InetConnectionManager connectionManager, Date now) throws BGException {
        Set<Integer> oldOptionSet;
        short oldState;
        short newState;
        InetServRuntime inetServRuntime = access.inetServRuntimeMap.get(Integer.valueOf(this.getInetServId()));
        if (inetServRuntime == null) {
            logger.error("InetServ not found with id=" + this.getInetServId());
            return null;
        }
        InetServ inetServ = inetServRuntime.getInetServ();
        Set<Integer> newOptionSet = this.getOptions();
        InetConnectionRuntime connectionRuntime = null;
        InetConnection connection = null;
        if (this.getConnectionId() > 0L) {
            if (!manageConnections) {
                logger.debug("Not manage connections");
                return null;
            }
            newState = InetServState.STATE_ENABLE.getCode();
            connectionRuntime = connectionManager.getByServ(this.getInetServId(), this.getConnectionId());
            InetConnection inetConnection = connection = connectionRuntime != null ? connectionRuntime.connection : null;
            if (connection == null) {
                logger.error("Connection not found with id=" + this.getConnectionId());
                return null;
            }
            oldState = connection.getDeviceState();
            if (inetServ.getParentId() > 0) {
                inetServRuntime = inetServRuntime.getRootInetServRuntime((InetApplication)access);
                inetServ = inetServRuntime.getInetServ();
            }
            oldOptionSet = this.force && this.oldOptions != null ? this.oldOptions : connection.getDeviceOptions();
            if (!this.force && oldOptionSet != null && newOptionSet != null && CollectionUtils.isEqualCollection(oldOptionSet, newOptionSet)) {
                logger.debug("InetConnection deviceOptions already " + String.valueOf(newOptionSet));
                return null;
            }
        } else {
            oldState = newState = inetServ.getDeviceState();
            oldOptionSet = inetServ.getDeviceOptions();
            if (inetServ.getParentId() > 0) {
                logger.error("InetServ is child " + this.inetServId);
                return null;
            }
            if (!this.force && oldOptionSet != null && newOptionSet != null && CollectionUtils.isEqualCollection(oldOptionSet, newOptionSet)) {
                logger.debug("InetServ deviceOptions already " + String.valueOf(newOptionSet));
                return null;
            }
        }
        List childrenServs = ServiceActivatorEvent.getInetServChildren((InetServRuntimeMap)access.getInetServRuntimeMap(), (int)inetServ.getId(), (long)now.getTime());
        inetServ.setChildren(childrenServs);
        ServiceActivatorEvent result = new ServiceActivatorEvent(access, (Event)this, 0, inetServRuntime, ServiceActivatorEventType.SERVICE_MODIFY.getCode(), inetServ.getId(), ((InetServTypeRuntime)inetServRuntime.inetServTypeRef.get()).inetServType, inetServ, inetServ, oldState, newState, oldOptionSet, newOptionSet, 0);
        result.setConnectionRuntime(connectionRuntime);
        if (this.force) {
            result.setConnectionStateModified(false);
            result.setConnectionOptionsModified(false);
        }
        return result;
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public int getInetServId() {
        return this.inetServId;
    }

    public long getConnectionId() {
        return this.connectionId;
    }

    public Set<Integer> getOptions() {
        return this.options;
    }

    public boolean isForce() {
        return this.force;
    }

    protected String getPackageName() {
        return InetSaServModifyEvent.PACKAGE_NAME;
    }

    protected int getPartitionValue() {
        return this.deviceId;
    }

    public Set<Integer> getOldOptions() {
        return this.oldOptions;
    }

    public void setOldOptions(Set<Integer> oldOptions) {
        this.oldOptions = oldOptions;
    }

    protected void toString(StringBuilder sb) {
        sb.append("; deviceId: ");
        sb.append(this.deviceId);
        sb.append("; inetServId: ");
        sb.append(this.inetServId);
        sb.append("; connectionId: ");
        sb.append(this.connectionId);
        sb.append("; options: ");
        sb.append(Utils.toString(this.options));
        sb.append("; oldOptions: ");
        sb.append(Utils.toString(this.oldOptions));
        sb.append("; force: ");
        sb.append(this.force);
    }
}

