/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting.proccess;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.accounting.Accounting;
import ru.bitel.bgbilling.apps.inet.accounting.proccess.ProcessLogTask;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.inet.common.bean.DataProcessRecord;
import ru.bitel.bgbilling.modules.inet.server.bean.DataProcessRecordDao;
import ru.bitel.bgbilling.modules.inet.server.runtime.device.InetDeviceRuntime;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.worker.PeriodicalTaskRunner;

public class InetLogProccessor
extends PeriodicalTaskRunner<ProcessLogTask> {
    protected final int moduleId;
    private InetDeviceRuntime rootDevice = null;
    Logger logger = LogManager.getLogger();

    public InetLogProccessor(Setup setup, int threadCount, long initialDelay, long delay, Accounting accounting) {
        super(setup, threadCount, initialDelay, delay, accounting.moduleId, "process-log");
        this.moduleId = accounting.moduleId;
        this.rootDevice = accounting.deviceMap.get(accounting.rootDeviceId);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected List<ProcessLogTask> readTasks() throws BGException {
        try (ConnectionSet connectionSet = ConnectionSet.newInstance((DefaultServerSetup)this.setup, (boolean)true);){
            ArrayList<ProcessLogTask> arrayList;
            block15: {
                Connection con = connectionSet.getConnection();
                try {
                    DataProcessRecordDao dao = new DataProcessRecordDao(con, this.moduleId);
                    ArrayList<ProcessLogTask> result = new ArrayList<ProcessLogTask>();
                    List<Object> dataList = new ArrayList();
                    Date startTime = new Date();
                    HashSet<Integer> descendantIds = new HashSet<Integer>(this.rootDevice.descendantIds);
                    descendantIds.add(this.rootDevice.inetDeviceId);
                    dataList = dao.list(1, descendantIds);
                    for (DataProcessRecord dataProcessRecord : dataList) {
                        dataProcessRecord.setStartTime(startTime);
                        dao.update(dataProcessRecord);
                        result.add(new ProcessLogTask(dataProcessRecord, this.setup, this.moduleId, this.rootDevice.inetDeviceId));
                    }
                    arrayList = result;
                    if (con == null) break block15;
                }
                catch (Throwable throwable) {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                con.close();
            }
            return arrayList;
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }
}

