/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.npay.server.bean.quantity;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;

public abstract class ModuleQuantity {
    private int moduleId;
    private List<Integer> sids;

    public List<Integer> getSids() {
        return this.sids;
    }

    public void setSids(List<Integer> sids) {
        this.sids = sids;
    }

    public int getModuleId() {
        return this.moduleId;
    }

    public void setModuleId(int moduleId) {
        this.moduleId = moduleId;
    }

    public abstract List<ModuleQuantityResult> getPeriodQuantity(Connection var1, int var2, Calendar var3, Calendar var4);

    protected List<ModuleQuantityResult> getPeriodsFromTable(Connection con, String tableName, int contractId, Calendar from, Calendar to, String filter) {
        return this.getPeriodsFromTable(con, tableName, contractId, from, to, filter, "cid", "date1", "date2");
    }

    protected List<ModuleQuantityResult> getPeriodsFromTable(Connection con, String tableName, int contractId, Calendar from, Calendar to, String filter, String fieldContractId, String fieldDate1, String fieldDate2) {
        ArrayList<ModuleQuantityResult> result = new ArrayList<ModuleQuantityResult>();
        if (ServerUtils.tableExists((Connection)con, (String)tableName)) {
            Object query = this.getQuery(tableName, fieldContractId, fieldDate1, fieldDate2);
            if (Utils.notBlankString((String)filter)) {
                query = (String)query + filter;
            }
            try (PreparedStatement ps = con.prepareStatement((String)query);){
                ps.setInt(1, contractId);
                ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)to));
                ps.setDate(3, TimeUtils.convertCalendarToSqlDate((Calendar)from));
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    result.add(this.getModuleQuantityResult(rs));
                }
                rs.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    protected String getQuery(String tableName, String fieldContractId, String fieldDate1, String fieldDate2) {
        return "SELECT " + this.getQuerySelect(fieldDate1, fieldDate2) + " FROM " + tableName + this.getQueryJoin() + " WHERE " + fieldContractId + "=? AND (" + fieldDate1 + " IS NULL OR " + fieldDate1 + "<=?) AND (" + fieldDate2 + " IS NULL OR " + fieldDate2 + ">=?)";
    }

    protected String getQuerySelect(String fieldDate1, String fieldDate2) {
        return fieldDate1 + ", " + fieldDate2;
    }

    protected String getQueryJoin() {
        return "";
    }

    protected ModuleQuantityResult getModuleQuantityResult(ResultSet rs) throws SQLException {
        return new ModuleQuantityResult(this, new Period((Date)rs.getDate(1), (Date)rs.getDate(2)), 1);
    }

    public class ModuleQuantityResult {
        private Period period = null;
        private int count = 1;

        public ModuleQuantityResult(ModuleQuantity this$0, Period period, int count) {
            this.period = period;
            this.count = count;
        }

        public Period getPeriod() {
            return this.period;
        }

        public int getCount() {
            return this.count;
        }
    }
}

