/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.shop.server.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.shop.common.bean.StockItemAttributeKit;
import ru.bitel.bgbilling.plugins.shop.common.bean.StockItemType;
import ru.bitel.bgbilling.plugins.shop.server.dao.StockItemAttributeKitDao;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractIdDao;

public class StockItemTypeDao
extends AbstractIdDao<StockItemType> {
    private final StockItemAttributeKitDao attributeKitDao;

    public StockItemTypeDao(Connection con, int moduleId) {
        super(con, moduleId, "stock_item_type");
        this.attributeKitDao = new StockItemAttributeKitDao(con, moduleId);
    }

    protected StockItemType getFromRS(ResultSet rs) throws SQLException, BGException {
        StockItemType stockItemType = new StockItemType();
        stockItemType.setId(rs.getInt("id"));
        stockItemType.setTitle(rs.getString("title"));
        stockItemType.setParentTypeId(rs.getInt("parent_type_id"));
        stockItemType.setAttributeKit((StockItemAttributeKit)this.attributeKitDao.get(rs.getInt("stock_item_attribute_kit")));
        return stockItemType;
    }

    protected void updateImpl(StockItemType stockItemType) throws BGException, SQLException {
        boolean isNew = stockItemType.getId() <= 0;
        String prefix = isNew ? "INSERT INTO " : "UPDATE ";
        String query = prefix + this.tableName + " SET title=?, stock_item_attribute_kit=?, parent_type_id=?" + (isNew ? "" : " WHERE id=?");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            ps.setString(1, stockItemType.getTitle());
            ps.setInt(2, stockItemType.getAttributeKit() == null ? 0 : stockItemType.getAttributeKit().getId());
            ps.setInt(3, stockItemType.getParentTypeId());
            if (!isNew) {
                ps.setInt(4, stockItemType.getId());
            }
            ps.executeUpdate();
            if (isNew) {
                stockItemType.setId(ServerUtils.lastInsertId((Connection)this.con));
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public List<StockItemType> getList() throws BGException {
        ArrayList<StockItemType> result = new ArrayList<StockItemType>();
        try (Statement statement = this.con.createStatement();
             ResultSet rs = statement.executeQuery("SELECT * FROM " + this.tableName);){
            while (rs.next()) {
                result.add(this.getFromRS(rs));
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public List<StockItemType> getStockItemTypesByWarehouse(int warehouseId) throws BGException {
        ArrayList<StockItemType> result = new ArrayList<StockItemType>();
        try (PreparedStatement ps = this.con.prepareStatement("SELECT * FROM stock_item_type WHERE id IN( SELECT stock_item_type_id FROM stock_item WHERE warehouse_id=? GROUP BY stock_item_type_id )");){
            ps.setInt(1, warehouseId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getFromRS(rs));
                }
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }
}

