/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.server.upload.bastion;

import bitel.billing.server.contract.bean.Contract;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.sorm.common.UploadModulesTitle;
import ru.bitel.bgbilling.modules.sorm.common.bean.SormProject;
import ru.bitel.bgbilling.modules.sorm.common.upload.bastion.BastionPaymentType;
import ru.bitel.bgbilling.modules.sorm.common.upload.mfisoft.MfiSoftPaymentType;
import ru.bitel.bgbilling.modules.sorm.server.bean.DialUpLogin;
import ru.bitel.bgbilling.modules.sorm.server.bean.SormCSVWriter;
import ru.bitel.bgbilling.modules.sorm.server.upload.Upload;
import ru.bitel.bgbilling.modules.sorm.server.upload.bastion.BastionFileTitle;
import ru.bitel.bgbilling.modules.sorm.server.utils.SormUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Pair;
import ru.bitel.oss.kernel.entity.common.bean.AddressStruct;

public class BastionUpload
extends Upload {
    private static final Logger logger = LogManager.getLogger((String)BastionUpload.class.getSimpleName());
    private String REGION_ID;

    public BastionUpload(int moduleId, SormProject sormProject, boolean isFullUpload) {
        super(moduleId, sormProject, isFullUpload);
        this.REGION_ID = Utils.maskBlank((String)this.config.get("sorm.upload.regionid"), (String)"1");
    }

    @Override
    public Path abonents() {
        logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430");
        Path file = SormUtils.getUploadFile(this.localUserPath, this.REGION_ID + "_" + BastionFileTitle.ABONENTS.getTitle(), "%s_%tY%tm%td_%tH%tM.txt");
        try (SormCSVWriter csvFile = SormUtils.getCSVFile(file, '\u0000');){
            Contract contract;
            csvFile.writeNext(new String[]{"REGION_ID", "ACTUAL_FROM", "ACTUAL_TO", "CONTRACT_DATE", "ACCOUNT", "CONTRACT", "BANK", "BANK_ACCOUNT", "UNSTRUCT_NAME", "BIRTH_DATE", "IDENT_CARD_TYPE_ID", "IDENT_CARD_UNSTRUCT", "FULL_NAME", "INN", "CONTACT", "PHONE_FAX", "MAC", "IPV4", "IPV4_MASK", "LOGIN", "E_MAIL", "PHONE", "A_UNSTRUCT_INFO", "H_UNSTRUCT_INFO"});
            if (this.checkInstalledModule(UploadModulesTitle.INET)) {
                List<InetServ> services = SormUtils.getInetServices(this.config, this.serverContext, this.contracts);
                if (logger.isDebugEnabled()) {
                    logger.debug("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u043b\u043e\u0433\u0438\u043d\u043e\u0432 \u0434\u043b\u044f \u043c\u043e\u0434\u0443\u043b\u044f Inet. \u0412\u0441\u0435\u0433\u043e \u0432 \u0441\u043f\u0438\u0441\u043a\u0435 InetServ: " + services.size() + " \n\u0412\u0441\u0435\u0433\u043e \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432: " + this.contracts.size());
                }
                for (InetServ service : services) {
                    contract = this.contractManager.getContractById(service.getContractId());
                    this.helper.setCurrentContract(contract);
                    byte[] addressFrom = service.getAddressFrom();
                    InetAddress inetAddress = null;
                    if (addressFrom != null) {
                        inetAddress = InetAddress.getByAddress(addressFrom);
                    }
                    String ipv4 = inetAddress != null ? inetAddress.getHostAddress() : "";
                    byte[] mac = service.getMacAddressListBytes();
                    String macStr = mac != null && mac.length > 0 ? Utils.bytesToString((byte[])mac) : "";
                    String[] item = this.getLoginItem(contract, service.getDateFrom(), service.getDateTo(), ipv4, macStr, service.getLogin(), null);
                    csvFile.writeNext(item);
                }
            }
            if (this.checkInstalledModule(UploadModulesTitle.DIAL_UP)) {
                List<DialUpLogin> logins = SormUtils.getDialUpLogins(this.serverContext, this.config, this.contracts);
                if (logger.isDebugEnabled()) {
                    logger.debug("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u043b\u043e\u0433\u0438\u043d\u043e\u0432 \u0434\u043b\u044f \u043c\u043e\u0434\u0443\u043b\u044f DialUp. \u0412\u0441\u0435\u0433\u043e \u043b\u043e\u0433\u0438\u043d\u043e\u0432 \u0432 \u0441\u043f\u0438\u0441\u043a\u0435: " + logins.size());
                }
                for (DialUpLogin login : logins) {
                    contract = this.contractManager.getContractById(login.getCid());
                    this.helper.setCurrentContract(contract);
                    csvFile.writeNext(this.getLoginItem(contract, login.getDateFrom(), login.getDateTo(), login.getIpv4(), null, login.getLogin(), null));
                }
            }
        }
        catch (Exception ex) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432: ";
            logger.error(text + String.valueOf(ex));
            SormUtils.sendErrorToEmail(Setup.getSetup(), ex, text);
        }
        logger.info("\u0417\u0430\u043a\u043e\u043d\u0447\u0435\u043d\u0430 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430");
        return file;
    }

    private String[] getLoginItem(Contract contract, Date dateFrom, Date dateTo, String ipv4, String mac, String login, String phone) throws BGException {
        boolean isFiz = contract.getFc() == 0;
        String[] item = new String[24];
        item[0] = this.REGION_ID;
        item[1] = dateFrom != null ? TimeUtils.format((Date)dateFrom, (String)"yyyy-MM-dd HH:mm:ss") : "";
        item[2] = dateTo != null ? TimeUtils.format((Date)dateTo, (String)"yyyy-MM-dd HH:mm:ss") : "";
        item[3] = contract.getDateFrom() != null ? TimeUtils.format((Date)contract.getDateFrom(), (String)"yyyy-MM-dd HH:mm:ss") : "";
        item[4] = Utils.maskBlank((String)contract.getTitle(), (String)"");
        item[5] = Utils.maskBlank((String)contract.getTitle(), (String)"");
        if (isFiz) {
            item[6] = "";
            item[7] = "";
            Object unstructFio = this.helper.getStringParam("sorm.upload.fiz.unstructfio");
            if (Utils.isBlankString((String)unstructFio)) {
                String lastName = this.helper.getStringParam("sorm.upload.fiz.lastname");
                String firstName = this.helper.getStringParam("sorm.upload.fiz.firstname");
                String middlename = this.helper.getStringParam("sorm.upload.fiz.middlename");
                unstructFio = lastName + " " + firstName + " " + middlename;
            }
            item[8] = Utils.maskBlank((String)unstructFio, (String)"");
            item[9] = this.helper.getDateParam("sorm.upload.fiz.birthday", "yyyy-MM-dd HH:mm:ss");
            String documentType = "";
            try (ContractDao contractDao = new ContractDao(this.con, 0);){
                documentType = contractDao.getContractParameterListAsString(contract.getId(), this.config.getInt("sorm.upload.documenttype", -1)).orElse("");
            }
            catch (BGException e) {
                logger.info("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043f\u044b\u0442\u043a\u0435 \u0432\u0437\u044f\u0442\u044c \u0442\u0438\u043f \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430. " + e.getMessage());
            }
            item[10] = documentType;
            Object documentUnstruct = this.helper.getStringParam("sorm.upload.fiz.documentunstruct");
            if (Utils.isBlankString((String)documentUnstruct)) {
                String serial = this.helper.getStringParam("sorm.upload.fiz.documentserial");
                String number = this.helper.getStringParam("sorm.upload.fiz.documentnumber");
                String whoGive = this.helper.getStringParam("sorm.upload.fiz.documentwhogive");
                String whenGive = this.helper.getDateParam("sorm.upload.fiz.documentwhengive", "dd.MM.yyyy");
                documentUnstruct = serial + " " + number + " " + whoGive + " " + whenGive;
            }
            item[11] = Utils.maskBlank((String)documentUnstruct, (String)"");
            item[12] = "";
            item[13] = "";
            item[14] = "";
            item[15] = "";
        } else {
            item[6] = this.helper.getBankTitle();
            item[7] = this.helper.getBankAccount();
            item[8] = "";
            item[9] = "";
            item[10] = "";
            item[11] = "";
            item[12] = this.helper.getFullTitleOrg();
            item[13] = this.helper.getINN();
            item[14] = this.helper.getStringParam("sorm.upload.org.contactface");
            item[15] = this.helper.getContactFacePhone().replaceAll(";", ",");
        }
        item[16] = Utils.maskBlank((String)mac, (String)"").replaceAll(" ", "");
        item[17] = Utils.maskBlank((String)ipv4, (String)"");
        item[18] = "";
        item[19] = login;
        item[20] = this.helper.getEmail(isFiz);
        item[21] = Utils.maskBlank((String)phone, (String)"");
        AddressStruct addressStruct = this.helper.getAddress();
        item[22] = addressStruct != null ? addressStruct.getFullAddress() : this.helper.getUnstructAddress();
        addressStruct = this.helper.getCommutatorsAddress();
        item[23] = addressStruct != null ? addressStruct.getFullAddress() : this.helper.getUnstructCommutatorsAddress();
        return item;
    }

    @Override
    public Path abonentsAddresses() {
        return null;
    }

    @Override
    public Path abonentLogins() {
        return null;
    }

    @Override
    public Path services() {
        return null;
    }

    @Override
    public Path abonentServices() {
        return null;
    }

    @Override
    public Path ipNumbering() {
        return null;
    }

    @Override
    public Path abonentsIpNumbering() {
        return null;
    }

    @Override
    public Path switches() {
        return null;
    }

    @Override
    public Path gateways() {
        return null;
    }

    @Override
    public Path bunches() {
        return null;
    }

    @Override
    public Path phoneNumbering() {
        return null;
    }

    @Override
    public Path phoneNumberingAbonents() {
        return null;
    }

    @Override
    public Path documentTypes() {
        return null;
    }

    @Override
    public Path paymentTypes() {
        return null;
    }

    @Override
    public Path abonentsPayments() {
        logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432");
        Path file = SormUtils.getUploadFile(this.localUserPath, this.REGION_ID + "_" + BastionFileTitle.PAYMENTS.getTitle(), "%s_%tY%tm%td_%tH%tM.txt");
        try (SormCSVWriter csvFile = SormUtils.getCSVFile(file, '\u0000');){
            csvFile.writeNext(new String[]{"PAYMENT_TYPE", "PAY_TYPE_ID", "PAYMENT_DATE", "AMOUNT", "AMOUNT_CURRENCY", "PHONE_NUMBER", "ACCOUNT", "BANK_ACCOUNT", "BANK_NAME", "EXPRESS_CARD_NUMBER", "TERMINAL_ID", "TERMINAL_NUMBER", "CENTER_ID", "CARD_NUMBER", "PAY_PARAMS", "A_UNSTRUCT_INFO", "REGION_ID"});
            List<Payment> payments = this.paymentsToUpload.getPaymentsToUpload(true);
            logger.debug("\u0412\u0441\u0435\u0433\u043e \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439 \u0434\u043b\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438: " + payments.size());
            for (Payment payment : payments) {
                try {
                    Contract contract = this.contractManager.getContractById(payment.getContractId());
                    if (contract == null) continue;
                    this.helper.setCurrentContract(contract);
                    boolean isFiz = contract.getFc() == 0;
                    String paymentType = this.paymentsToUpload.getPaymentTypeCode(payment.getTypeId());
                    boolean isNeedAddress = paymentType.equals(MfiSoftPaymentType.BANK_TRANSACTION.getCodeStr()) || paymentType.equals(MfiSoftPaymentType.TERMINAL_PAYMENT.getCodeStr()) || paymentType.equals(MfiSoftPaymentType.CLIENT_CENTER.getCodeStr());
                    String[] item = new String[17];
                    item[0] = paymentType;
                    item[1] = String.valueOf(payment.getTypeId());
                    item[2] = TimeUtils.format((Date)payment.getDate(), (String)"yyyy-MM-dd HH:mm:ss");
                    item[3] = Utils.formatBigDecimalSumm((BigDecimal)payment.getSum());
                    item[4] = "";
                    String phoneNumber = isFiz ? this.helper.getPhoneParam("sorm.upload.fiz.phone") : this.helper.getPhoneParam("sorm.upload.org.phone");
                    item[5] = Utils.maskBlank((String)phoneNumber, (String)"");
                    item[6] = contract.getTitle();
                    if (!isFiz && paymentType.equals(MfiSoftPaymentType.BANK_TRANSACTION.getCodeStr())) {
                        item[7] = this.helper.getBankAccount();
                        item[8] = this.helper.getBankTitle();
                    } else {
                        item[7] = "";
                        item[8] = "";
                    }
                    item[9] = "";
                    item[10] = paymentType.equals(BastionPaymentType.TERMINAL_PAYMENT.getCodeStr()) ? "0" : "";
                    item[11] = paymentType.equals(BastionPaymentType.TERMINAL_PAYMENT.getCodeStr()) ? "0" : "";
                    item[12] = "";
                    item[13] = "";
                    item[14] = Utils.maskBlank((String)payment.getComment(), (String)"").replaceAll(";", ",");
                    AddressStruct address = this.helper.getAddress();
                    item[15] = isNeedAddress && address != null ? Utils.maskBlank((String)this.helper.getUnstructAddress(), (String)"") : "";
                    item[16] = this.REGION_ID;
                    csvFile.writeNext(item);
                }
                catch (Exception e) {
                    logger.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0430: " + String.valueOf(e));
                }
            }
        }
        catch (Exception ex) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432: ";
            logger.error(text + String.valueOf(ex));
            SormUtils.sendErrorToEmail(Setup.getSetup(), ex, text);
        }
        logger.info("\u0417\u0430\u043a\u043e\u043d\u0447\u0435\u043d\u0430 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432");
        return file;
    }

    @Override
    public Path operatorInfo() {
        return null;
    }

    @Override
    public List<Pair<String, Path>> getOtherFiles() {
        return Collections.emptyList();
    }
}

