<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
      xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
      xmlns:fo="http://www.w3.org/1999/XSL/Format">
  <xsl:output method="xml" indent="yes"/>
  <xsl:template match="data">
    <fo:root>
      <fo:layout-master-set>
        <fo:simple-page-master master-name="A4-portrait"
              page-height="29.7cm" page-width="21.0cm" margin="2cm">
          <fo:region-body/>
        </fo:simple-page-master>
      </fo:layout-master-set>
      <fo:page-sequence master-reference="A4-portrait">
        <fo:flow flow-name="xsl-region-body">
          <fo:block>[Чек]</fo:block>


          <fo:table table-layout="fixed">
            <fo:table-column column-width="6cm"  />
			<fo:table-column column-width="3cm"  />
				
			<fo:table-header>
			  <fo:table-row>	
			    <fo:table-cell>
				  <fo:block>наименование</fo:block>
				</fo:table-cell>
				<fo:table-cell>
				  <fo:block>сумма</fo:block>
				</fo:table-cell>
			  </fo:table-row>
			</fo:table-header>
			
            <fo:table-body>
              <xsl:for-each select="line">
                <fo:table-row>
                
                  <xsl:choose>
                  	<xsl:when test="@summ">
                  	  <!-- если есть сумма, то это строка с названием и суммой -->
                  	  <fo:table-cell>
                        <fo:block><xsl:value-of select="@text"/></fo:block>
                      </fo:table-cell>
                      <fo:table-cell>
                        <fo:block><xsl:value-of select="@summ"/></fo:block>
                      </fo:table-cell>
                  	</xsl:when>
                  	<xsl:otherwise>
                  	  <!-- если нет суммы, то это строка просто с текстом -->
                  	  <fo:table-cell>
                        <fo:block><xsl:value-of select="@text"/></fo:block>
                      </fo:table-cell>
                      <fo:table-cell><fo:block/></fo:table-cell>
                  	</xsl:otherwise>
                  </xsl:choose>                  
                  
				</fo:table-row>
              </xsl:for-each>
            </fo:table-body>
          </fo:table>


          <fo:block>Итого: <xsl:value-of select="@summa"/></fo:block>
          <fo:block>Внесено: <xsl:value-of select="@clientsumma"/></fo:block>
          <xsl:variable name="substract" select="number(@clientsumma)-number(@summa)"/>
          <fo:block>Сдача: <xsl:value-of select="$substract"/></fo:block>
        </fo:flow>
      </fo:page-sequence>
    </fo:root>
  </xsl:template>
</xsl:stylesheet>