/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.radius.nas;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntime;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntimeMap;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttribute;
import ru.bitel.bgbilling.kernel.network.radius.RadiusListenerWorker;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.bgbilling.kernel.network.radius.nas.Nas;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.sql.ConnectionSet;

public class RadiusFanout
extends Thread {
    private static final Logger logger = LogManager.getLogger();
    private final Setup setup = Setup.getSetup();
    private final BlockingQueue<Entry> queue;
    private final Nas<?, ?, ?> nas;
    private final byte[] secret;
    private final String accountingRequestHost;
    private final int accountingRequestPort;
    private final int accountingRequestSourcePort;
    private final DatagramChannel accountingRequestChannel;
    private final InetSocketAddress accountingRequestAddress;
    private String accountingResponseHost;
    private int accountingResponsePort;
    private int accountingResponseSourcePort;
    private DatagramChannel accountingResponseChannel;
    private InetSocketAddress accountingResponseAddress;
    private String accessResponseHost;
    private int accessResponsePort;
    private int accessResponseSourcePort;
    private DatagramChannel accessResponseChannel;
    private InetSocketAddress accessResponseAddress;
    private String accessRequestHost;
    private int accessRequestPort;
    private int accessRequestSourcePort;
    private DatagramChannel accessRequestChannel;
    private InetSocketAddress accessRequestAddress;
    private final String userNamePrefix;
    private final String userNameSuffix;
    private final String userNamePattern;
    private final boolean needWrapUsername;
    private volatile boolean working;

    public RadiusFanout(Nas<?, ?, ?> nas, ParameterMap config) {
        super("RadiusFanout-" + nas.getId());
        this.queue = new ArrayBlockingQueue<Entry>(config.getInt("radius.forward.maxQueueSize", 500));
        this.nas = nas;
        this.secret = config.get("radius.forward.secret", config.get("packet.forward.secret", new String(nas.getSecret()))).getBytes();
        this.accountingRequestHost = config.get("radius.forward.accounting.request.host", config.get("radius.forward.host", config.get("packet.forward.host", null)));
        this.accountingRequestPort = config.getInt("radius.forward.accounting.request.port", config.getInt("radius.forward.port", config.getInt("packet.forward.port", 1813)));
        this.accountingRequestSourcePort = config.getInt("radius.forward.accounting.request.source.port", config.getInt("radius.forward.source.port", config.getInt("packet.forward.port.source", -1)));
        this.accountingResponseHost = config.get("radius.forward.accounting.response.host", null);
        this.accountingResponsePort = config.getInt("radius.forward.accounting.response.port", 0);
        this.accountingResponseSourcePort = config.getInt("radius.forward.accounting.response.source.port", -1);
        this.accessRequestHost = config.get("radius.forward.access.request.host", null);
        this.accessRequestPort = config.getInt("radius.forward.access.request.port", 0);
        this.accessRequestSourcePort = config.getInt("radius.forward.access.request.source.port", -1);
        this.accessResponseHost = config.get("radius.forward.access.response.host", config.get("radius.answer.forward.host", null));
        this.accessResponsePort = config.getInt("radius.forward.access.response.port", config.getInt("radius.answer.forward.port", 0));
        this.accessResponseSourcePort = config.getInt("radius.forward.access.response.source.port", config.getInt("radius.answer.forward.source.port", -1));
        this.userNamePrefix = config.get("radius.forward.user.name.prefix", config.get("packet.forward.user.name.prefix", null));
        this.userNameSuffix = config.get("radius.forward.user.name.suffix", config.get("packet.forward.user.name.suffix", null));
        this.userNamePattern = config.get("radius.forward.user.name.pattern", "").trim();
        this.needWrapUsername = Utils.notBlankString(this.userNamePattern);
        DatagramChannel channel = null;
        InetSocketAddress socketAddress = null;
        if (Utils.notBlankString(this.accountingRequestHost)) {
            try {
                channel = this.createChannel(this.accountingRequestSourcePort);
                socketAddress = new InetSocketAddress(InetAddress.getByName(this.accountingRequestHost), this.accountingRequestPort);
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format("Creating socket for accounting requests to %s:%d", this.accountingRequestHost, this.accountingRequestPort));
                }
                this.working = true;
                this.start();
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            this.accountingRequestChannel = channel;
            this.accountingRequestAddress = socketAddress;
            try {
                if (Utils.notBlankString(this.accountingResponseHost)) {
                    this.accountingResponseChannel = this.createChannel(this.accountingResponseSourcePort);
                    this.accountingResponseAddress = new InetSocketAddress(InetAddress.getByName(this.accountingResponseHost), this.accountingResponsePort);
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.format("Creating socket for accounting responses to %s:%d", this.accountingResponseHost, this.accountingResponsePort));
                    }
                }
                if (Utils.notBlankString(this.accessRequestHost)) {
                    this.accessRequestChannel = this.createChannel(this.accessRequestSourcePort);
                    this.accessRequestAddress = new InetSocketAddress(InetAddress.getByName(this.accessRequestHost), this.accessRequestPort);
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.format("Creating socket for access request to %s:%d", this.accessRequestHost, this.accessRequestPort));
                    }
                }
                if (Utils.notBlankString(this.accessResponseHost)) {
                    this.accessResponseChannel = this.createChannel(this.accessResponseSourcePort);
                    this.accessResponseAddress = new InetSocketAddress(InetAddress.getByName(this.accessResponseHost), this.accessResponsePort);
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.format("Creating socket for access responses to %s:%d", this.accessResponseHost, this.accessResponsePort));
                    }
                }
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        } else {
            this.working = false;
            this.accountingRequestChannel = null;
            this.accountingRequestAddress = null;
        }
    }

    private DatagramChannel createChannel(int sourcePort) throws IOException {
        DatagramChannel result = DatagramChannel.open();
        result.socket().setSendBufferSize(262144);
        result.socket().setBroadcast(true);
        result.configureBlocking(false);
        if (sourcePort > 0) {
            result.socket().setReuseAddress(true);
            result.socket().bind(new InetSocketAddress(sourcePort));
        }
        return result;
    }

    public boolean isWorking() {
        return this.working;
    }

    public void fanout(RadiusListenerWorker<?> req, RadiusPacket packet, int accountId) {
        if (this.working && !this.queue.offer(new Entry(packet.clone(), req.getContractId(), accountId))) {
            logger.error("Packet fanout queue is too large, skipping adding packet. Nas: " + String.valueOf(this.nas));
        }
    }

    @Override
    public void run() {
        try (ConnectionSet connectionSet = ConnectionSet.newInstance((DefaultServerSetup)this.setup, true);){
            logger.info("Starting Radius Packet Forwarder");
            logger.info(String.format("Accounting request host = %s \nAccounting request port = %d \n Accounting request source port = %d \nAccounting response host = %s \nAccounting response port = %d \n Accounting response source port = %d \nAccess request host = %s \nAccess request port = %d \n Access request source port = %d \nAccess response host = %s \nAccess response port = %d \n Access response source port = %d \nSecret = %s\nUserName prefix=%s\nUserName suffix = %s\nUserName pattern = %s\nQueue maximum size = %s", this.accountingRequestHost, this.accountingRequestPort, this.accountingRequestSourcePort, this.accountingResponseHost, this.accountingResponsePort, this.accountingResponseSourcePort, this.accessRequestHost, this.accessRequestPort, this.accessRequestSourcePort, this.accessResponseHost, this.accessResponsePort, this.accessResponseSourcePort, new String(this.secret, "ISO8859-1"), this.userNamePrefix, this.userNameSuffix, this.userNamePattern, this.queue.size()));
            while (this.working) {
                this.runImpl(connectionSet);
            }
            this.runImpl(connectionSet);
            this.accountingRequestChannel.close();
            if (this.accountingResponseChannel != null) {
                this.accountingResponseChannel.close();
            }
            if (this.accessRequestChannel != null) {
                this.accessRequestChannel.close();
            }
            if (this.accessResponseChannel != null) {
                this.accessResponseChannel.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.working = false;
        }
    }

    private void runImpl(ConnectionSet connectionSet) {
        try {
            ContractRuntimeMap contractRuntimeMap = ContractRuntimeMap.getInstance();
            Entry entry = this.queue.poll(500L, TimeUnit.MILLISECONDS);
            while (entry != null) {
                RadiusPacket packet = entry.packet;
                if (packet.isRequest()) {
                    if (this.needWrapUsername) {
                        Object name;
                        ContractRuntime contractRuntime = contractRuntimeMap.getContractRuntime(connectionSet, (Integer)entry.contractId);
                        if (contractRuntime != null) {
                            switch (this.userNamePattern) {
                                case "$contractTitle": {
                                    name = contractRuntime.getContractTitle();
                                    break;
                                }
                                case "$contractId": {
                                    name = String.valueOf(contractRuntime.contractId);
                                    break;
                                }
                                case "$accountId": 
                                case "$servId": {
                                    name = String.valueOf(entry.accountId);
                                    break;
                                }
                                case "$contractId_$servId": {
                                    name = contractRuntime.contractId + "_" + entry.accountId;
                                    break;
                                }
                                default: {
                                    name = null;
                                }
                            }
                            if (name == null) {
                                logger.warn("ContractRuntime:" + entry.contractId + " found but option 'radius.forward.user.name.pattern' not specified in config");
                            }
                        } else {
                            name = null;
                            if (entry.contractId > 0) {
                                logger.warn("ContractRuntime:" + entry.contractId + " not found");
                            }
                        }
                        if (name == null) {
                            this.convert(packet);
                        } else {
                            if (Utils.notEmptyString(this.userNamePrefix)) {
                                name = Utils.notEmptyString(this.userNameSuffix) ? this.userNamePrefix + (String)name + this.userNameSuffix : this.userNamePrefix + (String)name;
                            } else if (Utils.notEmptyString(this.userNameSuffix)) {
                                name = (String)name + this.userNameSuffix;
                            }
                            packet.setAttribute(new RadiusAttribute.RadiusAttributeString(-1, 1, (String)name));
                        }
                    } else {
                        this.convert(packet);
                    }
                }
                ByteBuffer bb = ByteBuffer.allocate(4096);
                packet.write(bb, this.secret);
                bb.flip();
                switch (packet.getCode()) {
                    case 1: {
                        this.accessRequestChannel.send(bb, this.accessRequestAddress);
                        break;
                    }
                    case 4: {
                        this.accountingRequestChannel.send(bb, this.accountingRequestAddress);
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.accessResponseChannel.send(bb, this.accessResponseAddress);
                        break;
                    }
                    case 5: {
                        this.accountingResponseChannel.send(bb, this.accountingResponseAddress);
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug(packet.getPacketTypeString() + " packet forwarded: \n" + packet.toString());
                }
                entry = (Entry)this.queue.poll();
            }
            connectionSet.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void convert(RadiusPacket packet) {
        RadiusAttribute.RadiusAttributeString attr;
        if ((Utils.notBlankString(this.userNamePrefix) || Utils.notBlankString(this.userNameSuffix)) && (attr = (RadiusAttribute.RadiusAttributeString)packet.getAttribute(-1, 1)) != null) {
            Object name = (String)attr.getValue();
            if (Utils.notBlankString(this.userNamePrefix)) {
                name = this.userNamePrefix + (String)name;
            }
            if (Utils.notBlankString(this.userNameSuffix)) {
                name = (String)name + this.userNameSuffix;
            }
            packet.setAttribute(new RadiusAttribute.RadiusAttributeString(-1, 1, (String)name));
        }
    }

    public void shutdown() {
        this.working = false;
    }

    static final class Entry {
        final RadiusPacket packet;
        final int contractId;
        final int accountId;

        Entry(RadiusPacket packet, int contractId, int accountId) {
            this.packet = packet;
            this.contractId = contractId;
            this.accountId = accountId;
        }
    }
}

