/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.datalog.netflow;

import java.nio.ByteBuffer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.base.server.datalog.BGDataLogReader;
import ru.bitel.bgbilling.kernel.network.datalog.FlowReader;
import ru.bitel.bgbilling.kernel.network.datalog.IPDataLog;
import ru.bitel.bgbilling.kernel.network.flow.FlowArray;
import ru.bitel.bgbilling.kernel.network.flow.NetFlowArray;
import ru.bitel.bgbilling.kernel.network.flow.NetFlowRecord;
import ru.bitel.common.Utils;

public class NetflowDataLogReader
extends BGDataLogReader<IPDataLog>
implements FlowReader {
    private static final Logger log = LogManager.getLogger();
    protected final NetFlowArray recordList;

    public NetflowDataLogReader(IPDataLog dataLog) {
        super(dataLog);
        this.readBuffer.position(this.readBuffer.capacity());
        int recordSize = 48;
        int size = this.readBuffer.capacity() / recordSize;
        this.recordList = new NetFlowArray(size);
    }

    public FlowArray<NetFlowRecord> readChunk() {
        if (!this.readNext()) {
            return null;
        }
        try {
            int offset = this.recordList.next(this.readBuffer);
            if (log.isDebugEnabled()) {
                log.debug("Readed chunk: [flowCount=" + this.recordList.size + "]");
            }
            this.readBuffer.position(offset);
        }
        catch (Exception e) {
            ByteBuffer bb = this.readBuffer.duplicate();
            byte[] dd = new byte[this.readBuffer.remaining()];
            bb.get(dd);
            log.error((Object)((IPDataLog)this.dataLog).getFile());
            log.error(Utils.bytesToString(dd));
            dd = new byte[this.readBuffer.capacity()];
            bb.clear();
            bb.get(dd);
            log.error(Utils.bytesToString(dd));
            log.error("Exception", (Throwable)e);
            this.readBuffer.position(this.readBuffer.limit());
        }
        return this.recordList;
    }
}

