#!/bin/bash


INDEV="eth0"
OUTDEV="eth0"

/sbin/tc qdisc del dev $INDEV root 2> /dev/null
/sbin/tc qdisc del dev $OUTDEV root 2> /dev/null

##### speed server->client(downstream)

/sbin/tc qdisc add dev $INDEV root handle 1: htb default ffff r2q 1

/sbin/tc class add dev $INDEV parent 1:0 classid 1:1 htb rate 128kbit burst 4k prio 1
/sbin/tc class add dev $INDEV parent 1:0 classid 1:2 htb rate 256kbit burst 4k prio 2
/sbin/tc class add dev $INDEV parent 1:0 classid 1:3 htb rate 512kbit burst 4k prio 3
/sbin/tc class add dev $INDEV parent 1:0 classid 1:4 htb rate 1024kbit burst 4k prio 4





/sbin/tc qdisc add dev $INDEV parent 1:1 handle 10: sfq perturb 10 quantum 1500
/sbin/tc qdisc add dev $INDEV parent 1:2 handle 20: sfq perturb 10 quantum 1500
/sbin/tc qdisc add dev $INDEV parent 1:3 handle 30: sfq perturb 10 quantum 1500
/sbin/tc qdisc add dev $INDEV parent 1:4 handle 40: sfq perturb 10 quantum 1500

#default 
/sbin/tc class add dev $INDEV parent 1: classid 1:ffff htb rate 100mbit burst 4k prio 3 
/sbin/tc qdisc add dev $INDEV parent 1:ffff handle ffff: sfq perturb 10 quantum 1500


##### speed client->server(upstream)
if [ $INDEV != $OUTDEV ] ;
then
/sbin/tc qdisc add dev $OUTDEV root handle 1: htb default fffe r2q 1
fi

/sbin/tc class add dev $OUTDEV parent 1: classid 1:5 htb rate 128kbit burst 4k prio 1
/sbin/tc class add dev $OUTDEV parent 1: classid 1:6 htb rate 256kbit burst 4k prio 2
/sbin/tc class add dev $OUTDEV parent 1: classid 1:7 htb rate 512kbit burst 4k prio 3
/sbin/tc class add dev $OUTDEV parent 1: classid 1:8 htb rate 1024kbit burst 4k prio 3

/sbin/tc qdisc add dev $INDEV parent 1:5 handle 50: sfq perturb 10 quantum 1500
/sbin/tc qdisc add dev $INDEV parent 1:6 handle 60: sfq perturb 10 quantum 1500
/sbin/tc qdisc add dev $INDEV parent 1:7 handle 70: sfq perturb 10 quantum 1500
/sbin/tc qdisc add dev $INDEV parent 1:8 handle 80: sfq perturb 10 quantum 1500

#default  
/sbin/tc class add dev $INDEV parent 1: classid 1:fffe htb rate 100mbit burst 4k prio 3
/sbin/tc qdisc add dev $INDEV parent 1:fffe handle fffe: sfq perturb 10 quantum 1500

