/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.dhcp;

import java.beans.ConstructorProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.naming.NamingException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.network.dhcp.datalog.hourly.DhcpHourlyDataLogEntry;
import ru.bitel.bgbilling.modules.inet.server.dhcp.InetDhcpDevice;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Idable;

public class DhcpHourlyDataLogger
extends ru.bitel.bgbilling.kernel.network.dhcp.datalog.hourly.DhcpHourlyDataLogger {
    private static final Logger logger = LogManager.getLogger();

    @ConstructorProperties(value={"scheduledExecutor"})
    public DhcpHourlyDataLogger(ScheduledExecutorService scheduledExecutor) throws NamingException {
        super((ParameterMap)DefaultServerSetup.getEnvironment().lookup("setup"), scheduledExecutor);
        scheduledExecutor.scheduleWithFixedDelay(this.archive(), 20L, 20L, TimeUnit.MINUTES);
    }

    protected DhcpHourlyDataLogEntry newEntry(ParameterMap setup, Idable _source, Calendar hour) throws IOException {
        InetDhcpDevice nas = (InetDhcpDevice)_source;
        return new DhcpHourlyDataLogEntry(setup, "datalog.dhcp.dir", nas.deviceRuntime.inetDeviceId.intValue(), nas.deviceRuntime.config.toString(), "dhcp", hour);
    }

    private Runnable archive() {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    logger.info("Checking old dataLog files for archivation.");
                    File dir = new File(DhcpHourlyDataLogger.this.setup.get("datalog.dhcp.dir", "data/dhcp"));
                    DhcpHourlyDataLogger.archiveImpl(dir);
                }
                catch (Throwable t) {
                    logger.error(t.getMessage(), t);
                }
            }
        };
    }

    private static void archiveImpl(File dir) throws IOException {
        SimpleDateFormat monthFormat = new SimpleDateFormat("yyyy/yyyy-MM");
        GregorianCalendar rangeStartCalendar = new GregorianCalendar();
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)rangeStartCalendar);
        rangeStartCalendar.set(5, 1);
        ((Calendar)rangeStartCalendar).add(1, -3);
        if (dir == null) {
            logger.info("Directory for archivation not found");
            return;
        }
        if (dir.listFiles() == null) {
            logger.info("Directory " + String.valueOf(dir) + " is empty");
            return;
        }
        for (File sourceDir : dir.listFiles()) {
            if (!sourceDir.exists() || !sourceDir.isDirectory() || !sourceDir.getName().startsWith("source_")) continue;
            GregorianCalendar calendar = new GregorianCalendar();
            TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)calendar);
            calendar.set(5, 1);
            ((Calendar)calendar).add(2, -3);
            while (calendar.after(rangeStartCalendar)) {
                String monthString = monthFormat.format(calendar.getTime());
                File monthDir = new File(sourceDir, monthString);
                if (monthDir.exists() && monthDir.isDirectory()) {
                    logger.info("Archive log files for old month " + String.valueOf(monthDir));
                    String sourceFolder = monthDir.getParentFile().getAbsoluteFile().toString();
                    ArrayList<String> fileList = new ArrayList<String>();
                    DhcpHourlyDataLogger.generateFileList(monthDir, sourceFolder, fileList);
                    DhcpHourlyDataLogger.zipIt(sourceFolder, fileList, sourceFolder + File.separator + monthDir.getName() + ".zip");
                    logger.info("Delete directory " + String.valueOf(monthDir));
                    DhcpHourlyDataLogger.deleteDirectory(monthDir);
                    return;
                }
                ((Calendar)calendar).add(2, -1);
            }
        }
    }

    private static void zipIt(String sourceFolder, List<String> fileList, String zipFile) throws IOException {
        byte[] buffer = new byte[65536];
        FileOutputStream fos = new FileOutputStream(zipFile);
        ZipOutputStream zos = new ZipOutputStream(fos);
        zos.setLevel(1);
        for (String file : fileList) {
            int len;
            ZipEntry ze = new ZipEntry(file);
            zos.putNextEntry(ze);
            FileInputStream in = new FileInputStream(sourceFolder + File.separator + file);
            while ((len = in.read(buffer)) > 0) {
                zos.write(buffer, 0, len);
            }
            in.close();
        }
        zos.closeEntry();
        zos.close();
    }

    private static void generateFileList(File node, String sourceFolder, List<String> fileList) {
        if (node.isFile()) {
            fileList.add(DhcpHourlyDataLogger.generateZipEntry(node.getAbsoluteFile().toString(), sourceFolder));
        }
        if (node.isDirectory()) {
            String[] subNote;
            for (String filename : subNote = node.list()) {
                DhcpHourlyDataLogger.generateFileList(new File(node, filename), sourceFolder, fileList);
            }
        }
    }

    private static String generateZipEntry(String file, String sourceFolder) {
        return file.substring(sourceFolder.length() + 1, file.length());
    }

    private static boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    DhcpHourlyDataLogger.deleteDirectory(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        return path.delete();
    }
}

